#include "_Global.h"

class Main extends _Main
{
	var g:_Graphics;

	var load_vars:_LoadVars;
	var ret:Boolean;
	var image:Array;

	var load_movie:_LoadMovie;
	var status:String;

	var res:_MovieClip;
	var clip1:_MovieClip;
	var clip2:_MovieClip;
	var clip3:_MovieClip;
	var clip4:_MovieClip;
	var res_str:String;

	var step:Number;

	function start():Boolean
	{
		var i:Number;

		g = getGraphics();

		load_vars = new _LoadVars( this );
		ret = false;
		image = new Array( 8 );
		for( i = 0; i < 8; i++ )
		{
			image[i] = new String( "" );
		}

		load_movie = new _LoadMovie( this );
		status = new String( "" );

		clip1 = null;//new _MovieClip();
		clip2 = null;//new _MovieClip();
		clip3 = null;//new _MovieClip();
		clip4 = null;//new _MovieClip();
		res_str = new String( "" );

		step = -2;

		return true;
	}

	function paint():Void
	{
		g.lock();
		g.setFont( _FONT_TINY );
		g.setColor( g.getColorOfRGB( 0, 0, 255 ) );
		g.drawString( "0123456789012345678901234567890123456789", 0, 180 );

		if( !load_movie.busy() )
		{
			// I[i[̃[r[Nbv́A܂Ƃ߂ĕ`悷II
			if( clip2 != null )
			{
				g.drawScaledMovie( clip2, 50, 50, 100, 100 );
			}
			if( clip1 != null )
			{
				g.drawScaledMovie( clip1, 25, 0, 100, 100 );
			}
			if( clip3 != null )
			{
				g.drawScaledMovie( clip3, 75, 100, 100, 100 );
			}
			if( clip4 != null )
			{
				g.drawScaledMovie( clip4, 100, 150, 100, 100 );
			}
		}

		g.drawString( "0123456789012345678901234567890123456789", 0, 200 );
		g.drawString( "user: " + getParameter( "user" ), 0, 12 );
		if( step >= -1 )
		{
			g.drawString( "LoadVars " + ret, 0, 32 );
			g.drawString( image[0], 0,  44 );
			g.drawString( image[1], 0,  56 );
			g.drawString( image[2], 0,  68 );
			g.drawString( image[3], 0,  80 );
			g.drawString( image[4], 0,  92 );
			g.drawString( image[5], 0, 104 );
			g.drawString( image[6], 0, 116 );
			g.drawString( image[7], 0, 128 );
		}
		if( step >= 0 )
		{
			g.drawString( image[_MOD( step, 8 )], 0, 148 );
			g.drawString( "LoadMovie " + status, 0, 160 );
		}
		g.drawString( res_str, 240 - g.stringWidth( res_str ), 12 );
		g.unlock();
	}

	function processEvent( type:Number, param:Number ):Void
	{
		if( type == _KEY_PRESSED_EVENT )
		{
			if( load_vars.busy() ) return;
			if( load_movie.busy() ) return;

			step++;
			if( step == -1 )
			{
				// CGI/PHP ɓnp[^ݒ
				var vars:LoadVars = new LoadVars();
				vars.user = getParameter( "user" );

				load_vars.connect( "test." + getParameter( "type" ), vars, "POST" );
			}
			else
			{
				res = load_movie.load( 0, image[_MOD( step, 8 )] );
			}
		}
	}

	function onLoadVars( success:Boolean, vars:LoadVars ):Void
	{
		ret = success;

		// p[^󂯎
		image[0] = vars.image1;
		image[1] = vars.image2;
		image[2] = vars.image3;
		image[3] = vars.image4;
		image[4] = vars.image5;
		image[5] = vars.image6;
		image[6] = vars.image7;
		image[7] = vars.image8;
	}

	function onLoadMovieStart():Void
	{
		status = "Start";
	}
	function onLoadMovieError( errorCode:String, httpStatus:Number ):Void
	{
		status = "Error";
	}
	function onLoadMovieProgress( loadedBytes:Number, totalBytes:Number ):Void
	{
		status = "" + loadedBytes + "/" + totalBytes;
	}
	function onLoadMovieComplete( httpStatus:Number ):Void
	{
		status = "Complete";
	}
	function onLoadMovieInit():Void
	{
		status = "Init";

		if( _MOD( step, 8 ) == 7 )
		{
			clip1 = new _MovieClip();
			clip2 = new _MovieClip();
			clip3 = new _MovieClip();
			clip4 = new _MovieClip();
			clip1.attach( res, "gif", "clip1" );
			clip2.attach( res, "jpg", "clip2" );
			clip3.attach( res, "png", "clip3" );
			clip4.attach( res, "swf", "clip4" );
			res_str = res.getString( "str" );
		}
		else
		{
			clip1 = res;
			clip2 = null;
			clip3 = null;
			clip4 = null;
			res_str = "";
		}
	}
}
