#include "_Global.h"

class Main extends _Main
{
	var g:_Graphics;

	var key_press:Number;
	var key_release:Number;

	var focus:String;

	var input1:_Input;
	var input2:_Input;
	var input3:_Input;
	var text1:String;
	var text2:String;
	var text3:String;
	var input_mode:Boolean;

	function start():Boolean
	{
		var ref:Object = this;

		g = getGraphics();

		key_press = -1;
		key_release = -1;

		focus = new String( "" );

		input1 = new _Input( this );
		input2 = new _Input( this );
		input3 = new _Input( this );
		text1 = new String( getResString( 0 ) );
		text2 = new String( getResString( 5 ) );
		text3 = new String( getResString( 10 ) );
		input_mode = false;

		return true;
	}

	function paint():Void
	{
		g.lock();
		g.setColor( g.getColorOfRGB( 127, 127, 127 ) );
		g.fillRect( 0, 0, 240, 240 );
		if( !input_mode )
		{
			g.setColor( g.getColorOfRGB( 0, 0, 255 ) );
			g.setFont( _FONT_TINY );
			g.drawString( text1, 20, 40 + g.fontHeight() );
			g.setFont( _FONT_SMALL );
			g.drawString( text2, 40, 80 + g.fontHeight() );
			g.setFont( _FONT_MEDIUM );
			g.drawString( text3, 60, 120 + g.fontHeight() );
		}
		g.setColor( g.getColorOfRGB( 255, 0, 0 ) );
		g.setFont( _FONT_TINY );
		g.drawString( "old_focus " + _old_focus, 0, 12 );
		g.drawString( "new_focus " + _new_focus, 0, 24 );
		g.drawString( "focus " + focus, 0, 36 );
#ifdef _DEBUG
		g.drawString( "ascii " + _key_ascii, 0, 204 );
#endif // _DEBUG
		g.drawString( "key " + getKeypadState(), 0, 216 );
		g.drawString( "press " + key_press, 0, 228 );
		g.drawString( "release " + key_release, 0, 240 );
		g.unlock();
	}

	function processEvent( type:Number, param:Number ):Void
	{
		switch( type )
		{
		case _KEY_PRESSED_EVENT:
			switch( param )
			{
			case _KEY_3:
				if( input_mode )
				{
					input_mode = false;

					text1 = input1.getText();
					text2 = input2.getText();
					text3 = input3.getText();
					input1.remove();
					input2.remove();
					input3.remove();

					useFocus();
					focus = "use";
				}
				break;
			}
			key_press = param;
			break;
		case _KEY_RELEASED_EVENT:
			switch( param )
			{
			case _KEY_1:
				if( !input_mode )
				{
					input_mode = true;

					input1.create( 0, 20, 40, 100, 30, _FONT_TINY );
					input1.setText( text1 );
					input2.create( 1, 40, 80, 100, 30, _FONT_SMALL );
					input2.setText( text2 );
					input3.create( 2, 60, 120, 100, 30, _FONT_MEDIUM );
					input3.setText( text3 );

					input1.setFocus();

					unuseFocus();
					focus = "unuse";
				}
				break;
			}
			key_release = param;
			break;
		case _FOCUS_PREV_EVENT:
			focus = "prev";
			break;
		case _FOCUS_NEXT_EVENT:
			focus = "next";
			break;
		}
	}
}
