/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _SoftKey
{
	var _left:Array;
	var _top:Array;
	var _right:Array;
	var _bottom:Array;
	var _ascii:Array;
	var _code:Array;
	var _num:Number;

	var _check_ascii:Number;
	var _check_code:Number;

	function _SoftKey( num:Number )
	{
		_left   = new Array( num );
		_top    = new Array( num );
		_right  = new Array( num );
		_bottom = new Array( num );
		_ascii  = new Array( num );
		_code   = new Array( num );
		_num = 0;

		_check_ascii = -1;
		_check_code  = -1;
	}

	function clear():Void
	{
		_num = 0;
	}

	function add( left:Number, top:Number, width:Number, height:Number, code:Number, ascii:Number ):Void
	{
		_left  [_num] = left;
		_top   [_num] = top;
		_right [_num] = left + width;
		_bottom[_num] = top + height;
		_code  [_num] = code;
		_ascii [_num] = ascii;
		_num++;
	}

	function num():Number
	{
		return _num;
	}

	function left( index:Number ):Number
	{
		return _left[index];
	}

	function top( index:Number ):Number
	{
		return _top[index];
	}

	function right( index:Number ):Number
	{
		return _right[index];
	}

	function bottom( index:Number ):Number
	{
		return _bottom[index];
	}

	function width( index:Number ):Number
	{
		return _right[index] - _left[index];
	}

	function height( index:Number ):Number
	{
		return _bottom[index] - _top[index];
	}

	function ascii( index:Number ):Number
	{
		return _ascii[index];
	}

	function code( index:Number ):Number
	{
		return _code[index];
	}

	function check( x:Number, y:Number ):Boolean
	{
		var i:Number;
		for( i = 0; i < _num; i++ )
		{
			if( (x >= _left[i]) && (x < _right [i]) &&
				(y >= _top [i]) && (y < _bottom[i]) )
			{
				_check_ascii = _ascii[i];
				_check_code  = _code [i];
				return true;
			}
		}
		return false;
	}

	function getAscii():Number
	{
		return _check_ascii;
	}

	function getCode():Number
	{
		return _check_code;
	}
}
