/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _Music
{
	var _m:_Main;

	var _music:Sound;
	var _ready:Boolean;
	var _loop:Boolean;

	function _Music( m:_Main )
	{
		var ref:Object = this;

		_m = m;

		_m.createEmptyMovieClip( _MUSIC_NAME, _MUSIC_DEPTH );
		_music = new Sound( _m[_MUSIC_NAME] );
		_music.onLoad = function( success:Boolean ):Void
		{
			ref._ready = true;
		};
		_music.onSoundComplete = function():Void
		{
			if( ref._loop )
			{
				ref._music.start();
			}
			else
			{
				ref._m.musicComplete( ref );
			}
		};

		_ready = false;
	}

	function attach( id:String ):Void
	{
		_music.attachSound( id );
		_ready = true;
	}

	function load( url:String ):Void
	{
		_music.loadSound( url );
	}

	function ready():Boolean
	{
		return _ready;
	}

	function play( loop:Boolean ):Void
	{
		_loop = loop;
		_music.start();
	}

	function stop():Void
	{
		_music.stop();
	}

	function setVolume( volume:Number ):Void
	{
		_music.setVolume( volume );
	}
}
