/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _Main extends MovieClip
{
	// _Graphics クラス
	var _g:_Graphics;

	// キー関連
	var _key:Number;
	var _key_press:Number;
	var _key_release:Number;
#ifdef _DEBUG
	var _key_ascii:Number;
#endif // _DEBUG

#ifdef _USE_SOFTKEY
	// ソフトキー関連
	var _softkey:_SoftKey;
#endif // _USE_SOFTKEY

#if defined( _USE_MOUSE ) || defined( _USE_SOFTKEY )
	// マウス関連
	var _mouse_x:Number;
	var _mouse_y:Number;
#ifdef _USE_SOFTKEY
	var _mouse_down:Boolean;
#endif // _USE_SOFTKEY
#endif // defined( _USE_MOUSE ) || defined( _USE_SOFTKEY )

#ifdef _USE_FOCUS
	// フォーカス関連
	var _input1:TextField;
	var _input2:TextField;
	var _input3:TextField;
	var _old_focus:Number;
	var _new_focus:Number;
#endif // _USE_FOCUS

	function _Main()
	{
		var ref:Object = this;

		_g = new _Graphics( this );

		// キー関連
		_key = 0;
		_key_press   = -1;
		_key_release = -1;
#ifdef _DEBUG
		_key_ascii   = -1;
#endif // _DEBUG

#ifdef _USE_SOFTKEY
		// ソフトキー関連
		_softkey = null;

		// マウス関連
		_mouse_down = false;
#endif // _USE_SOFTKEY

		// キーイベント
		var keyListener:Object = new Object();
		keyListener.onKeyDown = function():Void
		{
			ref._key_press = ref.getKey();
			var k:Number = ref.keyBit( ref._key_press );
			if( (ref._key & k) == 0 )
			{
				ref._key += k;
			}
			ref.processEvent( _KEY_PRESSED_EVENT, ref._key_press );
		};
		keyListener.onKeyUp = function():Void
		{
			ref._key_release = ref.getKey();
			var k:Number = ref.keyBit( ref._key_release );
			if( (ref._key & k) != 0 )
			{
				ref._key -= k;
			}
			ref.processEvent( _KEY_RELEASED_EVENT, ref._key_release );
		};
		Key.addListener( keyListener );

#if defined( _USE_MOUSE ) || defined( _USE_SOFTKEY )
		//マウスイベント
		var mouseListener:Object = new Object();
		mouseListener.onMouseDown = function():Void
		{
			ref._mouse_x = Math.floor( ref._xmouse );
			ref._mouse_y = Math.floor( ref._ymouse );
#ifdef _USE_SOFTKEY
			ref._mouse_down = true;
			if( ref._softkey != null )
			{
				ref._key_press = -1;
				if( ref._softkey.check( ref._mouse_x, ref._mouse_y ) )
				{
					ref._key_press = ref._softkey.getCode();
					ref._key = ref.keyBit( ref._key_press );
					ref.processEvent( _KEY_PRESSED_EVENT, ref._key_press );
				}
			}
#endif // _USE_SOFTKEY
#ifdef _USE_MOUSE
			ref.processEvent( _MOUSE_DOWN_EVENT, 0 );
#endif // _USE_MOUSE
		};
		mouseListener.onMouseMove = function():Void
		{
			ref._mouse_x = Math.floor( ref._xmouse );
			ref._mouse_y = Math.floor( ref._ymouse );
#ifdef _USE_SOFTKEY
			if( ref._mouse_down )
			{
				if( ref._softkey != null )
				{
					if( ref._softkey.check( ref._mouse_x, ref._mouse_y ) )
					{
						if( ref._softkey.getCode() != ref._key_press )
						{
							if( ref._key_press >= 0 )
							{
								ref._key_release = ref._key_press;
								ref.processEvent( _KEY_RELEASED_EVENT, ref._key_release );
							}
							ref._key_press = ref._softkey.getCode();
							ref._key = ref.keyBit( ref._key_press );
							ref.processEvent( _KEY_PRESSED_EVENT, ref._key_press );
						}
					}
				}
			}
#endif // _USE_SOFTKEY
#ifdef _USE_MOUSE
			ref.processEvent( _MOUSE_MOVE_EVENT, 0 );
#endif // _USE_MOUSE
		};
		mouseListener.onMouseUp = function():Void
		{
			ref._mouse_x = Math.floor( ref._xmouse );
			ref._mouse_y = Math.floor( ref._ymouse );
#ifdef _USE_SOFTKEY
			ref._mouse_down = false;
			if( ref._softkey != null )
			{
				if( ref._key_press >= 0 )
				{
					ref._key_release = ref._key_press;
					ref.processEvent( _KEY_RELEASED_EVENT, ref._key_release );
					ref._key_press = -1;
					ref._key = 0;
				}
			}
#endif // _USE_SOFTKEY
#ifdef _USE_MOUSE
			ref.processEvent( _MOUSE_UP_EVENT, 0 );
#endif // _USE_MOUSE
		};
		Mouse.addListener( mouseListener );
#endif // defined( _USE_MOUSE ) || defined( _USE_SOFTKEY )

#ifdef _USE_FOCUS
		// フォーカス関連
		_old_focus = -1;
		_new_focus = -1;
		createTextField( _FOCUS1_NAME, _FOCUS1_DEPTH, 0, 0, 0, 0 );
		_input1 = this[_FOCUS1_NAME];
		_input1._focusrect = false;
		_input1.border     = false;
		_input1.selectable = true;
		_input1.type       = "input";
		createTextField( _FOCUS2_NAME, _FOCUS2_DEPTH, 0, 1, 0, 0 );
		_input2 = this[_FOCUS2_NAME];
		_input2._focusrect = false;
		_input2.border     = false;
		_input2.selectable = true;
		_input2.type       = "input";
		createTextField( _FOCUS3_NAME, _FOCUS3_DEPTH, 0, 2, 0, 0 );
		_input3 = this[_FOCUS3_NAME];
		_input3._focusrect = false;
		_input3.border     = false;
		_input3.selectable = true;
		_input3.type       = "input";
		_input1.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 0 );
			ref.processEvent( ref.checkFocus(), 0 );
		};
		_input2.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 1 );
			ref.processEvent( ref.checkFocus(), 0 );
		};
		_input3.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 2 );
			ref.processEvent( ref.checkFocus(), 0 );
		};
#endif // _USE_FOCUS

		// ゲームの開始
		if( ref.start() )
		{
			setTimer();
		}
	}

	function setQuality( quality:String ):Void
	{
		_quality = quality;
	}

	function setTimer():Void
	{
		var ref:Object = this;
		onEnterFrame = function():Void
		{
			ref.paint();
		};
	}

	function killTimer():Void
	{
		delete onEnterFrame;
	}

	function repaint():Void
	{
		var ref:Object = this;
		ref.paint();
	}

	function readParameter( text:String, key:String ):String
	{
		var ret:String = new String( "" );
		var start:Number = text.indexOf( key + "=", 0 );
		if( start >= 0 )
		{
			start += key.length + 1;
			var end:Number = text.indexOf( "&", start );
			if( end < 0 ) end = text.length;
			ret = text.substring( start, end );
		}
		return unescape( ret );
	}
	function getParameter( key:String ):String
	{
		return readParameter( _url, key );
	}

	function getGraphics():_Graphics
	{
		return _g;
	}

	function getKey():Number
	{
#ifdef _DEBUG
		_key_ascii = Key.getAscii();
		switch( _key_ascii )
#else
		switch( Key.getAscii() )
#endif // _DEBUG
		{
		case _ASCII_POUND   : return _KEY_POUND;
		case _ASCII_ASTERISK: return _KEY_ASTERISK;
		}
		return Key.getCode();
	}

	function getKeypadState():Number
	{
		return _key;
	}

	function keyBit( key:Number ):Number
	{
		var bit:Number;
		switch( key )
		{
		case _KEY_BACKSPACE: bit =  0; break;
		case _KEY_TAB      : bit =  1; break;
		case _KEY_ENTER    : bit =  2; break;
		case _KEY_SHIFT    : bit =  3; break;
		case _KEY_CTRL     : bit =  4; break;
		case _KEY_SPACE    : bit =  5; break;
		case _KEY_LEFT     : bit =  6; break;
		case _KEY_UP       : bit =  7; break;
		case _KEY_RIGHT    : bit =  8; break;
		case _KEY_DOWN     : bit =  9; break;
		case _KEY_0        : bit = 10; break;
		case _KEY_1        : bit = 11; break;
		case _KEY_2        : bit = 12; break;
		case _KEY_3        : bit = 13; break;
		case _KEY_4        : bit = 14; break;
		case _KEY_5        : bit = 15; break;
		case _KEY_6        : bit = 16; break;
		case _KEY_7        : bit = 17; break;
		case _KEY_8        : bit = 18; break;
		case _KEY_9        : bit = 19; break;
		case _KEY_C        : bit = 20; break;
		case _KEY_X        : bit = 21; break;
		case _KEY_Z        : bit = 22; break;
		case _KEY_POUND    : bit = 23; break;
		case _KEY_ASTERISK : bit = 24; break;
		default:
			return 0;
		}
		return (1 << bit);
	}

	function getResString( id:Number ):String
	{
		return _parent[_STRING_PREFIX + id].text;
	}

#ifdef _USE_SOFTKEY
	function setSoftKey( softkey:_SoftKey ):Void
	{
		_softkey = softkey;
	}
#endif // _USE_SOFTKEY

#ifdef _USE_MOUSE
	function getMouseX():Number
	{
		return _mouse_x;
	}

	function getMouseY():Number
	{
		return _mouse_y;
	}
#endif // _USE_MOUSE

#ifdef _USE_FOCUS
	function setFocus( new_focus:Number ):Void
	{
		_new_focus = new_focus;
		_input1._visible = (_new_focus == 0) ? false : true;
		_input2._visible = (_new_focus == 1) ? false : true;
		_input3._visible = (_new_focus == 2) ? false : true;
	}

	function checkFocus():Number
	{
		if( _old_focus != _new_focus )
		{
			if( _old_focus == 0 )
			{
				if( _new_focus == 1 )
				{
					return _FOCUS_NEXT_EVENT;
				}
				else
				{
					return _FOCUS_PREV_EVENT;
				}
			}
			else
			{
				if( _new_focus == 0 )
				{
					return _FOCUS_NEXT_EVENT;
				}
				else
				{
					return _FOCUS_PREV_EVENT;
				}
			}
		}
		return _NULL_EVENT;
	}

	function unuseFocus():Void
	{
		_input1._visible = false;
		_input2._visible = false;
		_input3._visible = false;
	}

	function useFocus():Void
	{
		setFocus( _new_focus );
	}
#endif // _USE_FOCUS

	function launch( url:String, vars:LoadVars ):Void
	{
		if( vars == null )
		{
			getURL( url );
		}
		else
		{
			getURL( url + "?" + vars.toString() );
		}
	}

//	function start():Boolean { return true; }

//	function paint():Void {}

//	function processEvent( type:Number, param:Number ):Void {}

	// _LoadMovie クラス用
//	function onLoadMovieStart():Void {}
//	function onLoadMovieError( errorCode:String, httpStatus:Number ):Void {}
//	function onLoadMovieProgress( loadedBytes:Number, totalBytes:Number ):Void {}
//	function onLoadMovieComplete( httpStatus:Number ):Void {}
//	function onLoadMovieInit():Void {}

	// _LoadText クラス用
//	function onLoadText( text:String ):Void {}

	// _LoadVars クラス用
//	function onLoadVars( success:Boolean, vars:LoadVars ):Void {}

	// _Music クラス用
//	function musicComplete( music:_Music ):Void {}
}
