/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _LoadMovie
{
	var _m:_Main;

	var _loader:MovieClipLoader;
	var _busy:Boolean;

	function _LoadMovie( m:_Main )
	{
		var ref:Object = this;

		_m = m;

		var listener:Object = new Object();
		listener.onLoadStart = function( target:MovieClip ):Void
		{
			target._visible = false;
			ref._m.onLoadMovieStart();
		};
		listener.onLoadError = function( target:MovieClip, errorCode:String, httpStatus:Number ):Void
		{
			target._visible = false;
			ref._m.onLoadMovieError( errorCode, httpStatus );
			ref._busy = false;
		};
		listener.onLoadProgress = function( target:MovieClip, loadedBytes:Number, totalBytes:Number ):Void
		{
			target._visible = false;
			ref._m.onLoadMovieProgress( loadedBytes, totalBytes );
		};
		listener.onLoadComplete = function( target:MovieClip, httpStatus:Number ):Void
		{
			target._visible = false;
			ref._m.onLoadMovieComplete( httpStatus );
		};
		listener.onLoadInit = function( target:MovieClip ):Void
		{
			target._visible = false;
			ref._m.onLoadMovieInit();
			ref._busy = false;
		};
		_loader = new MovieClipLoader();
		_loader.addListener( listener );

		_busy = false;
	}

	function load( id:Number, url:String ):_MovieClip
	{
		_m[_LOADMOVIE_NAME + id].removeMovieClip();
		_m.createEmptyMovieClip( _LOADMOVIE_NAME + id, _LOADMOVIE_DEPTH + id );
		var clip:_MovieClip = new _MovieClip();
		clip._clip = _m[_LOADMOVIE_NAME + id];
		clip._depth = _LOADMOVIE_DEPTH + id;
		clip._owner = null;
		_busy = true;
		if( _loader.loadClip( url, clip._clip ) )
		{
			return clip;
		}
		_busy = false;
		return null;
	}

	function busy():Boolean
	{
		return _busy;
	}
}
