/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

import flash.display.*;
import flash.geom.*;

#define createShape() \
	_shape.clear();\
	_shape.lineStyle( 1, _col )

#define createString() \
	_string.textColor = _col

#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

#define cos4096(r1024) \
	sin4096( (r1024) + 256 )

#define _NULL_ID	0
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
#define _SHAPE_ID	1
#define _STRING_ID	2
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
#define _BITMAP_ID	3
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
#ifdef _USE_MOVIE
#define _MOVIE_ID	4
#endif // _USE_MOVIE
#define _IMAGE_TOP	5

class _Graphics
{
	var _m:_Main;

	// 色
	var _col:Number;

	// 透明度
	var _a:Number;

	// フリップ
	var _flip:Number;

	// 文字フォーマット
	var _text:TextField;
	var _format:Array;
	var _font_h:Array;
	var _font:Number;

#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	// シェイプ
	var _shape:MovieClip;

	// 文字列
	var _string:TextField;

	// ビットマップデータ
	var _temp:BitmapData;
	var _alpha:BitmapData;
	var _bitmap:BitmapData;

	var _point:Point;
	var _rect:Rectangle;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

	// 描画オブジェクト
	var _draw:Array;
#ifdef _USE_MOVIE
	var _draw_d:Array;
	var _owner:Array;
	var _owner_d:Array;
#endif // _USE_MOVIE
	var _draw_id:Array;

	var _d:Number;
	var _last_d:Number;

#ifdef _DEBUG
	var _create:Number;
	var _attach:Number;
#endif // _DEBUG

	function _Graphics( m:_Main )
	{
		var i:Number;

		_m = m;

		// 色
		_col = 0x000000;

		// 透明度
		_a = 100;

		// フリップ
		_flip = _FLIP_NONE;

		// 文字フォーマット
		_m.createTextField( _TEXT_NAME, _TEXT_DEPTH, 0, 0, 0, 0 );
		_text = _m[_TEXT_NAME];
		_text.selectable = false;
		_text.autoSize = "left";
		_text._visible = false;
		_text.text = " ";
		_format = new Array( 4 );
		_font_h = new Array( 4 );
		createFormat( _FONT_TINY  , 12 );
		createFormat( _FONT_SMALL , 16 );
		createFormat( _FONT_MEDIUM, 24 );
		createFormat( _FONT_LARGE , 30 );
		_font = _FONT_TINY;

#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		// シェイプ
		_m.createEmptyMovieClip( _SHAPE_NAME, _SHAPE_DEPTH );
		_shape = _m[_SHAPE_NAME];
		_shape._visible = false;

		// 文字列
		_m.createTextField( _STRING_NAME, _STRING_DEPTH, 0, 0, 0, 0 );
		_string = _m[_STRING_NAME];
		_string.selectable = false;
		_string.autoSize = "left";
		_string._visible = false;

		// ビットマップデータ
		_temp = new BitmapData( _WIDTH, _HEIGHT, true, 0x00000000 );
		_alpha = new BitmapData( _WIDTH, _HEIGHT, true, 0xff000000 );
		_bitmap = new BitmapData( _WIDTH, _HEIGHT, false, 0xffffff );
		_m.attachBitmap( _bitmap, _BITMAP_DEPTH );

		_point = new Point( 0, 0 );
		_rect = new Rectangle( 0, 0, _WIDTH, _HEIGHT );
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

		// 描画オブジェクト
		_draw = new Array( _DRAW_NUM );
#ifdef _USE_MOVIE
		_draw_d = new Array( _DRAW_NUM );
		_owner = new Array( _DRAW_NUM );
		_owner_d = new Array( _DRAW_NUM );
#endif // _USE_MOVIE
		_draw_id = new Array( _DRAW_NUM );
		for( i = 0; i < _DRAW_NUM; i++ )
		{
			_draw_id[i] = _NULL_ID;
		}

		_d = 0;
		_last_d = 0;

#ifdef _DEBUG
		_create = 0;
		_attach = 0;
#endif // _DEBUG
	}

	function createFormat( font:Number, size:Number ):Void
	{
		var i:Number;
		_format[font] = new TextFormat( "_等幅" );
		for( i = size; i >= 1; i-- )
		{
			_format[font].size = i;
			_text.setTextFormat( _format[font] );
			if( _text.textHeight <= size ) break;
		}
		_font_h[font] = size;
	}

	function getColorOfRGB( r255:Number, g255:Number, b255:Number ):Number
	{
		return ((r255 << 16) + (g255 << 8) + b255);
	}

	function setColor( col:Number ):Void
	{
		_col = col;
		_format[_FONT_TINY  ].color = col;
		_format[_FONT_SMALL ].color = col;
		_format[_FONT_MEDIUM].color = col;
		_format[_FONT_LARGE ].color = col;
	}

	function setAlpha( a255:Number ):Void
	{
		_a = (100 * a255) / 255;
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_alpha.fillRect( _rect, a255 << 24 );
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	}

	function setFlipMode( flip:Number ):Void
	{
		_flip = flip;
	}

	function setFont( font:Number ):Void
	{
		_font = font;
	}

	function stringWidth( str:String ):Number
	{
		_text.text = str;
		_text.setTextFormat( _format[_font] );
		return _text.textWidth;
	}

	function fontHeight():Number
	{
		return _font_h[_font];
	}

	function lock():Void
	{
		_d = 0;
#ifdef _DEBUG
		_create = 0;
		_attach = 0;
#endif // _DEBUG
	}

#ifdef _USE_MOVIE
	function detachMovie( d:Number ):Void
	{
		if( _draw_id[d] == _MOVIE_ID )
		{
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
			_draw[d]._visible = false;
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
			if( _owner[d] != null )
			{
				if( _owner[d].getDepth() == _DRAW_DEPTH + d )
				{
					_owner[d].swapDepths( _owner_d[d] );
				}
			}
			_draw[d].swapDepths( _draw_d[d] );
		}
	}
#endif // _USE_MOVIE

	function unlock():Void
	{
		var i:Number;
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		for( i = 0; i < _d; i++ )
		{
			_draw[i]._visible = true;
		}
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		for( ; i < _last_d; i++ )
		{
#ifdef _USE_MOVIE
			detachMovie( i );
#endif // _USE_MOVIE
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
			_draw[i]._visible = false;
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
			_draw_id[i] = _NULL_ID;
		}
		_last_d = _d;
	}

	function getDepth():Number
	{
		return _d;
	}

	function setDepth( depth:Number ):Void
	{
		if( depth > _d )
		{
			_d = depth;
		}
	}

	function createImage( clip_id:Number ):Void
	{
#ifdef _USE_MOVIE
		detachMovie( _d );
#endif // _USE_MOVIE
		if( _draw_id[_d] != _IMAGE_TOP + clip_id )
		{
			if( _draw_id[_d] < _IMAGE_TOP )
			{
				_m.createEmptyMovieClip( _IMAGE_NAME + _d, _DRAW_DEPTH + _d );
				_draw[_d] = _m[_IMAGE_NAME + _d];
#ifdef _DEBUG
				_create++;
#endif // _DEBUG
			}
			_draw[_d].attachMovie( _IMAGE_PREFIX + clip_id, _IMAGE_PREFIX + clip_id, _DRAW_DEPTH + _d );
#ifdef _DEBUG
			_attach++;
#endif // _DEBUG
			_draw_id[_d] = _IMAGE_TOP + clip_id;
		}
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		_draw[_d]._alpha = _a;
		_draw[_d]._rotation = 0;
		_draw[_d]._xscale = 100;
		_draw[_d]._yscale = 100;
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		_draw[_d]._visible = false;
	}

#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	function createBitmap( bitmap:BitmapData ):Void
	{
#ifdef _USE_MOVIE
		detachMovie( _d );
#endif // _USE_MOVIE
		if( _draw_id[_d] != _BITMAP_ID )
		{
			_m.createEmptyMovieClip( _BITMAP_NAME + _d, _DRAW_DEPTH + _d );
			_draw[_d] = _m[_BITMAP_NAME + _d];
#ifdef _DEBUG
			_create++;
#endif // _DEBUG
			_draw_id[_d] = _BITMAP_ID;
		}
		_draw[_d].attachBitmap( bitmap, _DRAW_DEPTH + _d );
#ifdef _DEBUG
		_attach++;
#endif // _DEBUG
		_draw[_d]._visible = false;
	}
	function createBitmapArea( clip_id:Number, x:Number, y:Number, w:Number, h:Number ):Void
	{
		_m.createEmptyMovieClip( _BITMAPDATA_NAME, _BITMAPDATA_DEPTH );
		var tmp:MovieClip = _m[_BITMAPDATA_NAME];
		tmp.attachMovie( _IMAGE_PREFIX + clip_id, _IMAGE_PREFIX + clip_id, _BITMAPDATA_DEPTH );
		var bitmap:BitmapData = new BitmapData( w, h, true, 0x00000000 );
		var mat:Matrix = new Matrix();
		mat.translate( -x, -y );
		bitmap.draw( tmp, mat );
		tmp.removeMovieClip();
		createBitmap( bitmap );
	}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

#ifdef _USE_MOVIE
	function attachMovie( movie:_MovieClip ):Void
	{
		detachMovie( _d );
		if( _draw_id[_d] != _MOVIE_ID )
		{
			_m.createEmptyMovieClip( _MOVIE_NAME + _d, _DRAW_DEPTH + _d );
			_draw[_d] = _m[_MOVIE_NAME + _d];
#ifdef _DEBUG
			_create++;
#endif // _DEBUG
			_draw_id[_d] = _MOVIE_ID;
		}
		if( movie._owner != null )
		{
			_owner[_d] = movie._owner;
			_owner_d[_d] = movie._owner_depth;
			_owner[_d].swapDepths( _DRAW_DEPTH + _d );
			_owner[_d]._x = 0;
			_owner[_d]._y = 0;
			_owner[_d]._visible = true;
		}
		_draw[_d] = movie._clip;
		_draw_d[_d] = _draw[_d].getDepth();
		_draw[_d].swapDepths( _DRAW_DEPTH + _d );
#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		_draw[_d]._alpha = _a;
		_draw[_d]._rotation = 0;
		_draw[_d]._xscale = 100;
		_draw[_d]._yscale = 100;
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
		_draw[_d]._visible = false;
	}
#endif // _USE_MOVIE

#if !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )
	function createShape():Void
	{
#ifdef _USE_MOVIE
		detachMovie( _d );
#endif // _USE_MOVIE
		if( _draw_id[_d] != _SHAPE_ID )
		{
			_m.createEmptyMovieClip( _SHAPE_NAME + _d, _DRAW_DEPTH + _d );
			_draw[_d] = _m[_SHAPE_NAME + _d];
#ifdef _DEBUG
			_create++;
#endif // _DEBUG
			_draw_id[_d] = _SHAPE_ID;
		}
		_draw[_d]._alpha = _a;
		_draw[_d].clear();
		_draw[_d].lineStyle( 1, _col );
		_draw[_d]._visible = false;
	}

	function createString():Void
	{
#ifdef _USE_MOVIE
		detachMovie( _d );
#endif // _USE_MOVIE
		if( _draw_id[_d] != _STRING_ID )
		{
			_m.createTextField( _STRING_NAME + _d, _DRAW_DEPTH + _d, 0, 0, 0, 0 );
			_draw[_d] = _m[_STRING_NAME + _d];
			_draw[_d].selectable = false;
			_draw[_d].autoSize = "left";
#ifdef _DEBUG
			_create++;
#endif // _DEBUG
			_draw_id[_d] = _STRING_ID;
		}
		_draw[_d].textColor = _col;
		_draw[_d]._visible = false;
	}
#endif // !defined( _USE_BITMAPDATA ) && !defined( _USE_BITMAPDATAEX )

	function drawClip( x:Number, y:Number ):Void
	{
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		var pos:Matrix = new Matrix();
		if( _flip == _FLIP_NONE )
		{
			pos.translate( x, y );
		}
		else
		{
			var rect:Object = _draw[_d].getBounds( _m );
			switch( _flip )
			{
			case _FLIP_HORIZONTAL:
				pos.scale( -1, 1 );
				pos.translate( x + (rect.xMax - rect.xMin), y );
				break;
			case _FLIP_VERTICAL:
				pos.scale( 1, -1 );
				pos.translate( x, y + (rect.yMax - rect.yMin) );
				break;
			case _FLIP_ROTATE:
				pos.scale( -1, -1 );
				pos.translate( x + (rect.xMax - rect.xMin), y + (rect.yMax - rect.yMin) );
				break;
			}
		}
		if( _a == 100 )
		{
			_bitmap.draw( _draw[_d], pos );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _draw[_d], pos );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		if( _flip == _FLIP_NONE )
		{
			_draw[_d]._x = x;
			_draw[_d]._y = y;
		}
		else
		{
			var rect:Object = _draw[_d].getBounds( _m );
			switch( _flip )
			{
			case _FLIP_HORIZONTAL:
				_draw[_d]._x = x + (rect.xMax - rect.xMin);
				_draw[_d]._y = y;
				_draw[_d]._xscale = -100;
				break;
			case _FLIP_VERTICAL:
				_draw[_d]._x = x;
				_draw[_d]._y = y + (rect.yMax - rect.yMin);
				_draw[_d]._yscale = -100;
				break;
			case _FLIP_ROTATE:
				_draw[_d]._x = x + (rect.xMax - rect.xMin);
				_draw[_d]._y = y + (rect.yMax - rect.yMin);
				_draw[_d]._xscale = -100;
				_draw[_d]._yscale = -100;
				break;
			}
		}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_d++;
	}
	function drawImage( clip_id:Number, x:Number, y:Number ):Void
	{
		createImage( clip_id );
		drawClip( x, y );
	}
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	function drawImageArea( clip_id:Number, dx:Number, dy:Number, sx:Number, sy:Number, w:Number, h:Number ):Void
	{
		createBitmapArea( clip_id, sx, sy, w, h );
		drawClip( dx, dy );
	}
	function drawBitmap( bitmap:_BitmapData, x:Number, y:Number ):Void
	{
		createBitmap( bitmap._bitmap );
		drawClip( x, y );
	}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
#ifdef _USE_MOVIE
	function drawMovie( movie:_MovieClip, x:Number, y:Number ):Void
	{
		attachMovie( movie );
		drawClip( x, y );
	}
#endif // _USE_MOVIE

	function drawScaledClip( x:Number, y:Number, w:Number, h:Number ):Void
	{
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		var pos:Matrix = new Matrix();
		var rect:Object = _draw[_d].getBounds( _m );
		switch( _flip )
		{
		case _FLIP_NONE:
			pos.scale( w / (rect.xMax - rect.xMin), h / (rect.yMax - rect.yMin) );
			pos.translate( x, y );
			break;
		case _FLIP_HORIZONTAL:
			pos.scale( -w / (rect.xMax - rect.xMin), h / (rect.yMax - rect.yMin) );
			pos.translate( x + w, y );
			break;
		case _FLIP_VERTICAL:
			pos.scale( w / (rect.xMax - rect.xMin), -h / (rect.yMax - rect.yMin) );
			pos.translate( x, y + h );
			break;
		case _FLIP_ROTATE:
			pos.scale( -w / (rect.xMax - rect.xMin), -h / (rect.yMax - rect.yMin) );
			pos.translate( x + w, y + h );
			break;
		}
		if( _a == 100 )
		{
			_bitmap.draw( _draw[_d], pos );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _draw[_d], pos );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		var rect:Object = _draw[_d].getBounds( _m );
		switch( _flip )
		{
		case _FLIP_NONE:
			_draw[_d]._x = x;
			_draw[_d]._y = y;
			_draw[_d]._xscale = (100 * w) / (rect.xMax - rect.xMin);
			_draw[_d]._yscale = (100 * h) / (rect.yMax - rect.yMin);
			break;
		case _FLIP_HORIZONTAL:
			_draw[_d]._x = x + w;
			_draw[_d]._y = y;
			_draw[_d]._xscale = (-100 * w) / (rect.xMax - rect.xMin);
			_draw[_d]._yscale = ( 100 * h) / (rect.yMax - rect.yMin);
			break;
		case _FLIP_VERTICAL:
			_draw[_d]._x = x;
			_draw[_d]._y = y + h;
			_draw[_d]._xscale = ( 100 * w) / (rect.xMax - rect.xMin);
			_draw[_d]._yscale = (-100 * h) / (rect.yMax - rect.yMin);
			break;
		case _FLIP_ROTATE:
			_draw[_d]._x = x + w;
			_draw[_d]._y = y + h;
			_draw[_d]._xscale = (-100 * w) / (rect.xMax - rect.xMin);
			_draw[_d]._yscale = (-100 * h) / (rect.yMax - rect.yMin);
			break;
		}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_d++;
	}
	function drawScaledImage( clip_id:Number, x:Number, y:Number, w:Number, h:Number ):Void
	{
		createImage( clip_id );
		drawScaledClip( x, y, w, h );
	}
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	function drawScaledImageArea( clip_id:Number, dx:Number, dy:Number, dw:Number, dh:Number, sx:Number, sy:Number, sw:Number, sh:Number ):Void
	{
		createBitmapArea( clip_id, sx, sy, sw, sh );
		drawScaledClip( dx, dy, dw, dh );
	}
	function drawScaledBitmap( bitmap:_BitmapData, x:Number, y:Number, w:Number, h:Number ):Void
	{
		createBitmap( bitmap._bitmap );
		drawScaledClip( x, y, w, h );
	}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
#ifdef _USE_MOVIE
	function drawScaledMovie( movie:_MovieClip, x:Number, y:Number, w:Number, h:Number ):Void
	{
		attachMovie( movie );
		drawScaledClip( x, y, w, h );
	}
#endif // _USE_MOVIE

	var SIN4096:Array = [
		   0,   25,   50,   75,  100,  125,  150,  175,  200,  226,
		 251,  276,  301,  326,  351,  376,  401,  426,  451,  476,
		 501,  526,  551,  576,  601,  625,  650,  675,  700,  725,
		 749,  774,  799,  823,  848,  872,  897,  921,  946,  970,
		 995, 1019, 1043, 1068, 1092, 1116, 1140, 1164, 1189, 1213,
		1237, 1260, 1284, 1308, 1332, 1356, 1379, 1403, 1427, 1450,
		1474, 1497, 1520, 1544, 1567, 1590, 1613, 1636, 1659, 1682,
		1705, 1728, 1751, 1773, 1796, 1819, 1841, 1864, 1886, 1908,
		1930, 1952, 1975, 1997, 2018, 2040, 2062, 2084, 2105, 2127,
		2148, 2170, 2191, 2212, 2233, 2254, 2275, 2296, 2317, 2337,
		2358, 2379, 2399, 2419, 2439, 2460, 2480, 2500, 2519, 2539,
		2559, 2578, 2598, 2617, 2637, 2656, 2675, 2694, 2713, 2732,
		2750, 2769, 2787, 2806, 2824, 2842, 2860, 2878, 2896, 2914,
		2931, 2949, 2966, 2983, 3000, 3018, 3034, 3051, 3068, 3085,
		3101, 3117, 3134, 3150, 3166, 3182, 3197, 3213, 3229, 3244,
		3259, 3274, 3289, 3304, 3319, 3334, 3348, 3363, 3377, 3391,
		3405, 3419, 3433, 3447, 3460, 3473, 3487, 3500, 3513, 3526,
		3538, 3551, 3563, 3576, 3588, 3600, 3612, 3624, 3635, 3647,
		3658, 3669, 3680, 3691, 3702, 3713, 3723, 3734, 3744, 3754,
		3764, 3774, 3784, 3793, 3803, 3812, 3821, 3830, 3839, 3848,
		3856, 3864, 3873, 3881, 3889, 3897, 3904, 3912, 3919, 3926,
		3933, 3940, 3947, 3954, 3960, 3967, 3973, 3979, 3985, 3990,
		3996, 4001, 4007, 4012, 4017, 4022, 4026, 4031, 4035, 4039,
		4043, 4047, 4051, 4055, 4058, 4062, 4065, 4068, 4071, 4073,
		4076, 4078, 4080, 4082, 4084, 4086, 4088, 4089, 4091, 4092,
		4093, 4094, 4094, 4095, 4095, 4095, 4096
	];
	function sin4096( r1024:Number ):Number
	{
		r1024 &= 1023;
		if( r1024 <= 256 ) return SIN4096[r1024];
		if( r1024 <= 512 ) return SIN4096[512 - r1024];
		if( r1024 <= 768 ) return -SIN4096[r1024 - 512];
		return -SIN4096[1024 - r1024];
	}
	function drawTransClip( x:Number, y:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		var pos:Matrix = new Matrix();
		pos.scale( z128x / 128, z128y / 128 );
		pos.rotate( (3.14159265358979323846264 * r360) / 180 );
		if( r360 == 0 )
		{
			pos.translate(
				((-cx) * z128x * 32 + x * 4096) / 4096,
				((-cy) * z128y * 32 + y * 4096) / 4096
				);
		}
		else
		{
			var s4096:Number = sin4096( r360 * 1024 / 360 );
			var c4096:Number = cos4096( r360 * 1024 / 360 );
			pos.translate(
				(((-cx) * (c4096 * z128x) - (-cy) * (s4096 * z128y)) / 128 + x * 4096) / 4096,
				(((-cx) * (s4096 * z128x) + (-cy) * (c4096 * z128y)) / 128 + y * 4096) / 4096
				);
		}
		if( _a == 100 )
		{
			_bitmap.draw( _draw[_d], pos );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _draw[_d], pos );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		if( r360 == 0 )
		{
			_draw[_d]._x = ((-cx) * z128x * 32 + x * 4096) / 4096;
			_draw[_d]._y = ((-cy) * z128y * 32 + y * 4096) / 4096;
		}
		else
		{
			var s4096:Number = sin4096( r360 * 1024 / 360 );
			var c4096:Number = cos4096( r360 * 1024 / 360 );
			_draw[_d]._x = (((-cx) * (c4096 * z128x) - (-cy) * (s4096 * z128y)) / 128 + x * 4096) / 4096;
			_draw[_d]._y = (((-cx) * (s4096 * z128x) + (-cy) * (c4096 * z128y)) / 128 + y * 4096) / 4096;
		}
		_draw[_d]._rotation = r360;
		_draw[_d]._xscale = (100 * z128x) / 128;
		_draw[_d]._yscale = (100 * z128y) / 128;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_d++;
	}
	function drawTransImage( clip_id:Number, x:Number, y:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
		createImage( clip_id );
		drawTransClip( x, y, cx, cy, r360, z128x, z128y );
	}
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	function drawTransImageArea( clip_id:Number, dx:Number, dy:Number, sx:Number, sy:Number, w:Number, h:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
		createBitmapArea( clip_id, sx, sy, w, h );
		drawTransClip( dx, dy, cx, cy, r360, z128x, z128y );
	}
	function drawTransBitmap( bitmap:_BitmapData, x:Number, y:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
		createBitmap( bitmap._bitmap );
		drawTransClip( x, y, cx, cy, r360, z128x, z128y );
	}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
#ifdef _USE_MOVIE
	function drawTransMovie( movie:_MovieClip, x:Number, y:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
		attachMovie( movie );
		drawTransClip( x, y, cx, cy, r360, z128x, z128y );
	}
#endif // _USE_MOVIE

#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	function getPixel( x:Number, y:Number ):Number
	{
		return _bitmap.getPixel( x, y );
	}

	function setPixel( x:Number, y:Number, col:Number ):Void
	{
		_bitmap.setPixel( x, y, col );
	}

	function copyPixels( bitmap:_BitmapData, x:Number, y:Number ):Void
	{
		_bitmap.copyPixels( bitmap._bitmap, bitmap._rect, new Point( x, y ), _alpha, _point, true );
	}
	function copyPixelsArea( bitmap:_BitmapData, dx:Number, dy:Number, sx:Number, sy:Number, w:Number, h:Number ):Void
	{
		_bitmap.copyPixels( bitmap._bitmap, new Rectangle( sx, sy, w, h ), new Point( dx, dy ), _alpha, _point, true );
	}
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )

	function drawLine( x0:Number, y0:Number, x1:Number, y1:Number ):Void
	{
		createShape();
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_shape.moveTo( x0, y0 );
		_shape.lineTo( x1, y1 );
		if( _a == 100 )
		{
			_bitmap.draw( _shape );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _shape );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		_draw[_d].moveTo( x0, y0 );
		_draw[_d].lineTo( x1, y1 );
		_d++;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	}

	function drawRect( x:Number, y:Number, w:Number, h:Number ):Void
	{
		createShape();
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_shape.moveTo( x    , y     );
		_shape.lineTo( x + w, y     );
		_shape.lineTo( x + w, y + h );
		_shape.lineTo( x    , y + h );
		_shape.lineTo( x    , y     );
		if( _a == 100 )
		{
			_bitmap.draw( _shape );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _shape );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		_draw[_d].moveTo( x    , y     );
		_draw[_d].lineTo( x + w, y     );
		_draw[_d].lineTo( x + w, y + h );
		_draw[_d].lineTo( x    , y + h );
		_draw[_d].lineTo( x    , y     );
		_d++;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	}

	function fillRect( x:Number, y:Number, w:Number, h:Number ):Void
	{
		createShape();
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_shape.beginFill( _col );
		_shape.moveTo( x        , y         );
		_shape.lineTo( x + w - 1, y         );
		_shape.lineTo( x + w - 1, y + h - 1 );
		_shape.lineTo( x        , y + h - 1 );
		_shape.lineTo( x        , y         );
		_shape.endFill();
		if( _a == 100 )
		{
			_bitmap.draw( _shape );
		}
		else
		{
			_temp.fillRect( _rect, 0x00000000 );
			_temp.draw( _shape );
			_bitmap.copyPixels( _temp, _rect, _point, _alpha, _point, true );
		}
#else
		_draw[_d].beginFill( _col );
		_draw[_d].moveTo( x        , y         );
		_draw[_d].lineTo( x + w - 1, y         );
		_draw[_d].lineTo( x + w - 1, y + h - 1 );
		_draw[_d].lineTo( x        , y + h - 1 );
		_draw[_d].lineTo( x        , y         );
		_draw[_d].endFill();
		_d++;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	}

	function drawString( str:String, x:Number, y:Number ):Void
	{
		createString();
#if defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
		_string.text = str;
		_string.setTextFormat( _format[_font] );
		var pos:Matrix = new Matrix();
		pos.translate(
			x - 2/*テキストフィールドのふち取り*/,
			y - 2/*テキストフィールドのふち取り*/ - _font_h[_font]
			);
		_bitmap.draw( _string, pos );
#else
		_draw[_d]._x = x - 2/*テキストフィールドのふち取り*/;
		_draw[_d]._y = y - 2/*テキストフィールドのふち取り*/ - _font_h[_font];
		_draw[_d].text = str;
		_draw[_d].setTextFormat( _format[_font] );
		_d++;
#endif // defined( _USE_BITMAPDATA ) || defined( _USE_BITMAPDATAEX )
	}
}
