/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

import flash.display.*;
import flash.geom.*;

class _BitmapData
{
	var _bitmap:BitmapData;
	var _rect:Rectangle;

#ifdef _USE_BITMAPDATAEX
	function _BitmapData( m:_Main, clip_id:Number, x:Number, y:Number, w:Number, h:Number )
#else
	function _BitmapData( m:_Main, clip_id:Number )
#endif // _USE_BITMAPDATAEX
	{
		m.createEmptyMovieClip( _BITMAPDATA_NAME, _BITMAPDATA_DEPTH );
		var tmp:MovieClip = m[_BITMAPDATA_NAME];
		tmp.attachMovie( _IMAGE_PREFIX + clip_id, _IMAGE_PREFIX + clip_id, _BITMAPDATA_DEPTH );

#ifdef _USE_BITMAPDATAEX
		if( (w == 0) || (h == 0) )
		{
			var rect:Object = tmp.getBounds( m );
			x = 0;
			y = 0;
			w = rect.xMax - rect.xMin;
			h = rect.yMax - rect.yMin;
		}
		_bitmap = new BitmapData( w, h, true, 0x00000000 );
		_rect = new Rectangle( 0, 0, w, h );

		var mat:Matrix = new Matrix();
		mat.translate( -x, -y );
		_bitmap.draw( tmp, mat );
#else
		var rect:Object = tmp.getBounds( m );
		_bitmap = new BitmapData( rect.xMax - rect.xMin, rect.yMax - rect.yMin, true, 0x00000000 );
		_rect = new Rectangle( 0, 0, rect.xMax - rect.xMin, rect.yMax - rect.yMin );

		_bitmap.draw( tmp );
#endif // _USE_BITMAPDATAEX

		tmp.removeMovieClip();
	}

	function getPixel( x:Number, y:Number ):Number
	{
		return _bitmap.getPixel32( x, y );
	}
}
