/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _ArrayInput
{
	var _array:Array;
	var _pos:Number;
	var _val:Number;

	function _ArrayInput( array:Array )
	{
		_array = array;
		_pos = 0;
	}

	function skipBytes( n:Number ):Void
	{
		_pos += n;
	}

	function readUnsignedByte():Number
	{
		_val = 0;
		if( _pos < _array.length )
		{
			_val = _array[_pos] & 0xff;
		}
		_pos++;
		return _val;
	}

	function readByte():Number
	{
		readUnsignedByte();
		if( _val > 0x7f )
		{
			_val = (_val & 0x7f) - 0x80;
		}
		return _val;
	}

	function readUnsignedShort():Number
	{
		_val = 0;
		if( _pos <= _array.length - 2 )
		{
			_val = ((_array[_pos] & 0xff) << 8) | (_array[_pos + 1] & 0xff);
		}
		_pos += 2;
		return _val;
	}

	function readShort():Number
	{
		readUnsignedShort();
		if( _val > 0x7fff )
		{
			_val = (_val & 0x7fff) - 0x8000;
		}
		return _val;
	}

	function readUnsignedInt():Number
	{
		_val = 0;
		if( _pos <= _array.length - 4 )
		{
			_val = ((_array[_pos] & 0xff) << 24) | ((_array[_pos + 1] & 0xff) << 16) | ((_array[_pos + 2] & 0xff) << 8) | (_array[_pos + 3] & 0xff);
		}
		_pos += 4;
		return _val;
	}

	function readInt():Number
	{
		readUnsignedInt();
		if( _val > 0x7fffffff )
		{
			_val = (_val & 0x7fffffff) - 0x80000000;
		}
		return _val;
	}
}
