//
//  AuMain.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/11.
//
//

#include "AuMain.h"
#include <math.h>
#include "Stk.h"

unsigned int AuMain::mBufferSize;

AuMain::AuMain() :
    mSamplingRate(44100),
    mVolume(1.0),
    mPan(0.5),
	mixBuffer(new double[mBufferSize])
{
	//stk::Stk::setRawwavePath("../../../../../lib/stk-4.4.3/rawwaves/");
	stk::Stk::setRawwavePath("./rawwaves/");
}

void AuMain::add(PAudioOutStream *audioStream)
{
	mutex.lock();
	audioStreams.push_back(audioStream);
	mutex.unlock();
}

void AuMain::remove(PAudioOutStream *audioStream)
{
	mutex.lock();
	if(audioStream != NULL) {
		std::vector<PAudioOutStream *>::iterator it = std::remove(audioStreams.begin(), audioStreams.end(), audioStream);
		audioStreams.erase(it, audioStreams.end());
	}
	mutex.unlock();
}

void AuMain::audioOut(float *output, int size, int channels)
{
	mutex.lock();

	if(mBufferSize < (size * channels)) {
		delete [] mixBuffer;
		mixBuffer = new double[size * channels];
	}
	
	for(int i = 0; i < (size * channels); i++) {
		output[i] = 0;
	}
	
	for(vector<PAudioOutStream*>::iterator itr = audioStreams.begin(); itr != audioStreams.end(); itr++) {
		PAudioOutStream *audioStream = *itr;
		audioStream->audioOut(mixBuffer, size, channels);
		for(int i = 0; i < (size * channels); i++) {
			output[i] += mixBuffer[i];
		}
	}
	
    if(channels == 1) { // mono
        for(int i = 0; i < size; i++) {
            output[i] *= mVolume;
        }
    } else { // stereo
        for(int i = 0; i < size; i++) {
            output[i*channels  ] *= (mVolume * (1.0 - mPan));
            output[i*channels+1] *= (mVolume * mPan);
        }
    }
	
	mutex.unlock();
}

static void audioOutSinTest(double *output, int size, int channels)
{
    static float oscPhase = 0;
    static float oscFreq = 440;
    static float oscGain = 0.5;
    
    for(int i = 0; i < size; i++)
    {
        float x = sin(oscPhase) * oscGain;
        oscPhase += oscFreq / 44100 * TWO_PI;
        output[i*2  ] = x;
        output[i*2+1] = x;
        
        if(oscPhase > TWO_PI)
        {
            oscPhase -= TWO_PI;
        }
    }
}
