/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;

public abstract class AbstractBackend
implements Backend {
    private CachingDataStore dataStore;
    private String homeDir;
    private String config;
    private int asyncWritePoolSize = 10;
    private volatile Executor asyncWriteExecutor;

    public int getAsyncWritePoolSize() {
        return this.asyncWritePoolSize;
    }

    public void setAsyncWritePoolSize(int asyncWritePoolSize) {
        this.asyncWritePoolSize = asyncWritePoolSize;
    }

    @Override
    public void init(CachingDataStore dataStore, String homeDir, String config) throws DataStoreException {
        this.dataStore = dataStore;
        this.homeDir = homeDir;
        this.config = config;
    }

    @Override
    public void close() throws DataStoreException {
        Executor asyncExecutor = this.getAsyncWriteExecutor();
        if (asyncExecutor != null && asyncExecutor instanceof ExecutorService) {
            ((ExecutorService)asyncExecutor).shutdownNow();
        }
    }

    protected CachingDataStore getDataStore() {
        return this.dataStore;
    }

    protected void setDataStore(CachingDataStore dataStore) {
        this.dataStore = dataStore;
    }

    protected String getHomeDir() {
        return this.homeDir;
    }

    protected void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    protected String getConfig() {
        return this.config;
    }

    protected void setConfig(String config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor getAsyncWriteExecutor() {
        Executor executor = this.asyncWriteExecutor;
        if (executor == null) {
            AbstractBackend abstractBackend = this;
            synchronized (abstractBackend) {
                executor = this.asyncWriteExecutor;
                if (executor == null) {
                    this.asyncWriteExecutor = executor = this.createAsyncWriteExecutor();
                }
            }
        }
        return executor;
    }

    protected Executor createAsyncWriteExecutor() {
        Executor asyncExecutor = this.dataStore.getAsyncUploadLimit() > 0 && this.getAsyncWritePoolSize() > 0 ? (ThreadPoolExecutor)Executors.newFixedThreadPool(this.getAsyncWritePoolSize(), new NamedThreadFactory(this.getClass().getSimpleName() + "-write-worker")) : new ImmediateExecutor();
        return asyncExecutor;
    }

    private class ImmediateExecutor
    implements Executor {
        private ImmediateExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

