package submit02;

import java.io.*;
import java.util.*;

import static java.lang.Math.*;
import static java.lang.Integer.*;


/*
 Holes count (Cnt) = 135
Holes area (Area) = 68344184
Score  = 1245572753400
 */


public class RectanglesAndHoles {

	static PrintStream err = null;
	static long progtime = 0;
	
	static int N = 0;
	Random rnd = new Random();
	static boolean debug = true;

	static void debug(String s){
		if(debug){
			err.print(s);
		}
	}
	static void debug(int i){
		if(debug){
			err.print(i);
		}
	}
	
	public int[] place(int[] A, int[] B){
		long start =  System.currentTimeMillis();

		int[] ret = null;
		N = A.length;
		List<R> orgs = new ArrayList<R>();
		List<R> l = new ArrayList<R>();

		try{
			for(int i = 0; i < N; i++){
				R r = new R(A[i], B[i]);
				r.idx = i;
				l.add(r);
				orgs.add(r);
			}
			
			Collections.sort(l, new Comparator<R>() {
				@Override
				public int compare(R o1, R o2) {
					return o1.l - o2.l;
				}
			});
			
			mycalc(l);

			ret = new int[N*3];
			for(int i = 0; i < N; i++){
				R r = orgs.get(i);
				ret[3*i] = r.x;
				ret[3*i+1] = r.y;
				ret[3*i+2] = r.d;
			}
			
		}
		catch(Exception ex){
			err.println(ex.getMessage());
		}
		
		progtime += System.currentTimeMillis() - start;
		return ret;
	}
	
	private void mycalc(List<R> rs) throws Exception{
		List<L> lines = new ArrayList<L>();
		R r = rs.remove(0);

		if(r.b > r.a){
			r.d = 1;
		}
		List<L> lastAddedLines = getLines(r);
		List<L> nextTopLines = lastAddedLines;
		
		lines.addAll(lastAddedLines);
		
		while(rs.size() >= 3){
			
			{ // ŏ̍
				L prevTopL = getTopMostLine(nextTopLines);
				r = rs.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = prevTopL.y1;
				r.x = prevTopL.x1 - r.s;
				lastAddedLines = getLines(r);
				lines.addAll(lastAddedLines);
			}
			
			{ // ̎lp
				L topL = getTopMostLine(lastAddedLines);
				r = rs.remove(0);
				if(r.b > r.a){
					r.d = 1;
				}
				r.y = topL.y2;
				r.x = topL.x2;
				lastAddedLines = getLines(r);
				nextTopLines = lastAddedLines;
			}
			 
			{  // ŌEꏊTȂǉ
				r = rs.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				
				// 2Ԗڂ̎lp̉L
				L lastBotL = getBottomMostLine(lastAddedLines);
				int y = lastBotL.y1;
				int x = lastBotL.x2;
				L ckL = new L(y - r.l, x, y, x);
				L targetL = getTopMostLine(lines, ckL);
				if(targetL != null){
					r.y = targetL.y1;
					r.x = x;
				}
				else{
					while(true){
						x--;
						ckL = new L(y - r.l, x, y, x);
						targetL = getTopMostLine(lines, ckL);
						if(targetL != null){
							r.y = y - r.l;
							r.x = x;
							break;
						}
					}
				}
				
				// QԂ߂̂Œǉ
				lines.addAll(lastAddedLines);
				
				// Ō̕ŒǉB
				lastAddedLines = getLines(r);
				lines.addAll(lastAddedLines);
			}
		}
		
		// ŌQ1
		if(rs.size() > 0){
			L prevTopL = getTopMostLine(lines);
			r = rs.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = prevTopL.y1;
			r.x = prevTopL.x1 - r.l;
			
			
			List<L> lastAddedlines = getLines(r);
		
			
			//Ō̂PA
			if(rs.size() > 0){
				r = rs.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				L l = getBottomMostLine(lastAddedlines);
				
				int y = l.y1;
				int x = l.x1;
				
				L ckL = new L(y - r.l, x, y, x);
				L targetL = getTopMostLine(lines, ckL);
				if(targetL != null){
					r.y = targetL.y1;
					r.x = x - r.s;
				}
				else{
					while(true){
						x++;
						ckL = new L(y - r.l, x, y, x);
						targetL = getTopMostLine(lines, ckL);
						if(targetL != null){
							r.y = y - r.l;
							r.x = x - r.s;
							break;
						}
					}
				}
				lines.addAll(lastAddedlines);
				lastAddedlines = getLines(r);
				lines.addAll(lastAddedlines);
			}
		}
		
		
	}
	
	// cklɂԏ̉LԂB^b`B
	// ckl͏c̐O
	private L getTopMostLine(List<L> lines, L ckL){
		L ret = null;
		int ckX = ckL.x1;
		for(L l : lines){
			if(l.y1 == l.y2 && 
			   l.x1 <= ckX && ckX <= l.x2 &&
			   ckL.y1 <= l.y1 && l.y1 <= ckL.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(l.y1 > ret.y1){
						ret = l;
					}
				}
			}
		}
		return ret;
	}
	
	private L getTopMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.y1 == l.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(ret.y1 < l.y1){
						ret = l;
					}
					else if(ret.y1 == l.y1){
						if(l.x1 < ret.x1){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	private L getBottomMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.y1 == l.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(ret.y1 > l.y1){
						ret = l;
					}
					else if(ret.y1 == l.y1){
						if(l.x1 > ret.x1){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	
	private boolean iscross(List<L> l1, List<L> l2){
		for(L ml : l1){
			for(L l : l2){
				if(cross(ml, l)){
					return true;
				}
			}
		}
		return false;
	}
	
	private int nextrnd(){
		return rnd.nextInt(1800000) - 900000;
	}
	
	List<L> getLines(R r){
		return getLines(r, 0, 0);
	}
	
	// y, xƂɏقɗ悤
	List<L> getLines(R r, int oy, int ox){
		List<L> l = new ArrayList<L>();
		int y = r.y + oy;
		int x = r.x + ox;
		if(r.d == 0){
			int ny = y + r.b;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.a;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.b;
			l.add(new L(ny, nx, y, x));
			y = ny;
			x = nx;
			nx -= r.a;
			l.add(new L(ny, nx, y, x));
		}
		else{
			int ny = y + r.a;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.b;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.a;
			l.add(new L(ny, nx, y, x));
			y = ny;
			x = nx;
			nx -= r.b;
			l.add(new L(ny, nx, y, x));
		}
		
		return l;
	}

	
	boolean cross(L l1, L l2){
		int ly1 = Math.max(l1.y1, l1.y2);
		int sy1 = Math.min(l1.y1, l1.y2);
		int ly2 = Math.max(l2.y1, l2.y2);
		int sy2 = Math.min(l2.y1, l2.y2);
		
		int lx1 = Math.max(l1.x1, l1.x2);
		int sx1 = Math.min(l1.x1, l1.x2);
		int lx2 = Math.max(l2.x1, l2.x2);
		int sx2 = Math.min(l2.x1, l2.x2);
		
		
		if(l1.x1 == l1.x2){
			if(l2.x1 != l2.x2){
				if(sy1 < l2.y1 && l2.y1 < ly1 && sx2 < l1.x1 && l1.x1 < lx2){
					return true;
				}
			}
		}
		else{
			if(l2.y1 != l2.y2){
				if(sx1 < l2.x1 && l2.x1 < lx1 && sy2 < l1.y1 && l1.y1 < ly2){
					return true;
				}
			}
		}

		return false;
	}
	

	class L{
		public L(int y1, int x1, int y2, int x2){
			this.y1 = y1;
			this.x1 = x1;
			this.y2 = y2;
			this.x2 = x2;
		}
		int y1 = 0;
		int x1 = 0;
		int y2 = 0;
		int x2 = 0;
	}
	
			
	
	class R{
		public R(int a, int b){
			this.a = a;
			this.b = b;
			l = Math.max(a, b);
			s = Math.min(a, b);
		}
		int a = 0;
		int b = 0;
		int l = 0;
		int s = 0;
		int idx = 0;
		int y = 0;
		int x = 0;
		int d = 0;
	}
	
	class G {
		List<R> rs = new ArrayList<R>();
		int oy = 0;
		int ox = 0;
	}

	
	
	
//	
//	public static void main(String[] args) throws Exception{
//		RectanglesAndHoles r = new RectanglesAndHoles();
//		//s.test();
//		err = System.err;
//
//		progtime = 0;
//
//		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
//		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
//
//		String s = null;
//		while( (s = br.readLine()) != null){
//			int n = parseInt(s);
//			int[] A = new int[n];
//			int[] B = new int[n];
//			for(int i = 0; i < n; i++){
//				A[i] = parseInt(br.readLine());
//			}
//			for(int i = 0; i < n; i++){
//				B[i] = parseInt(br.readLine());
//			}
//			int[] ret = r.place(A, B);
//			for(int i = 0; i < ret.length; i++){
//				bw.write(ret[i] + "\n");
//			}
//			bw.flush();
//		}
//
//	    bw.close();
//	    br.close();
//	    err.println("time : " + progtime);
//	}

}
