/*
 * Copyright (c) Daisuke OKAJIMA    All rights reserved.
 * 
 * $Id$
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;

using Zanetti.Commands;
using Zanetti.DataSource;
using Zanetti.Data;
using Zanetti.UI;

namespace Zanetti.Forms
{
	/// <summary>
	/// Download ̊Tv̐łB
	/// </summary>
	internal class DownloadDialog : System.Windows.Forms.Form
	{
		private DownloadOrder _currentOrder;
		private CombinedDataSource _dataSource;
		private int[] _downloadStartDates;
		private ArrayList _downloadErrorLogs;
		private long _downloadStartTime;
		private bool _runScreeningNow;
		private bool _initializeDataRequested;

		private ToolTip _toolTip;
		private System.Windows.Forms.Button _okButton;
		private System.Windows.Forms.Button _cancelButton;
		private System.Windows.Forms.Button _donationButton;

		private System.Windows.Forms.GroupBox _orderGroup;
		private System.Windows.Forms.CheckBox _stockCheckBox;
		private System.Windows.Forms.GroupBox _stockGroup;
		private System.Windows.Forms.RadioButton _radioDailyStock;
		private System.Windows.Forms.RadioButton _radioAllStock;
		private System.Windows.Forms.Button _allStockButton;
#if KENMILLE
		private System.Windows.Forms.RadioButton _radioKenmilleStock;
#endif
		private System.Windows.Forms.ComboBox _dateBox;
		private System.Windows.Forms.CheckBox _indicesCheckBox;
		private System.Windows.Forms.CheckBox _sectorsCheckBox;
		private System.Windows.Forms.CheckBox _currenciesCheckBox;
		private System.Windows.Forms.CheckBox _commodityCheckBox;
		private System.Windows.Forms.CheckBox _namingCheckBox;
		private System.Windows.Forms.GroupBox _namingGroup;
		private System.Windows.Forms.Label _locationLabel;
		private System.Windows.Forms.ComboBox _locationBox;
		private System.Windows.Forms.Label _nameLabel;
		private System.Windows.Forms.TextBox _nameTextBox;
		private System.Windows.Forms.Label _progressLabel;
		private System.Windows.Forms.ProgressBar _progressBar;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DownloadDialog(DownloadOrder order) {
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
			_toolTip = new ToolTip();
			_currentOrder = order;
			ShowOrderGroup();
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		public bool RunScreeningNow {
			get {
				return _runScreeningNow;
			}
			set {
				_runScreeningNow = value;
			}
		}

		public bool InitializeDataRequested {
			get {
				return _initializeDataRequested;
			}
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this._okButton = new System.Windows.Forms.Button();
			this._cancelButton = new System.Windows.Forms.Button();
			this._donationButton = new System.Windows.Forms.Button();
			this._orderGroup = new System.Windows.Forms.GroupBox();
			this._currenciesCheckBox = new System.Windows.Forms.CheckBox();
			this._commodityCheckBox = new System.Windows.Forms.CheckBox();
			this._stockCheckBox = new System.Windows.Forms.CheckBox();
			this._sectorsCheckBox = new System.Windows.Forms.CheckBox();
			this._stockGroup = new System.Windows.Forms.GroupBox();
			this._dateBox = new System.Windows.Forms.ComboBox();
			this._radioDailyStock = new System.Windows.Forms.RadioButton();
			this._radioAllStock = new System.Windows.Forms.RadioButton();
#if KENMILLE
			this._radioKenmilleStock = new System.Windows.Forms.RadioButton();
#endif
			this._allStockButton = new System.Windows.Forms.Button();
			this._indicesCheckBox = new System.Windows.Forms.CheckBox();

			this._namingCheckBox = new System.Windows.Forms.CheckBox();
			this._namingGroup = new System.Windows.Forms.GroupBox();
			this._nameTextBox = new System.Windows.Forms.TextBox();
			this._nameLabel = new System.Windows.Forms.Label();
			this._locationBox = new System.Windows.Forms.ComboBox();
			this._locationLabel = new System.Windows.Forms.Label();
			this._progressBar = new System.Windows.Forms.ProgressBar();
			this._progressLabel = new System.Windows.Forms.Label();
			this._stockGroup.SuspendLayout();
			this._namingGroup.SuspendLayout();
			this.SuspendLayout();
			// 
			// _okButton
			// 
			this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._okButton.Location = new System.Drawing.Point(272, 320);
			this._okButton.Name = "_okButton";
			this._okButton.TabIndex = 0;
			this._okButton.Text = "Jn";
			this._okButton.Click += new System.EventHandler(this.OnOK);
			// 
			// _cancelButton
			// 
			this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._cancelButton.Location = new System.Drawing.Point(360, 320);
			this._cancelButton.Name = "_cancelButton";
			this._cancelButton.TabIndex = 1;
			this._cancelButton.Text = "LZ";
			this._cancelButton.Click += new System.EventHandler(this.OnCancel);
			// 
			// _donationButton
			// 
			this._donationButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._donationButton.Location = new System.Drawing.Point(16, 320);
			this._donationButton.Name = "_donationButton";
			this._donationButton.TabIndex = 100;
			this._donationButton.Size = new Size(80, 24);
			this._donationButton.Text = "tɂ...";
			this._donationButton.Click += new System.EventHandler(this.OnDonationButtonClick);
			// 
			// _orderGroup
			// 
			this._orderGroup.Controls.Add(this._currenciesCheckBox);
			this._orderGroup.Controls.Add(this._commodityCheckBox);
			this._orderGroup.Controls.Add(this._stockCheckBox);
			this._orderGroup.Controls.Add(this._sectorsCheckBox);
			this._orderGroup.Controls.Add(this._stockGroup);
			this._orderGroup.Controls.Add(this._indicesCheckBox);
			this._orderGroup.Location = new System.Drawing.Point(8, 6);
			this._orderGroup.Text = "_E[hf[^̑I";
			this._orderGroup.Name = "_orderGroup";
			this._orderGroup.FlatStyle = FlatStyle.System;
			this._orderGroup.Size = new System.Drawing.Size(440, 176);
			this._orderGroup.TabIndex = 2;
			// 
			// _stockCheckBox
			// 
			this._stockCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._stockCheckBox.Location = new System.Drawing.Point(16, 15);
			this._stockCheckBox.Name = "_stockCheckBox";
			this._stockCheckBox.Size = new System.Drawing.Size(176, 24);
			this._stockCheckBox.TabIndex = 3;
			this._stockCheckBox.Text = "(&S)";
			this._stockCheckBox.CheckedChanged += new System.EventHandler(this.OnAdjustStockDownload);
			// 
			// _stockGroup
			// 
			this._stockGroup.Controls.Add(this._dateBox);
			this._stockGroup.Controls.Add(this._radioDailyStock);
			this._stockGroup.Controls.Add(this._radioAllStock);
			this._stockGroup.Controls.Add(this._allStockButton);
#if KENMILLE
			this._stockGroup.Controls.Add(this._radioKenmilleStock);
#endif
			this._stockGroup.Enabled = false;
			this._stockGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._stockGroup.Location = new System.Drawing.Point(8, 22);
			this._stockGroup.Name = "_stockGroup";
			this._stockGroup.Size = new System.Drawing.Size(424, 96);
			this._stockGroup.TabIndex = 4;
			this._stockGroup.TabStop = false;
			// 
			// _radioDailyStock
			// 
			this._radioDailyStock.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._radioDailyStock.Location = new System.Drawing.Point(16, 16);
			this._radioDailyStock.Name = "_radioDailyStock";
			this._radioDailyStock.Size = new System.Drawing.Size(152, 24);
			this._radioDailyStock.TabIndex = 0;
			this._radioDailyStock.Checked = true;
			this._radioDailyStock.Text = "̓tȍ~ES(&D)";
			this._radioDailyStock.CheckedChanged += new System.EventHandler(this.OnAdjustDailyStockCheckBox);
			// 
			// _dateBox
			// 
			this._dateBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._dateBox.Enabled = false;
			this._dateBox.Location = new System.Drawing.Point(208, 16);
			this._dateBox.Name = "_dateBox";
			this._dateBox.Size = new System.Drawing.Size(137, 20);
			this._dateBox.TabIndex = 1;
			// 
			// _radioAllStock
			// 
			this._radioAllStock.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._radioAllStock.Location = new System.Drawing.Point(16, 40);
			this._radioAllStock.Name = "_radioAllStock";
			this._radioAllStock.Size = new System.Drawing.Size(192, 24);
			this._radioAllStock.TabIndex = 2;
			this._radioAllStock.CheckedChanged += new EventHandler(OnAllStockRadioButtonCheckedChanged);
			this._radioAllStock.Text = "f[^̏(&A)";
			// 
			// _allStockButton
			// 
			this._allStockButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._allStockButton.Location = new System.Drawing.Point(254, 40);
			this._allStockButton.Name = "_allStockButton";
			this._allStockButton.Size = new System.Drawing.Size(96, 24);
			this._allStockButton.TabIndex = 3;
			this._allStockButton.Enabled = false;
			this._allStockButton.Click += new EventHandler(OnInitializeButtonClicked);
			this._allStockButton.Text = "(&S)...";
#if KENMILLE
			// 
			// _radioKenmilleStock
			// 
			this._radioKenmilleStock.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._radioKenmilleStock.Location = new System.Drawing.Point(16, 64);
			this._radioKenmilleStock.Name = "_radioKenmilleStock";
			this._radioKenmilleStock.Size = new System.Drawing.Size(192, 24);
			this._radioKenmilleStock.TabIndex = 4;
			this._radioKenmilleStock.Text = "P~jA擾(ܐMpc)(&K)";
#endif
			// 
			// _indicesCheckBox
			// 
			this._indicesCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._indicesCheckBox.Location = new System.Drawing.Point(16, 120);
			this._indicesCheckBox.Name = "_indicesCheckBox";
			this._indicesCheckBox.Size = new System.Drawing.Size(168, 24);
			this._indicesCheckBox.TabIndex = 5;
			this._indicesCheckBox.Text = "w(&I)";
			// 
			// _currenciesCheckBox
			// 
			this._currenciesCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._currenciesCheckBox.Location = new System.Drawing.Point(224, 120);
			this._currenciesCheckBox.Name = "_currenciesCheckBox";
			this._currenciesCheckBox.Size = new System.Drawing.Size(168, 24);
			this._currenciesCheckBox.TabIndex = 6;
			this._currenciesCheckBox.Text = "ב(&C)";
			// 
			// _sectorsCheckBox
			// 
			this._sectorsCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._sectorsCheckBox.Location = new System.Drawing.Point(16, 144);
			this._sectorsCheckBox.Name = "_sectorsCheckBox";
			this._sectorsCheckBox.Size = new System.Drawing.Size(168, 24);
			this._sectorsCheckBox.TabIndex = 7;
			this._sectorsCheckBox.Text = "Ǝʎw(&E)";
			// 
			// _commodityCheckBox
			// 
			this._commodityCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._commodityCheckBox.Location = new System.Drawing.Point(224, 144);
			this._commodityCheckBox.Name = "_commodityCheckBox";
			this._commodityCheckBox.Size = new System.Drawing.Size(168, 24);
			this._commodityCheckBox.TabIndex = 8;
			this._commodityCheckBox.Text = "i敨(&O)";
			this._commodityCheckBox.Visible = false;
			// 
			// _namingCheckBox
			// 
			this._namingCheckBox.Checked = true;
			this._namingCheckBox.CheckState = System.Windows.Forms.CheckState.Checked;
			this._namingCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._namingCheckBox.Location = new System.Drawing.Point(24, 194);
			this._namingCheckBox.Name = "_namingCheckBox";
			this._namingCheckBox.Size = new System.Drawing.Size(384, 24);
			this._namingCheckBox.TabIndex = 9;
			this._namingCheckBox.Text = "̃_E[hݒۑĎȍ~ėp(&P)";
			this._namingCheckBox.CheckedChanged += new EventHandler(OnAdjustNamingCheckBox);
			// 
			// _namingGroup
			// 
			this._namingGroup.Controls.Add(this._nameTextBox);
			this._namingGroup.Controls.Add(this._nameLabel);
			this._namingGroup.Controls.Add(this._locationBox);
			this._namingGroup.Controls.Add(this._locationLabel);
			this._namingGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._namingGroup.Location = new System.Drawing.Point(8, 200);
			this._namingGroup.Name = "_namingGroup";
			this._namingGroup.Size = new System.Drawing.Size(440, 56);
			this._namingGroup.TabIndex = 9;
			this._namingGroup.TabStop = false;
			// 
			// _locationLabel
			// 
			this._locationLabel.Location = new System.Drawing.Point(16, 24);
			this._locationLabel.Name = "_locationLabel";
			this._locationLabel.Size = new System.Drawing.Size(104, 23);
			this._locationLabel.TabIndex = 0;
			this._locationLabel.Text = "ۑꏊ(&L)";
			this._locationLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _locationBox
			// 
			this._locationBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._locationBox.Location = new System.Drawing.Point(128, 24);
			this._locationBox.Name = "_locationBox";
			this._locationBox.Size = new System.Drawing.Size(104, 20);
			this._locationBox.TabIndex = 1;
			// 
			// _nameLabel
			// 
			this._nameLabel.Location = new System.Drawing.Point(240, 24);
			this._nameLabel.Name = "_nameLabel";
			this._nameLabel.Size = new System.Drawing.Size(48, 23);
			this._nameLabel.TabIndex = 2;
			this._nameLabel.Text = "O(&N)";
			this._nameLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _nameTextBox
			// 
			this._nameTextBox.Location = new System.Drawing.Point(328, 24);
			this._nameTextBox.Name = "_nameTextBox";
			this._nameTextBox.Size = new System.Drawing.Size(104, 19);
			this._nameTextBox.TabIndex = 3;
			this._nameTextBox.Text = "";
			// 
			// _progressBar
			// 
			this._progressBar.Location = new System.Drawing.Point(8, 288);
			this._progressBar.Name = "_progressBar";
			this._progressBar.Size = new System.Drawing.Size(440, 23);
			this._progressBar.TabIndex = 10;
			// 
			// _progressLabel
			// 
			this._progressLabel.Location = new System.Drawing.Point(8, 264);
			this._progressLabel.Name = "_progressLabel";
			this._progressLabel.Size = new System.Drawing.Size(344, 16);
			this._progressLabel.TabIndex = 11;
			this._progressLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DownloadWizard
			// 
			this.AcceptButton = this._okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.CancelButton = this._cancelButton;
			this.ClientSize = new System.Drawing.Size(458, 352);
			this.Controls.Add(this._orderGroup);
			this.Controls.Add(this._progressLabel);
			this.Controls.Add(this._progressBar);
			this.Controls.Add(this._namingCheckBox);
			this.Controls.Add(this._namingGroup);
			this.Controls.Add(this._cancelButton);
			this.Controls.Add(this._okButton);
			this.Controls.Add(this._donationButton);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "DownloadWizard";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
#if BUILD_INITIAL_DATA
			this.Text = "f[^̃_E[h (f[^\z)";
#else
			this.Text = "f[^̃_E[h";
#endif
			this._stockGroup.ResumeLayout(false);
			this._namingGroup.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		public DownloadOrder DownloadOrder {
			get {
				return _currentOrder;
			}
			set {
				_currentOrder = value;
			}
		}

		private const int PANEL_LEFT = 8;
		//ey[W̏
		private void ShowOrderGroup() {
			if(_currentOrder==null) _currentOrder = DownloadOrder.CreateDefault();

			_stockCheckBox.Checked = _currentOrder.Stock!=DownloadOrder.StockDownload.None;
			//twDL݂̂Ԃł͑IłȂ悤ɂ
			_indicesCheckBox.Checked = _currentOrder.ForeignIndices;
			_sectorsCheckBox.Checked = _currentOrder.Sectors;
			_currenciesCheckBox.Checked = _currentOrder.Currencies;
			_commodityCheckBox.Checked = _currentOrder.Commodities;
#if DOJIMA
			//i敨L
			_commodityCheckBox.Visible = true;
#endif

			//tXg
			_dateBox.Items.Clear();
			_downloadStartDates = ListDates();
			FormatDateBox();

			//ۑIvV
			int initial_index = 0;
			_locationBox.Items.Clear();
			for(int i=0; i<Env.Options.DownloadOrders.Count; i++) {
				DownloadOrder co = Env.Options.DownloadOrders[i];
				if(_currentOrder==co) initial_index= i;
				_locationBox.Items.Add(String.Format("ݒ{0} ({1})", i+1, Env.Options.DownloadOrders.GetDescription(i)));
			}
			_locationBox.SelectedIndex = initial_index;
			_namingCheckBox.Checked = _currentOrder.Name!=null;
			_nameTextBox.Text = _currentOrder.Name;
		}
		private bool CommitOrderGroup() {
			if(!_stockCheckBox.Checked)
				_currentOrder.Stock = DownloadOrder.StockDownload.None;
			else if(_radioDailyStock.Checked) {
				_currentOrder.Stock = DownloadOrder.StockDownload.Recent;
				_currentOrder.DateArray = CreateDateArray(_downloadStartDates, _dateBox.SelectedIndex);
			}
#if KENMILLE
			else if(_radioKenmilleStock.Checked) {
				_currentOrder.Stock = DownloadOrder.StockDownload.All;
			}
#endif
			else
				return false;

			_currentOrder.ForeignIndices = _indicesCheckBox.Checked;
			_currentOrder.DomesticIndices = _indicesCheckBox.Checked;
			_currentOrder.Sectors = _sectorsCheckBox.Checked;
			_currentOrder.Currencies = _currenciesCheckBox.Checked;
			_currentOrder.Commodities = _commodityCheckBox.Checked;
			return true;
		}
		private bool CommitNamingGroup() {
			if(_namingCheckBox.Checked) {
				if(_nameTextBox.Text.Length==0) {
					Util.Warning(this, "ۑ̖O͂Ă܂B");
					return false;
				}
				_currentOrder.Name = _nameTextBox.Text; 
				Env.Options.DownloadOrders[_locationBox.SelectedIndex] = _currentOrder;
				Env.Frame.InitMRUDownloadMenu();
			}
			return true;
		}

		private void OnAdjustStockDownload(object sender, EventArgs args) {
			bool e = _stockCheckBox.Checked;
			_stockGroup.Enabled = e;
			_dateBox.Enabled = e && _radioDailyStock.Checked;
		}
		private void OnAdjustDailyStockCheckBox(object sender, EventArgs args) {
			bool e = _radioDailyStock.Checked;
			_dateBox.Enabled = e;
		}
		private void OnAdjustNamingCheckBox(object sender, EventArgs args) {
			bool e = _namingCheckBox.Checked;
			_locationBox.Enabled = e;
			_nameTextBox.Enabled = e;
		}
		private void OnAllStockRadioButtonCheckedChanged(object sender, EventArgs args) {
			_allStockButton.Enabled = _radioAllStock.Checked;
		}
		private void OnInitializeButtonClicked(object sender, EventArgs args) {
			this.DialogResult = DialogResult.Cancel;
			_initializeDataRequested = true;
			Close();
			Env.Command.Exec(CID.ShowInitializeDialog);
		}

		private void OnOK(object sender, EventArgs args) {
			this.DialogResult = DialogResult.None;
			//̓e`FbNł_E[hJn
			if(CommitOrderGroup() && CommitNamingGroup()) StartDownload();
		}
		private void OnCancel(object sender, EventArgs args) {
			if(_dataSource!=null) _dataSource.Abort();
			this.Close();
		}

		private void StartDownload() {
			_dataSource = _currentOrder.ConvertToDataSource();
			if(_dataSource.Count==0) {
				Util.Warning(this, "_E[hΏۂIĂ܂B");
				return;
			}
			_okButton.Enabled = false;
			_downloadErrorLogs = new ArrayList();
			_downloadStartTime = DateTime.Now.Ticks;
            _orderGroup.Enabled = false;
            _namingGroup.Enabled = false;
            _namingCheckBox.Enabled = false;
            _progressBar.Enabled = true;
			_progressBar.Value = 0;
			_progressBar.Maximum = _dataSource.TotalStep;
			_dataSource.AsyncProcess(this.Handle);
		}
		private void ProgressStatus(int code, int wparam) {
			try {
				if(code==AsyncConst.LPARAM_PROGRESS_SUCCESSFUL || code==AsyncConst.LPARAM_PROGRESS_FAILURE) {
					if((wparam & DataSourceBase.DATE_MASK)!=0) {
						_progressLabel.Text = String.Format("{0}̃f[^擾", Util.FormatShortDate(wparam));
						if(code==AsyncConst.LPARAM_PROGRESS_FAILURE) {
							string msg = String.Format("{0}̃f[^擾ł܂łB{1}", wparam, _dataSource.ErrorMessage);
							_downloadErrorLogs.Add(msg);
						}
					}
					else {
						if(_progressBar.Value < _progressBar.Maximum) _progressBar.Value++; //܂Ȃ~XŃo[̏lzlZbgȂ߃K[h
						long left = (DateTime.Now.Ticks-_downloadStartTime) / _progressBar.Value * (_progressBar.Maximum-_progressBar.Value) / 10000000;
						string message = String.Format("{0}/{1}   c  {2}{3:D2}b",_progressBar.Value, _progressBar.Maximum, left/60, left % 60);
						_progressLabel.Text = message;
						if(code==AsyncConst.LPARAM_PROGRESS_FAILURE) {
							string msg = String.Format("{0}({1})̃f[^擾ł܂łB{2}", Env.BrandCollection.FindBrand(wparam).Name, wparam, _dataSource.ErrorMessage);
							_downloadErrorLogs.Add(msg);
						}
					}
				}
				else if(code==AsyncConst.LPARAM_FINISHED) {
					this.DialogResult = DialogResult.OK;
					//ŐVt
					AbstractBrand b = Env.Frame.ChartCanvas.GetBrand();
					b.ReserveFarm().LoadFor(b);
					Env.Frame.ChartCanvas.LoadBrand(b, false);
					Env.Frame.ChartCanvas.MoveToLatest();
					Close();
				}
				else if(code==AsyncConst.LPARAM_ERROR) {
					Util.Warning(this, _dataSource.ErrorMessage);
                    this.DialogResult = DialogResult.Cancel;
                }
			}
			catch(Exception ex) {
				Util.SilentReportCriticalError(ex);
				Util.Warning(this, ex.Message);
			}
		}

		private void AddHelpButton(int left, int top, Control parent, string text) {
			Button btn = new NotClickableButton();
			btn.Left = left;
			btn.Top = top;
			btn.Width = 19;
			btn.Height = 19;
			btn.FlatStyle = FlatStyle.Flat;
			btn.Image = Env.ImageList16.Images[IconConst.HELP];
			btn.Text = "";
			_toolTip.SetToolTip(btn, text);
			parent.Controls.Add(btn);
			btn.BringToFront();
		}
		private void FormatDateBox() {
			DataFarm f = Env.Frame.ChartCanvas.GetBrand().ReserveFarm();
			int latest = f.IsEmpty? Int32.MaxValue : f.LastDate;

			int sel = 0;
			for(int i=0; i<_downloadStartDates.Length; i++) {
				_dateBox.Items.Add(Util.FormatFullDate(_downloadStartDates[i]));
				if(_downloadStartDates[i] > latest) sel = i; //Ă`[g̍ŐVt̎̓ZbgĂ悤ɂ@EmptŷƂSelectedIndex͂OD
			}
			_dateBox.SelectedIndex = sel;
		}

		protected override void WndProc(ref Message m) {
			base.WndProc (ref m);
			if(m.Msg==AsyncConst.WM_ASYNCPROCESS) {
				ProgressStatus(m.LParam.ToInt32(), m.WParam.ToInt32());
			}
		}

		private static int[] ListDates() {
			DateTime ld = Util.GuessLatestTradeDate();
			//sꂪJĂɂẮA{19`24(UTCł10`15)܂Ŏ擾\B
			//sŃf[^̏ł̂18`19
			if(DateTime.Today==ld && (DateTime.UtcNow.Hour<10 || DateTime.UtcNow.Hour>=15)) ld = ld.AddDays(-1); 

			DateTime start = ld.AddMonths(-2);
			ArrayList result = new ArrayList();
			while(start.CompareTo(ld)<0) {
				if(Util.IsMarketOpenDate(ld)) {
					result.Add(Util.DateToInt(ld));
				}
				ld = ld.AddDays(-1); 
			}

			return (int[])result.ToArray(typeof(int));
		}

		private static int[] CreateDateArray(int[] dates, int start) 
		{
			int[] t = new int[start+1];
			for(int i=start; i>=0; i--)
				t[start-i] = dates[i];
			return t;
		}
		

		private void OnDonationButtonClick(object sender, EventArgs args) {
			new PromptDonation().ShowDialog(this);
		}
	}
}
