/*
 * Copyright (c) Daisuke OKAJIMA    All rights reserved.
 * 
 * $Id$
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;
using System.Text;
using Travis.Util;

using Zanetti.Data;
using Zanetti.Indicators;
using Zanetti.SystemTrading;
using Zanetti.SystemTrading.AutoTrading;
using Zanetti.Config;	// for BookmarkFolder

namespace Zanetti.Forms {
	internal class AutoTradingDialog : System.Windows.Forms.Form {
		private static readonly int[] _signalCountValues = new int[] { 100,1000,Int32.MaxValue };
		private static AutoTradingExecutor _prevExecutor; //p[^ۑp

		private AutoTradingExecutor _executor;
		private int _currentBrandIndex;

		private System.Windows.Forms.Button _okButton;
		private System.Windows.Forms.Button _cancelButton;
		private System.Windows.Forms.GroupBox _filterGroup;
		private System.Windows.Forms.Label _messageLabel;
		private System.Windows.Forms.Label _filterLabel;
		private System.Windows.Forms.ComboBox _filterBox;
		private System.Windows.Forms.GroupBox _autoTradingItemGroup;
		private System.Windows.Forms.Label _lCondition;
		private System.Windows.Forms.Label _autoTradingItemLabel;
		private System.Windows.Forms.ComboBox _autoTradingItemBox;
		private System.Windows.Forms.GroupBox _dateGroup;
		private System.Windows.Forms.Label _startDateLabel;
		private System.Windows.Forms.DateTimePicker _startDatePicker;
		private System.Windows.Forms.Label _endDateLabel;
		private System.Windows.Forms.DateTimePicker _endDatePicker;
		private System.Windows.Forms.Label _signalCountLabel;
        private System.Windows.Forms.ComboBox _signalCountBox;
        private System.Windows.Forms.ProgressBar _progressBar;
        private System.Windows.Forms.ComboBox _favoriteBox;
		private System.Windows.Forms.Button _specBookmarkFolderButton;
		private System.Windows.Forms.TextBox _bookmarkFolderTextBox;
		private System.Windows.Forms.Label _filterBookmarkLabel;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		private BookmarkFolder _bookmarkFolder;

		public AutoTradingDialog() {
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
			InitUI();
		}

		public AutoTradingResult Result {
			get {
				return _executor==null? null : _executor.Result as AutoTradingResult;
			}
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing ) {
			if( disposing ) {
				if(components != null) {
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent() {
			this._filterGroup = new System.Windows.Forms.GroupBox();
			this._specBookmarkFolderButton = new System.Windows.Forms.Button();
			this._bookmarkFolderTextBox = new System.Windows.Forms.TextBox();
			this._filterBookmarkLabel = new System.Windows.Forms.Label();
			this._filterBox = new System.Windows.Forms.ComboBox();
			this._filterLabel = new System.Windows.Forms.Label();
			this._messageLabel = new System.Windows.Forms.Label();
			this._favoriteBox = new System.Windows.Forms.ComboBox();
			this._autoTradingItemGroup = new System.Windows.Forms.GroupBox();
			this._lCondition = new System.Windows.Forms.Label();
			this._autoTradingItemBox = new System.Windows.Forms.ComboBox();
			this._autoTradingItemLabel = new System.Windows.Forms.Label();
			this._dateGroup = new System.Windows.Forms.GroupBox();
			this._startDateLabel = new Label();
			this._startDatePicker = new System.Windows.Forms.DateTimePicker();
			this._endDateLabel = new Label();
			this._endDatePicker = new System.Windows.Forms.DateTimePicker();
			this._signalCountLabel = new Label();
			this._signalCountBox = new ComboBox();
            this._progressBar = new System.Windows.Forms.ProgressBar();
            this._okButton = new System.Windows.Forms.Button();
			this._cancelButton = new System.Windows.Forms.Button();
			this._filterGroup.SuspendLayout();
			this._autoTradingItemGroup.SuspendLayout();
			this._dateGroup.SuspendLayout();
			this.SuspendLayout();
			// 
			// _filterGroup
			// 
			this._filterGroup.Controls.Add(this._specBookmarkFolderButton);
			this._filterGroup.Controls.Add(this._bookmarkFolderTextBox);
			this._filterGroup.Controls.Add(this._filterBookmarkLabel);
			this._filterGroup.Controls.Add(this._filterBox);
			this._filterGroup.Controls.Add(this._filterLabel);
			this._filterGroup.Controls.Add(this._messageLabel);
			this._filterGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._filterGroup.Location = new System.Drawing.Point(8, 8);
			this._filterGroup.Name = "_filterGroup";
			this._filterGroup.Size = new System.Drawing.Size(464, 96);
			this._filterGroup.TabIndex = 0;
			this._filterGroup.TabStop = false;
			this._filterGroup.Text = "P@Ώېݒ";
			// 
			// _specBookmarkFolderButton
			// 
			this._specBookmarkFolderButton.Location = new System.Drawing.Point(368, 64);
			this._specBookmarkFolderButton.Name = "_specBookmarkFolderButton";
			this._specBookmarkFolderButton.Size = new System.Drawing.Size(80, 24);
			this._specBookmarkFolderButton.TabIndex = 6;
			this._specBookmarkFolderButton.Text = "tH_w";
			this._specBookmarkFolderButton.FlatStyle = FlatStyle.System;
			this._specBookmarkFolderButton.Click += new System.EventHandler(this.OnSelectBookmarkFolder);
			// 
			// _bookmarkFolderTextBox
			// 
			this._bookmarkFolderTextBox.Location = new System.Drawing.Point(136, 64);
			this._bookmarkFolderTextBox.Name = "_bookmarkFolderTextBox";
			this._bookmarkFolderTextBox.Size = new System.Drawing.Size(224, 19);
			this._bookmarkFolderTextBox.TabIndex = 5;
			this._bookmarkFolderTextBox.Text = "";
			this._bookmarkFolderTextBox.ReadOnly = true;
			// 
			// _filterBookmarkLabel
			// 
			this._filterBookmarkLabel.Location = new System.Drawing.Point(24, 64);
			this._filterBookmarkLabel.Name = "_filterBookmarkLabel";
			this._filterBookmarkLabel.Size = new System.Drawing.Size(72, 16);
			this._filterBookmarkLabel.TabIndex = 4;
			this._filterBookmarkLabel.Text = "Cɓ(&T)";
			this._filterBookmarkLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _filterBox
			// 
			this._filterBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._filterBox.Location = new System.Drawing.Point(136, 40);
			this._filterBox.Name = "_filterBox";
			this._filterBox.Size = new System.Drawing.Size(224, 20);
			this._filterBox.TabIndex = 3;
			this._filterBox.SelectedIndexChanged += new System.EventHandler(this.OnFilterBoxChanged);
			// 
			// _filterLabel
			// 
			this._filterLabel.Location = new System.Drawing.Point(24, 40);
			this._filterLabel.Name = "_filterLabel";
			this._filterLabel.Size = new System.Drawing.Size(64, 16);
			this._filterLabel.TabIndex = 2;
			this._filterLabel.Text = "Ώ(&F)";
			this._filterLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _messageLabel
			// 
			this._messageLabel.Location = new System.Drawing.Point(16, 16);
			this._messageLabel.Name = "_messageLabel";
			this._messageLabel.Size = new System.Drawing.Size(432, 16);
			this._messageLabel.TabIndex = 1;
			this._messageLabel.Text = "܂Ώۂ߂܂Bł̑ΏۖȂقǍɌʂ܂B";
			// 
			// _favoriteBox
			// 
			this._favoriteBox.Location = new System.Drawing.Point(0, 0);
			this._favoriteBox.Name = "_favoriteBox";
			this._favoriteBox.TabIndex = 0;
			// 
			// _autoTradingItemGroup
			// 
			this._autoTradingItemGroup.Controls.Add(this._lCondition);
			this._autoTradingItemGroup.Controls.Add(this._autoTradingItemBox);
			this._autoTradingItemGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._autoTradingItemGroup.Location = new System.Drawing.Point(8, 112);
			this._autoTradingItemGroup.Name = "_autoTradingItemGroup";
			this._autoTradingItemGroup.Size = new System.Drawing.Size(464, 72);
			this._autoTradingItemGroup.TabIndex = 4;
			this._autoTradingItemGroup.TabStop = false;
			this._autoTradingItemGroup.Text = "Q@[̑I";
			// 
			// _lCondition
			// 
			this._lCondition.Location = new System.Drawing.Point(16, 16);
			this._lCondition.Name = "_lCondition";
			this._lCondition.Size = new System.Drawing.Size(416, 23);
			this._lCondition.TabIndex = 5;
			this._lCondition.Text = "[͊gLbgɂĒǉ邱Ƃł܂B܂͏̏IlōŝƂČvZ܂B";
			this._lCondition.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _autoTradingItemBox
			// 
			this._autoTradingItemBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._autoTradingItemBox.Location = new System.Drawing.Point(16, 40);
			this._autoTradingItemBox.Name = "_autoTradingItemBox";
			this._autoTradingItemBox.Size = new System.Drawing.Size(416, 20);
			this._autoTradingItemBox.TabIndex = 7;
			// 
			// _dateGroup
			// 
			this._dateGroup.Controls.Add(this._startDateLabel);
			this._dateGroup.Controls.Add(this._startDatePicker);
			this._dateGroup.Controls.Add(this._endDateLabel);
			this._dateGroup.Controls.Add(this._endDatePicker);
			this._dateGroup.Controls.Add(this._signalCountLabel);
			this._dateGroup.Controls.Add(this._signalCountBox);
            this._dateGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._dateGroup.Location = new System.Drawing.Point(8, 192);
			this._dateGroup.Name = "_dateGroup";
			this._dateGroup.Size = new System.Drawing.Size(464, 120);
			this._dateGroup.TabIndex = 10;
			this._dateGroup.TabStop = false;
			this._dateGroup.Text = "R@ΏۊԂȂ";
			// 
			// _startDateLabelLabel
			// 
			this._startDateLabel.Location = new System.Drawing.Point(8, 16);
			this._startDateLabel.Name = "_startDateLabel";
			this._startDateLabel.TabIndex = 0;
			this._startDateLabel.Text = "Jn";
			this._startDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _startDatePicker
			// 
			this._startDatePicker.Location = new System.Drawing.Point(80, 16);
			this._startDateLabel.Size = new System.Drawing.Size(64, 24);
			this._startDatePicker.MaxDate = new System.DateTime(2010, 12, 31, 0, 0, 0, 0);
			this._startDatePicker.MinDate = new System.DateTime(1996, 1, 1, 0, 0, 0, 0);
			this._startDatePicker.Name = "_datePicker";
			this._startDatePicker.TabIndex = 1;
			this._startDatePicker.ValueChanged += new System.EventHandler(this.OnStartDateChanged);
			// 
			// _endDateLabelLabel
			// 
			this._endDateLabel.Location = new System.Drawing.Point(8, 40);
			this._endDateLabel.Size = new System.Drawing.Size(64, 24);
			this._endDateLabel.Name = "_endDateLabelLabel";
			this._endDateLabel.TabIndex = 2;
			this._endDateLabel.Text = "I";
			this._endDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _endDatePicker
			// 
			this._endDatePicker.Location = new System.Drawing.Point(80, 40);
			this._endDatePicker.MaxDate = new System.DateTime(2010, 12, 31, 0, 0, 0, 0);
			this._endDatePicker.MinDate = new System.DateTime(1996, 1, 1, 0, 0, 0, 0);
			this._endDatePicker.Name = "_datePicker";
			this._endDatePicker.TabIndex = 3;
			this._endDatePicker.ValueChanged += new System.EventHandler(this.OnEndDateChanged);
			// 
			// _signalCountLabel
			// 
			this._signalCountLabel.Location = new System.Drawing.Point(8, 64);
			this._signalCountLabel.Size = new System.Drawing.Size(184, 24);
			this._signalCountLabel.Name = "_signalCountLabelLabel";
			this._signalCountLabel.TabIndex = 4;
			this._signalCountLabel.Text = "ł؂VOi(&S)";
			this._signalCountLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _signalCountBox
			// 
			this._signalCountBox.Location = new System.Drawing.Point(192, 64);
			this._signalCountBox.Size = new System.Drawing.Size(88, 24);
			this._signalCountBox.Name = "_signalCountBoxBox";
			this._signalCountBox.TabIndex = 5;
			this._signalCountBox.DropDownStyle = ComboBoxStyle.DropDownList;
            // 
            // _progressBar
			// 
			this._progressBar.Location = new System.Drawing.Point(8, 328);
			this._progressBar.Name = "_progressBar";
			this._progressBar.Size = new System.Drawing.Size(464, 23);
			this._progressBar.TabIndex = 14;
			// 
			// _okButton
			// 
			this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._okButton.Location = new System.Drawing.Point(312, 360);
			this._okButton.Name = "_okButton";
			this._okButton.TabIndex = 15;
			this._okButton.Text = "OK";
			this._okButton.Click += new System.EventHandler(this.OnOK);
			// 
			// _cancelButton
			// 
			this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._cancelButton.Location = new System.Drawing.Point(400, 360);
			this._cancelButton.Name = "_cancelButton";
			this._cancelButton.TabIndex = 16;
			this._cancelButton.Text = "LZ";
			this._cancelButton.Click += new System.EventHandler(this.OnCancel);
			// 
			// ScreeningDialog
			// 
			this.AcceptButton = this._okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.CancelButton = this._cancelButton;
			this.ClientSize = new System.Drawing.Size(482, 384);
			this.Controls.Add(this._dateGroup);
			this.Controls.Add(this._autoTradingItemGroup);
			this.Controls.Add(this._progressBar);
			this.Controls.Add(this._filterGroup);
			this.Controls.Add(this._cancelButton);
			this.Controls.Add(this._okButton);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ScreeningDialog";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "[";
			this._filterGroup.ResumeLayout(false);
			this._autoTradingItemGroup.ResumeLayout(false);
			this._dateGroup.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void InitUI() {

			if(_prevExecutor!=null) {
				_startDatePicker.Value = Util.IntToDate(_prevExecutor.StartDate);
				_endDatePicker.Value = Util.IntToDate(_prevExecutor.EndDate);
			}
			else {
				DateTime ld = Util.GuessLatestTradeDate();
				if(ld==DateTime.Today && DateTime.Now.Hour<17) {
					ld = ld.AddDays(-1);
					while(!Util.IsMarketOpenDate(ld)) ld = ld.AddDays(-1); //sꂪJĂ17ȑO̓f[^Ȃ
				}
				_endDatePicker.Value = ld;
				ld = ld.AddYears(-1);
				_startDatePicker.Value = ld;
			}

			AutoTradingItem[] target = Env.CurrentIndicators.AutoTradingItems;
			for(int i=0; i<target.Length; i++) {
				AutoTradingItem item = target[i];
				_autoTradingItemBox.Items.Add(item.Header);
				//if(o!=null && o.PrimaryItem==target[i])
				//	si = i;
			}

			if(_prevExecutor!=null) {
				_autoTradingItemBox.SelectedIndex = _autoTradingItemBox.FindStringExact(_prevExecutor.Item.Header);
			}
			else
				_autoTradingItemBox.SelectedIndex = 0;

			_filterBox.Items.AddRange(EnumDescAttribute.For(typeof(FilterType)).DescriptionCollection());
			_currentBrandIndex = _filterBox.Items.Count;
			_filterBox.Items.Add(String.Format("ݕ\Ă({0})", Env.Frame.ChartCanvas.GetBrand().Name));
			if(_prevExecutor!=null) {
				FilteredBrandEnumerator e = _prevExecutor.BrandEnumerator as FilteredBrandEnumerator;
				_filterBox.SelectedIndex = e==null? _currentBrandIndex : (int)e.FilterType;
			}
			else
				_filterBox.SelectedIndex = _currentBrandIndex;

			for(int i=0; i<_signalCountValues.Length; i++) {
				_signalCountBox.Items.Add(_signalCountValues[i]==Int32.MaxValue? "" : _signalCountValues[i].ToString());
				if(_prevExecutor!=null && _signalCountValues[i]==_prevExecutor.SignalCountLimit)
					_signalCountBox.SelectedIndex = i;
			}
			if(_signalCountBox.SelectedIndex==-1)
				_signalCountBox.SelectedIndex = 0;

        }

		private void OnOK(object sender, EventArgs args) {
			this.DialogResult = DialogResult.None;
			_executor = CreateExecutor();
			if(_executor==null) return;

			_okButton.Enabled = false;
			_filterBox.Enabled = false;
			_autoTradingItemBox.Enabled = false;
			_startDatePicker.Enabled = false;
			_endDatePicker.Enabled = false;
			_signalCountBox.Enabled = false;

			//!!ł͔͈͂͂ݏoĂ܂ƂBhבւ̑ΉȂǂĂ邤ɂ̂̊ǗȂĂ݂
			_progressBar.Maximum = _executor.BrandEnumerator.Count;
			_progressBar.Value = 0;
			_progressBar.Enabled = true;

			this.Cursor = Cursors.AppStarting;
			_executor.AsyncExecute(this.Handle);
		}

		private void OnCancel(object sender, EventArgs args) {
			if(_executor!=null) {
				_executor.Abort();
			}
		}

		private void OnStartDateChanged(object sender, EventArgs args) {
		}
		private void OnEndDateChanged(object sender, EventArgs args) {
		}

		private AutoTradingExecutor CreateExecutor() {
			if(_startDatePicker.Value.CompareTo(DateTime.Today)>0) {
				Util.Warning(this, "JnłB");
				return null;
			}
			if(_endDatePicker.Value.CompareTo(DateTime.Today)>0) {
				Util.Warning(this, "IłB");
				return null;
			}
			if(_startDatePicker.Value.CompareTo(_endDatePicker.Value)>0) {
				Util.Warning(this, "IJn̐ɐݒ肳Ă܂B");
				return null;
			}

			AutoTradingItem[] items = Env.CurrentIndicators.AutoTradingItems;
			int pr = _autoTradingItemBox.SelectedIndex;
			AutoTradingExecutor ex = new AutoTradingExecutor(items[pr], Util.DateToInt(_startDatePicker.Value), Util.DateToInt(_endDatePicker.Value), _signalCountValues[_signalCountBox.SelectedIndex]);
			if(_filterBox.SelectedIndex == _currentBrandIndex) {
				ex.BrandEnumerator = new SingleBrandEnumerator(Env.Frame.ChartCanvas.GetBrand());
			}
			else {
				FilterType filter = (FilterType)_filterBox.SelectedIndex;
				if(filter == FilterType.Favorite){
					if(_bookmarkFolder==null){
						Util.Warning(this, "ubN}[ÑtH_w肵ĂB");
						return null;
					}
					ex.BrandEnumerator = new BookmarkedBrandEnumerator(_bookmarkFolder);
				}
				else
					ex.BrandEnumerator = new FilteredBrandEnumerator(filter);
			}

			return ex;
		}

		private void ExitSuccessFully() {
			this.DialogResult = DialogResult.OK;
			this.Cursor = Cursors.Default;
			AutoTradingResult r = _executor.Result as AutoTradingResult;
			_prevExecutor = _executor; //sŎgp

			StringBuilder msg = new StringBuilder();
			if(r.HasTooManuResults) {
				Util.Warning(this, String.Format("VOiɒBߓrőł؂܂B͈͂ĂB"));
			}
			else {
				if(r.CheckedBrandCount > 1) {
					if(r.DataErrorBrands.Count==0) {
						msg.AppendFormat("؂܂B\nΏۖ {0} łB\n", r.CheckedBrandCount);
					}
					else {
						msg.AppendFormat("؂܂B\nΏۖ {0} ̂A\nΏۓt̃f[^Ȃ {1} ", r.CheckedBrandCount, r.DataErrorBrands.Count);
						if(r.DataErrorBrands.Count <= 10) {
							for(int i=0; i<r.DataErrorBrands.Count; i++) {
								if(i > 0) msg.Append(", ");
								msg.Append((r.DataErrorBrands[i] as BasicBrand).Code.ToString());
							}
						}
						msg.Append("͏O܂B");
					}

					Util.Information(this, msg.ToString());
				}
			}
			Close();
		}

		protected override void WndProc(ref Message m) {
			base.WndProc (ref m);
			if(m.Msg==AsyncConst.WM_ASYNCPROCESS) {
				if(m.LParam.ToInt32()==AsyncConst.LPARAM_PROGRESS_SUCCESSFUL || m.LParam.ToInt32()==AsyncConst.LPARAM_PROGRESS_FAILURE) {
					if(_progressBar.Value<_progressBar.Maximum) _progressBar.Value++;
				}
				else if(m.LParam.ToInt32()==AsyncConst.LPARAM_FINISHED)
					ExitSuccessFully();
				else if(m.LParam.ToInt32()==AsyncConst.LPARAM_ERROR) {
					this.Cursor = Cursors.Default;
					_executor.Abort();
					Util.Warning(this, _executor.ErrorMessage);
					this.DialogResult = DialogResult.Abort;
					Close();
				}
			}
		}

		private void OnSelectBookmarkFolder(object sender, System.EventArgs e){
			SelectBookmarkFolder dlg = new SelectBookmarkFolder();
			if(dlg.ShowDialog(Env.Frame)==DialogResult.OK){
				_bookmarkFolder = dlg.ResultFolder;
				_bookmarkFolderTextBox.Text = _bookmarkFolder.Name;
			}
		}

		private void OnFilterBoxChanged(object sender, System.EventArgs e){
			bool en = ((FilterType)_filterBox.SelectedIndex == FilterType.Favorite);
			_bookmarkFolderTextBox.Enabled = en;
			_specBookmarkFolderButton.Enabled = en;
		}
	}
}
