/*******************************************************************************
 *	@file			TestDXLibv2.cpp
 *	@brief			DirectX Test Program
 *
 *	@author			ohwhsmm7
 *
 *	@date			08-Apr-2009(Wed)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DL.h"
#include "DLGraph.h"
#include "DLInput.h"
#include "DLDebug.h"

#ifdef _DEBUG
#pragma comment ( lib, "Debug\\_DXLibv2.lib" )
#else	// _DEBUG
#pragma comment ( lib, "Release\\_DXLibv2.lib" )
#endif	// _DEBUG

// 񋓌^`-------------------------------------------------------------------
/*******************************************************************************
 *	@enum		enumDisplay
 *	@brief		ʃTCY
 ******************************************************************************/
enum enumDisplay
{
	enumDisplay_640x480		= 0,												//!<  VGA( 640x 480)
	enumDisplay_800x600,														//!< SVGA( 800x 600)
	enumDisplay_1024x768,														//!<  XGA(1024x 768)
	enumDisplay_FullScreen,														//!< tXN[

	enumDisplay_Max,
};

// \̒`-------------------------------------------------------------------
/*******************************************************************************
 *	@struct		SDebug
 *	@brief		fobO\
 ******************************************************************************/
struct SDebug
{
	SDebug( void )
		: m_bUsed( FALSE )
		, m_reRect()
	{
		// \TCY
		m_reRect.left = m_reRect.top = 0;
		m_reRect.right = 160;
		m_reRect.bottom = 120;
	}

	//
	BOOL					m_bUsed;											//!< gptO
	RECT					m_reRect;											//!< \TCY
};

// O[oϐ-----------------------------------------------------------
static const char* const APPNAME	= "TESTDXLIBV2";							//!< Av̖O
static const int APPWIDTH			= 800;										//!< Av̏
static const int APPHEIGHT			= 600;										//!< Av̏
static const float FRAMERATE		= 33.33333333333f;							//!< t[[g

DL::CDLGraph*			g_pGraph;												//!< DirectX Graphics
DL::CDLInput*			g_pInput;												//!< DirectX Input
DL::CDLDebug*			g_pDebug;

BOOL	g_bProg = TRUE;

HANDLE	g_hMutex = NULL;														//!< Lnh
HWND	g_hWnd = NULL;															//!< EChEnh
int		g_nWidth = 0;															//!< EChE
int		g_nHeight = 0;															//!< EChE
BOOL	g_bMode = TRUE;															//!< EChE[h

enumDisplay g_eDisp = enumDisplay_800x600;										//!< \

DWORD	g_dwTimer[ 2 ];															//!< v^C}[
float	g_fDiffTime = 0.0f;														//!< ^C}[

static const int OBJMAX				= 128;
static const int DBGMAX				= 16;

int g_nObjNum[ OBJMAX ];

int g_nGraNum = -1;

static const int STRMAX				= 16;

int g_nDbgNum[ DL::EDDMETER_MAX + STRMAX ] = { -1 };


int g_nFontNum = -1;
SDebug	g_SDbg;																	//!< fobO
float	g_fMeter[ 4 ];															//!< v[^[

float	g_fMinFps = FRAMERATE;													//!< vŏl
float	g_fMaxFps = 0.0f;														//!< vől
float	g_fAveFps = 0.0f;														//!< vϒl
int		g_nFrameCnt = 0;														//!< vt[

char	g_cMinFps[ 256 ];
char	g_cMaxFps[ 256 ];
char	g_cAveFps[ 256 ];
char	g_cNowFps[ 256 ];
char	g_cLogStr[ 8 ][ 256 ];

BYTE	g_byKey[ DL::CDLInput::KEYBUFFER_MAX ];
BOOL	g_bKeyF2 = FALSE;														//!< F2L[

DIMOUSESTATE	g_DIMS;
POINT	g_ptMouse;

char	g_cMouseX[ 256 ];
char	g_cMouseY[ 256 ];
char	g_cMouseZ[ 256 ];
char	g_cMouseL[ 256 ];
char	g_cMouseR[ 256 ];

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				LRESULT CALLBACK WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
 *	@retval			LRESULT
 *	@brief			EChEvV[W
 ******************************************************************************/
LRESULT CALLBACK WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
	case WM_DESTROY:															//!< EChE
		::PostQuitMessage( 0 );													//!< WM_QUIT𑗂
		return ::DefWindowProc( hWnd, msg, wParam, lParam );
	default :
		return ::DefWindowProc( hWnd, msg, wParam, lParam );
	}
	return ::DefWindowProc( hWnd, msg, wParam, lParam );
}

/*******************************************************************************
 *	@fn				int Init( const HINSTANCE& hInst )
 *	@param[in]		hInst			CX^Xnh
 *	@retval			int			
 *	@brief			AvP[V̏
 ******************************************************************************/
int Init( const HINSTANCE& hInst )
{
	// dŇ
	// L̊m
	g_hMutex = ::CreateMutex( NULL, FALSE, APPNAME );
	// Ľ
	if( ::WaitForSingleObject( g_hMutex, 0 ) != WAIT_OBJECT_0 )
	{
		_ASSERT( 0 && "WaitForSingleObject()" );
		::CloseHandle( g_hMutex );
		return EXIT_FAILURE;
	}

	// EChE
	WNDCLASS			wc;														//!< EChENX
	// EChENX̓o^
	wc.style				= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc			= static_cast<WNDPROC>( WndProc );					//!< bZ[W󂯎EChE֐
	wc.cbClsExtra			= 0;
	wc.cbWndExtra			= 0;
	wc.hInstance			= hInst;
	wc.hIcon				= NULL;												//!< ACRo^
	wc.hCursor				= ::LoadCursor( NULL, IDC_ARROW );					//!< J[\o^
	wc.hbrBackground		= static_cast<HBRUSH>( ::GetStockObject( WHITE_BRUSH ) );
	wc.lpszMenuName			= NULL;												//!< j[̓o^
	wc.lpszClassName		= APPNAME;
	// EChENX̓o^
	if( !::RegisterClass( &wc ) ) return EXIT_FAILURE;

	int nSizeX = APPWIDTH;
	int nSizeY = APPHEIGHT;
	int nPosX = ( ::GetSystemMetrics( SM_CXSCREEN ) - nSizeX ) / 2;;
	int nPosY = ( ::GetSystemMetrics( SM_CYSCREEN ) - nSizeY ) / 2;;
	// EChE쐬
	g_hWnd = ::CreateWindow( APPNAME,											//!< NX
							 APPNAME,											//!< ^Cg
							 WS_POPUP,											//!< X^C( WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU )
							 nPosX,												//!< wW
							 nPosY,												//!< xW
							 nSizeX,											//!< 
							 nSizeY,											//!< 
							 NULL,												//!< eEChẼnh
							 NULL,												//!< j[nh
							 hInst,												//!< CX^Xnh
							 NULL );											//!< lParam

	// EChE̍쐬
	if( !g_hWnd ) return EXIT_FAILURE;
	// EChE̕\Ԃ̐ݒ
	::ShowWindow( g_hWnd, SW_SHOW );
	// EChE̍XV
	::UpdateWindow( g_hWnd );

	return EXIT_SUCCESS;
}

/*******************************************************************************
 *	@fn				int Exit( void )
 *	@retval			int			
 *	@brief			AvP[V̏I
 ******************************************************************************/
int Exit( void )
{
	if( g_hWnd != NULL )
	{
		::DestroyWindow( g_hWnd );
		g_hWnd = NULL;
		::UnregisterClass( APPNAME, NULL );
	}
	if( g_hMutex != NULL ){ ::CloseHandle( g_hMutex ); g_hMutex = NULL; }
	return EXIT_SUCCESS;
}

/*******************************************************************************
 *	@fn				BOOL ProcessEvent( void )
 *	@retval			BOOL			
 *	@brief			Cxg̎s
 ******************************************************************************/
BOOL ProcessEvent( void )
{
	MSG	msg;
	if( !g_bProg ) return FALSE;
	// botLPOOŎgpBɂ̃AvŗDŎgp
	while( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
	{
		if( !::GetMessage( &msg, NULL, 0, 0 ) )
			return FALSE;
		::TranslateMessage( &msg );
		::DispatchMessage( &msg );
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				BOOL Init( void )
 *	@retval			BOOL			TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
BOOL Init( void )
{
	// gpNX̐ݒƎ擾
	g_pGraph = reinterpret_cast<DL::CDLGraph*>( DL::StartupGraph( APPWIDTH, APPHEIGHT, TRUE ) );
	g_pInput = reinterpret_cast<DL::CDLInput*>( DL::StartupInput() );
	g_pDebug = reinterpret_cast<DL::CDLDebug*>( DL::StartupDebug() );

	// 
	DL::Init( g_hWnd, FRAMERATE );

	int nMat[ FVFTEX_MAX ];
	for( int i = 0; i < FVFTEX_MAX; i++ )
		nMat[ i ] = -1;

	// fobȌ
	g_SDbg.m_bUsed	= TRUE;
	RECT m_DbgRect = { APPWIDTH - 160, 0, APPWIDTH, 480 };
	g_SDbg.m_reRect = m_DbgRect;

	{
		DL::SD3DVERTEX SVertex[ 4 ] =
		{
			{   0.0f,   0.0f, 0.0f, 1.0f, 0xffff0000, 0.0f, 0.0f },
			{ 800.0f,   0.0f, 0.0f, 1.0f, 0xff00ff00, 0.0f, 0.0f },
			{ 800.0f, 600.0f, 0.0f, 1.0f, 0xff0000ff, 0.0f, 0.0f },
			{   0.0f, 600.0f, 0.0f, 1.0f, 0xff00ffff, 0.0f, 0.0f },
		};
		g_nObjNum[ 1 ] = g_pGraph->AddVertex( 1,nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, 4, SVertex );
	}

	// J[\
	{
		DL::SD3DVERTEX SCursor[ 3 ] =
		{
			{  0.0f,  0.0f, 0.0f, 1.0f, 0xffffffff, 0.0f, 0.0f },
			{ 20.0f,  5.0f, 0.0f, 1.0f, 0xffffffff, 0.0f, 0.0f },
			{  5.0f, 20.0f, 0.0f, 1.0f, 0xffffffff, 0.0f, 0.0f },
		};
		g_nObjNum[ 2 ] = g_pGraph->AddVertex( 200, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, 3, SCursor );
	}

	// 摜쐬eNX`ɓ\t
	{
		// http://marupeke296.com/WINT_ExampleOfGetGlyphOutline.html
		GLYPHMETRICS gm;
		CONST MAT2 mat = { { 0, 1 }, { 0, 0 }, { 0, 0 }, { 0, -1 } };
		HFONT hFont = ::CreateFont( 24, 0, 0, 0, 0,
			FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_TT_ONLY_PRECIS,
			CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, "lr SVbN" );

		HDC hdc = ::GetDC( NULL );
		HFONT hOldFont = static_cast<HFONT>( ::SelectObject( hdc, hFont ) );

		char *c = "";
		UINT code = 0;
		if( ::IsDBCSLeadByte( *c ) )
			code = (BYTE)c[ 0 ] << 8 | (BYTE)c[ 1 ];
		else
			code = c[ 0 ];

		int nSize = ::GetGlyphOutline( hdc, code, GGO_GRAY8_BITMAP, &gm, 0, NULL, &mat );
		BYTE *pBuf = new BYTE[ nSize ];
		::GetGlyphOutline( hdc, code, GGO_GRAY8_BITMAP, &gm, nSize, pBuf, &mat );

		::SelectObject( hdc, hOldFont );
		::DeleteObject( hFont );
		::ReleaseDC( NULL, hdc );

		BYTE *pBuf2 = new BYTE[ nSize * 4 ];

		int nW = ( ( gm.gmBlackBoxX + 3 ) & 0xFFFFFFFC );
		int nH = gm.gmBlackBoxY;
		for( int i = 0; i < nH; i++ )
			for( int j = 0, k = 0; k < nW; j+=4, k++ )
			{
				int nData1 = i * nW * 4 + j;
				int nData2 =  ( nH - 1 - i ) * nW + k;
				pBuf2[ nData1 + 0 ] = ( 255 * pBuf[ nData2 ] / 64 );
				pBuf2[ nData1 + 1 ] = ( 255 * pBuf[ nData2 ] / 64 );
				pBuf2[ nData1 + 2 ] = ( 255 * pBuf[ nData2 ] / 64 );
				pBuf2[ nData1 + 3 ] = ( 255 * pBuf[ nData2 ] / 64 );
		}

		int nNum = g_pGraph->LoadTex( pBuf2, nSize * 4, nW, nH );
		delete[] pBuf2;

		delete[] pBuf;

		//
		DL::SD3DVERTEX SVertex[ 4 ] =
		{
			{ 100.0f, 130.0f, 0.0f, 1.0f, 0x80ff0000, 0.0f, 0.0f },
			{ 230.0f, 130.0f, 0.0f, 1.0f, 0x8000ff00, 1.0f, 0.0f },
			{ 230.0f, 260.0f, 0.0f, 1.0f, 0x800000ff, 1.0f, 1.0f },
			{ 100.0f, 260.0f, 0.0f, 1.0f, 0x800ff000, 0.0f, 1.0f },
		};
		nMat[ 0 ] = nNum;
		g_nObjNum[ 100 ] = g_pGraph->AddVertex( 11, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_ADD, 4, SVertex );
	}

	int nWhiteTex, nBlackTex;
	// |쐬iƍ̃eNX`\tj
	{
		int nSize;
		// eNX`
		int nW = 4, nH = 4;
		nSize = nW * nH * 4;
		BYTE *pBuf = new BYTE[ nSize ];

		for( int i = 0; i < nH; i++ )
			for( int j = 0, k = 0; k < nW; j+=4, k++ )
			{
				int nData = i * nW * 4 + j;
				pBuf[ nData + 0 ] = 0xFF;	// R
				pBuf[ nData + 1 ] = 0xFF;	// G
				pBuf[ nData + 2 ] = 0xFF;	// B
				pBuf[ nData + 3 ] = 0xFF;	// A
		}
		nWhiteTex = g_pGraph->LoadTex( pBuf, nSize, nW, nH );
		// eNX`
		for( int i = 0; i < nH; i++ )
			for( int j = 0, k = 0; k < nW; j+=4, k++ )
			{
				int nData = i * nW * 4 + j;
				pBuf[ nData + 0 ] = 0x00;	// R
				pBuf[ nData + 1 ] = 0x00;	// G
				pBuf[ nData + 2 ] = 0x00;	// B
				pBuf[ nData + 3 ] = 0xFF;	// A
		}
		nBlackTex = g_pGraph->LoadTex( pBuf, nSize, nW, nH );
		delete[] pBuf;
	}

	// t@Cɓǂݍŕ\
	{
		FILE *fp;
		::fopen_s( &fp, "spheremap.png", "rb" );
		::fseek( fp, 0L, SEEK_END );
		int nSize = ::ftell( fp );
		::fseek( fp, 0L, SEEK_SET );

		BYTE *pBuf = new BYTE[ nSize ];
		::fread_s( pBuf, nSize, sizeof( BYTE ), nSize, fp );
		::fclose( fp );

		int nNum = g_pGraph->LoadMem( pBuf, nSize );

		// 
		RECT rc;
		nMat[ 0 ] = nNum;
		rc.left = 20+128*0; rc.right = 20+128*1; rc.top = 240+128*0; rc.bottom = 240+128*1;
		g_nObjNum[ 50 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc, 0xFFFFFFFF );
		rc.left = 20+128*1; rc.right = 20+128*2, rc.top = 240+128*0; rc.bottom = 240+128*1;
		g_nObjNum[ 51 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_ADD, rc, 0xFFFFFFFF );
		rc.left = 20+128*2; rc.right = 20+128*3, rc.top = 240+128*0; rc.bottom = 240+128*1;
		g_nObjNum[ 52 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_SUB, rc, 0xFFFFFFFF );

		nMat[ 1 ] = nWhiteTex;
		rc.left = 20+128*3; rc.right = 20+128*4, rc.top = 240+128*0; rc.bottom = 240+128*1;
		g_nObjNum[ 53 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_MUL, rc, 0xFFFFFFFF );

		nMat[ 1 ] = nBlackTex;
		rc.left = 20+128*0; rc.right = 20+128*1, rc.top = 240+128*1; rc.bottom = 240+128*2;
		g_nObjNum[ 54 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_SCR, rc, 0xFFFFFFFF );

		nMat[ 1 ] = nWhiteTex;
		rc.left = 20+128*1; rc.right = 20+128*2, rc.top = 240+128*1; rc.bottom = 240+128*2;
		g_nObjNum[ 55 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_CMPD, rc, 0xFFFFFFFF );

		nMat[ 1 ] = nBlackTex;
		rc.left = 20+128*2; rc.right = 20+128*3, rc.top = 240+128*1; rc.bottom = 240+128*2;
		g_nObjNum[ 56 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_CMPL, rc, 0xFFFFFFFF );

		nMat[ 1 ] = nBlackTex;
		rc.left = 20+128*3; rc.right = 20+128*4, rc.top = 240+128*1; rc.bottom = 240+128*2;
		g_nObjNum[ 57 ] = g_pGraph->AddRect( 100, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_EXC, rc, 0xFFFFFFFF );

		delete[] pBuf;
	}

	for( int i = 0; i < FVFTEX_MAX; i++ )
		nMat[ i ] = -1;
	// fobOpIuWFNgǉ
	{
		// y
		int nColor0 = 0x8F000000;
		g_nDbgNum[ 0 ] = g_pGraph->AddRect( OBJMAX + 0, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, m_DbgRect, nColor0 );

		// ̃C
		RECT rc1;
		rc1.left = m_DbgRect.left + 100;
		rc1.top = 0;
		rc1.right = m_DbgRect.left + 100 + 1;
		rc1.bottom = 16;
		int nColor1 = 0xCFFF0000;
		g_nDbgNum[ 1 ] = g_pGraph->AddRect( OBJMAX + 10, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc1, nColor1 );

		// vO[^[
		RECT rc2;
		rc2.left = rc2.top = rc2.right = 0; rc2.bottom = 16;
		int nColor2 = 0xCF00FF00;
		g_nDbgNum[ 2 ] = g_pGraph->AddRect( OBJMAX + 2, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc2, nColor2 );

		// 揈[^[
		rc2.left = rc2.top = rc2.right = 0; rc2.bottom = 16;
		int nColor3 = 0xCF008080;
		g_nDbgNum[ 3 ] = g_pGraph->AddRect( OBJMAX + 3, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc2, nColor3 );

		// Cu[^[
		rc2.left = rc2.top = rc2.right = 0; rc2.bottom = 16;
		int nColor4 = 0xCF0000FF;
		g_nDbgNum[ 4 ] = g_pGraph->AddRect( OBJMAX + 4, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc2, nColor4 );

		// [^[
		rc2.left = rc2.top = rc2.right = 0; rc2.bottom = 16;
		int nColor5 = 0xCF00FF00;
		g_nDbgNum[ 5 ] = g_pGraph->AddRect( OBJMAX + 5, nMat, DL::ED3DDRAW_ON, DL::ED3DSTATE_NORMAL, rc2, nColor5 );

		// fޓo^
		g_nFontNum = g_pGraph->LoadFont( "lr SVbN", 16 );

		// \p
		for( int i = 0; i < STRMAX; i++ )
		{
			int DbgNum = OBJMAX + DL::EDDMETER_MAX + i;

			rc2 = m_DbgRect;
			rc2.top = 16 + 8 + ( i + 0 ) * 16;
			rc2.bottom = 16 + 8 + ( i + 1 ) * 16;
			int nColor2 = 0xFFFFFFFF;
			LPSTR lpStr = "";

			nMat[ 0 ] = g_nFontNum;
			g_nDbgNum[ DL::EDDMETER_MAX + i ] = g_pGraph->AddText( DbgNum, nMat, DL::ED3DDRAW_OFF, rc2, nColor2, lpStr );
		}

		g_pGraph->Connect( g_nDbgNum[ 0 ], g_nDbgNum[ 1 ] );
		g_pGraph->Connect( g_nDbgNum[ 2 ], g_nDbgNum[ 3 ] );
		g_pGraph->Connect( g_nDbgNum[ 1 ], g_nDbgNum[ 2 ] );


		g_pGraph->Disconnect( g_nDbgNum[ 2 ] );
		g_pGraph->Disconnect( g_nDbgNum[ 0 ] );
		g_pGraph->Disconnect( g_nDbgNum[ 1 ] );
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				void KeyState( const BYTE* byKey )
 *	@param[in]		byKey						L[obt@
 *	@retval			none						Ȃ
 *	@brief			L[
 ******************************************************************************/
void KeyState( const BYTE* byKey )
{
	::memcpy_s( g_byKey, DL::CDLInput::KEYBUFFER_MAX, byKey, DL::CDLInput::KEYBUFFER_MAX );

	if( g_byKey[ DIK_F2 ] & 0x80 )												//!< F2L[
	{
		if( ( !g_bKeyF2 ) && ( g_hWnd != NULL ) )
		{
			g_bKeyF2 = TRUE;
			switch( g_eDisp )
			{
			case enumDisplay_640x480:											//!< 640x480 -> 800x600
				{
					g_nWidth	= 800;
					g_nHeight	= 600;
					g_bMode		= TRUE;
					g_eDisp = enumDisplay_800x600;
					g_pDebug->SetLog( "800x600" );
				}
				break;
			case enumDisplay_800x600:											//!< 800x600 -> 1024x768
				{
					g_nWidth	= 1024;
					g_nHeight	= 768;
					g_bMode		= TRUE;
					g_eDisp = enumDisplay_1024x768;
					g_pDebug->SetLog( "1024x768" );
				}
				break;
			case enumDisplay_1024x768:											//!< 1024x768 -> 800x600
				{
					g_nWidth	= ::GetSystemMetrics( SM_CXSCREEN );
					g_nHeight	= ::GetSystemMetrics( SM_CYSCREEN );
					g_bMode		= FALSE;
					g_eDisp = enumDisplay_FullScreen;
					g_pDebug->SetLog( "FullScreen" );
				}
				break;
			case enumDisplay_FullScreen:										//!< tXN[ -> 640x480
				{
					g_nWidth	= 640;
					g_nHeight	= 480;
					g_bMode		= TRUE;
					g_eDisp = enumDisplay_640x480;
					g_pDebug->SetLog( "640x480" );
				}
				break;
			}

			int nPosX = ( ::GetSystemMetrics( SM_CXSCREEN ) - g_nWidth ) / 2;
			int nPosY = ( ::GetSystemMetrics( SM_CYSCREEN ) - g_nHeight ) / 2;
			// ʐ؂ւ
			g_pGraph->ChangeDisplay( nPosX, nPosY, g_nWidth, g_nHeight, g_bMode );

			::MoveWindow( g_hWnd, nPosX, nPosY, g_nWidth, g_nHeight, TRUE );
		}
	}else
		g_bKeyF2 = FALSE;
	// I
	if( g_byKey[ DIK_ESCAPE ] & 0x80 )											//!< ESCL[
	{
		g_bProg = FALSE;
	}
}

/*******************************************************************************
 *	@fn				void Proc( BYTE* byKey,
 *							   DIMOUSESTATE* diMouse )
 *	@param[in]		byKey						L[obt@
 *	@param[in]		diMouse						}EXobt@
 *	@retval			none						Ȃ
 *	@brief			vO
 ******************************************************************************/
void Proc( BYTE* byKey, DIMOUSESTATE* diMouse )
{
	g_DIMS = *diMouse;

	// L[
	KeyState( byKey );

	// J[\
	::GetCursorPos( &g_ptMouse );
	if( g_bMode )
		::ScreenToClient( g_hWnd, &g_ptMouse );

	{
		DL::SD3DOBJECT *m_pD3DObj = g_pGraph->GetObject( g_nObjNum[ 2 ] );
		DL::SD3DDATA* pData = static_cast<DL::SD3DDATA*>( m_pD3DObj->m_pObj );

		DL::SD3DVERTEX* v0 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 0 ] );
		DL::SD3DVERTEX* v1 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 1 ] );
		DL::SD3DVERTEX* v2 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 2 ] );

		v0->x = static_cast<float>( g_ptMouse.x + 0 );
		v0->y = static_cast<float>( g_ptMouse.y + 0 );
		v1->x = static_cast<float>( g_ptMouse.x + 20 );
		v1->y = static_cast<float>( g_ptMouse.y + 5 );
		v2->x = static_cast<float>( g_ptMouse.x + 5 );
		v2->y = static_cast<float>( g_ptMouse.y + 20 );

	}
}

/*******************************************************************************
 *	@fn				void DebugDisp( void )
 *	@retval			none						Ȃ
 *	@brief			fobOʕ\
 ******************************************************************************/
void DebugDisp( void )
{
	// [^[\
	// OvO̎s
	// P揈̎s
	// QCu̎s
	// R̎s
	// v@̊֌WA`悪P[vɂ
	g_fMeter[ 0 ] = g_pDebug->GetMeasure( DL::EDDMETER_PROGRAM );
	g_fMeter[ 1 ] = g_pDebug->GetMeasure( DL::EDDMETER_MOVIE );
	g_fMeter[ 2 ] = g_pDebug->GetMeasure( DL::EDDMETER_LIBRARY );
	g_fMeter[ 3 ] = g_pDebug->GetMeasure( DL::EDDMETER_SYNC );

	float fTimer1 = 0.0f;
	float fTimer2 = 0.0f;
	float fTimer3 = 0.0f;
	float fTimer4 = 0.0f;
	// vO[^[
	{
		DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( g_nDbgNum[ 2 ] );
		DL::SD3DDATA* pData = static_cast<DL::SD3DDATA*>( m_pD3DObj->m_pObj );

		DL::SD3DVERTEX* v0 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 0 ] );
		DL::SD3DVERTEX* v1 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 1 ] );
		DL::SD3DVERTEX* v2 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 2 ] );
		DL::SD3DVERTEX* v3 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 3 ] );

		fTimer1 = ( g_fMeter[ 0 ] / FRAMERATE ) * 100.0f;

		v0->x = static_cast<float>( g_SDbg.m_reRect.left + 0 );
		v1->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer1 );
		v2->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer1 );
		v3->x = static_cast<float>( g_SDbg.m_reRect.left + 0 );
	}
	// 揈[^[
	{
		DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( g_nDbgNum[ 3 ] );
		DL::SD3DDATA* pData = static_cast<DL::SD3DDATA*>( m_pD3DObj->m_pObj );

		DL::SD3DVERTEX* v0 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 0 ] );
		DL::SD3DVERTEX* v1 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 1 ] );
		DL::SD3DVERTEX* v2 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 2 ] );
		DL::SD3DVERTEX* v3 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 3 ] );

		fTimer2 = ( g_fMeter[ 1 ] / FRAMERATE ) * 100.0f + fTimer1;

		v0->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer1 );
		v1->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer2 );
		v2->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer2 );
		v3->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer1 );
	}
	// Cu[^[
	{
		DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( g_nDbgNum[ 4 ] );
		DL::SD3DDATA* pData = static_cast<DL::SD3DDATA*>( m_pD3DObj->m_pObj );

		DL::SD3DVERTEX* v0 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 0 ] );
		DL::SD3DVERTEX* v1 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 1 ] );
		DL::SD3DVERTEX* v2 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 2 ] );
		DL::SD3DVERTEX* v3 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 3 ] );

		fTimer3 = ( g_fMeter[ 2 ] / FRAMERATE ) * 100.0f + fTimer2;

		v0->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer2 );
		v1->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer3 );
		v2->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer3 );
		v3->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer2 );
	}
	// [^[
	{
		DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( g_nDbgNum[ 5 ] );
		DL::SD3DDATA* pData = static_cast<DL::SD3DDATA*>( m_pD3DObj->m_pObj );

		DL::SD3DVERTEX* v0 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 0 ] );
		DL::SD3DVERTEX* v1 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 1 ] );
		DL::SD3DVERTEX* v2 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 2 ] );
		DL::SD3DVERTEX* v3 = static_cast<DL::SD3DVERTEX*>( &pData->m_pData[ 3 ] );

		fTimer4 = ( g_fMeter[ 3 ] / FRAMERATE ) * 100.0f + fTimer3;

		v0->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer3 );
		v1->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer4 );
		v2->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer4 );
		v3->x = static_cast<float>( g_SDbg.m_reRect.left + fTimer3 );
	}

	// \
	{
		if( g_nFrameCnt > 0 )
		{
			float fFps = g_fMeter[ 0 ] + g_fMeter[ 1 ] + g_fMeter[ 2 ];

			// vŏl
			int DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 0 ];
			DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			if( fFps < g_fMinFps ) g_fMinFps = fFps;

			DL::SD3DTEXT* pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cMinFps, 256, "Min %.1f fps", g_fMinFps );
			pText->m_szStr = g_cMinFps;

			// vől
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 1 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			if( g_fMaxFps < fFps ) g_fMaxFps = fFps;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cMaxFps, 256, "Max %.1f fps", g_fMaxFps );
			pText->m_szStr = g_cMaxFps;

			// vϒl
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 2 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			g_fAveFps = ( ( g_fAveFps * ( g_nFrameCnt - 1 ) ) + fFps ) / g_nFrameCnt;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cAveFps, 256, "Ave %.3f fps", g_fAveFps );
			pText->m_szStr = g_cAveFps;

			// vl
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 3 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cNowFps, 256, "Now %.3f fps", fFps );
			pText->m_szStr = g_cNowFps;


			// }EXwW
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 4 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cMouseX, 256, "X = %d ", g_ptMouse.x );
			pText->m_szStr = g_cMouseX;

			// }EXxW
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 5 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			::sprintf_s( g_cMouseY, 256, "Y = %d ", g_ptMouse.y );
			pText->m_szStr = g_cMouseY;

			// }EX{^
			DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 6 ];
			m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			if( g_DIMS.rgbButtons[ 0 ] & 0x80 )
				::sprintf_s( g_cMouseL, 256, "L = ON" );
			else
				::sprintf_s( g_cMouseL, 256, "L = OFF" );
			pText->m_szStr = g_cMouseL;

		}
		g_nFrameCnt++;
	}

	// O\
	{
		int LogNum = g_pDebug->GetLogCnt();
		for( int i = LogNum-1, j = 0; j < 8; i--, j++ )
		{
			if( i < 0 ) break;
			int DbgNum = g_nDbgNum[ DL::EDDMETER_MAX + 8 + j ];

			DL::SD3DOBJECT* m_pD3DObj = g_pGraph->GetObject( DbgNum );
			m_pD3DObj->m_eDraw = DL::ED3DDRAW_ON;

			DL::SD3DTEXT* pText = static_cast<DL::SD3DTEXT*>( m_pD3DObj->m_pObj );
			std::string str = g_pDebug->GetLog( i );
			::sprintf_s( g_cLogStr[ j ], 256, str.c_str() );
			pText->m_szStr = g_cLogStr[ j ];
		}
	}
}

/*******************************************************************************
 *	@fn				int WINAPI WinMain( HINSTANCE hInstance,
 *									    HINSTANCE hPrevInstance,
 *										LPSTR lpCmdLine,
 *										int nCmdShow )
 *	@param[in]		hInstance		CX^Xnh
 *	@param[in]		hPrevInstance	CX^Xnh
 *	@param[in]		lpCmdLine		
 *	@param[in]		nCmdShow		
 *	@retval			LRESULT			
 *	@brief			vON
 ******************************************************************************/
int WINAPI WinMain( HINSTANCE hInstance,
				    HINSTANCE hPrevInstance,
					LPSTR lpCmdLine,
					int nCmdShow )
{
	// AvP[V̏
	if( Init( hInstance ) == EXIT_FAILURE ) return EXIT_FAILURE;
	// DirectXLibrary̏
	if( !Init() ) goto ERR_EXIT;

	// [v
	do
	{
		DL::Exec( Proc );
		DebugDisp();
	} while( ProcessEvent() );

ERR_EXIT:
	// DirectXLibrary̏I
	DL::End();
	// AvP[V̏I
	Exit();

	return EXIT_SUCCESS;
}
