/*******************************************************************************
 *	@file			DLSound.h
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			20-Jun-2010(Sun)
 ******************************************************************************/

#ifndef	__DLSOUND_INCLUDE__
#define	__DLSOUND_INCLUDE__

// vvZbT---------------------------------------------------------------
#include "DL.h"
#include <vector>
#include <process.h>

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// 萔`---------------------------------------------------------------------
#pragma once

// 񋓌^`-------------------------------------------------------------------
/*******************************************************************************
 *	@enum		EDSPLAY			DLSound.h		"DLSound.h"
 *	@brief		Đ
 ******************************************************************************/
enum EDSPLAY
{
	EDSPLAY_NULL			= 0,												//!< Ȃ
	EDSPLAY_WAIT,																//!< ҋ@
	EDSPLAY_PLAY,																//!< Đ
	EDSPLAY_LOOP,																//!< [vĐ
	EDSPLAY_STOP,																//!< ~
	EDSPLAY_PAUSE,																//!< ꎞ~
	EDSPLAY_FADEIN,																//!< tF[hC
	EDSPLAY_FADEOUT,															//!< tF[hAEg

	EDSPLAY_MAX,
};

// \̒`-------------------------------------------------------------------
/*******************************************************************************
 *	@struct		SDLSOUND		DLSound.h		"DLSound.h"
 *	@brief		Sound\
 ******************************************************************************/
struct SDLSOUND
{
	SDLSOUND()
		: m_b3DSound( FALSE )
	{
	}

	//
	BOOL					m_b3DSound;											//!< RcTEhgptO
};

/*******************************************************************************
 *	@struct		SDSDEVICE		DLSound.h		"DLSound.h"
 *	@brief		foCX\
 ******************************************************************************/
struct SDSDEVICE
{
	SDSDEVICE( const LPGUID& lpGuid = NULL,
			   const LPCSTR& lpDesc = NULL,
			   const LPCSTR& lpModule = NULL )
		: m_lpGuid( lpGuid )
		, m_lpDesc( lpDesc )
		, m_lpModule( lpModule )
	{
	}

	//
	LPGUID					m_lpGuid;											//!< GUID
	LPCSTR					m_lpDesc;											//!< foCX
	LPCSTR					m_lpModule;											//!< W[
};

/*******************************************************************************
 *	@struct		SDSPOS			DLSound.h		"DLSound.h"
 *	@brief		W\
 ******************************************************************************/
struct SDSPOS
{
	SDSPOS( const D3DVALUE& fX = 0.0f,
			const D3DVALUE& fY = 0.0f,
			const D3DVALUE& fZ = 0.0f )
		: m_fX( fX )
		, m_fY( fY )
		, m_fZ( fZ )
	{
	}

	//
	D3DVALUE				m_fX;												//!< wW
	D3DVALUE				m_fY;												//!< xW
	D3DVALUE				m_fZ;												//!< yW
};

/*******************************************************************************
 *	@struct		SDSLISTENER		DLSound.h		"DLSound.h"
 *	@brief		Xi[\
 ******************************************************************************/
struct SDSLISTENER
{
	SDSLISTENER()
		: m_lpListener( NULL )
		, m_SPos()
		, m_SVel()
		, m_SFront()
		, m_STop()
		, m_fRolloff( 1.0f )
		, m_fDoppler( 0.0f )
	{
	}

	// 
	LPDIRECTSOUND3DLISTENER8	m_lpListener;									//!< Xi[
	SDSPOS					m_SPos;												//!< ʒuW
	SDSPOS					m_SVel;												//!< xW
	SDSPOS					m_SFront;											//!< OxNg
	SDSPOS					m_STop;												//!< xNg
	D3DVALUE				m_fRolloff;											//!< [EIt
	D3DVALUE				m_fDoppler;											//!< hbv[W
};

/*******************************************************************************
 *	@struct		SDSBUFFER		DLSound.h		"DLSound.h"
 *	@brief		obt@\
 ******************************************************************************/
struct SDSBUFFER
{
	SDSBUFFER()
		: m_lpBuffer( NULL )
		, m_DSDesc()

		, m_lp3DBuffer( NULL )
		, m_SPos()
		, m_SVel()

		, m_szName()
	{
	}

	// f[^
	LPDIRECTSOUNDBUFFER8	m_lpBuffer;											//!< ZJ_Eobt@
	DSBUFFERDESC			m_DSDesc;											//!< obt@

	LPDIRECTSOUND3DBUFFER8	m_lp3DBuffer;										//!< Rcobt@
	SDSPOS					m_SPos;												//!< ʒuW
	SDSPOS					m_SVel;												//!< xW
	
	LPCSTR					m_szName;											//!< O
};

/*******************************************************************************
 *	@struct		SDSOBJECT		DLSound.h		"DLSound.h"
 *	@brief		IuWFNg\
 ******************************************************************************/
struct SDSOBJECT
{
	SDSOBJECT()
		: m_bUsed( FALSE )
		, m_eObj( EOBJECT_NULL )
		, m_nPrio( -1 )

		, m_nMatNum( -1 )

		, m_ePlay( EDSPLAY_WAIT )

		, m_SPos()
		, m_SVel()
	{
	}

	// {
	BOOL					m_bUsed;											//!< gptO
	EOBJECT					m_eObj;												//!< IuWFNg
	int						m_nPrio;											//!< `vCIeB
	// f
	int						m_nMatNum;											//!< fޔԍ
	// 
	EDSPLAY					m_ePlay;											//!< Đ

	// Wݒ
	SDSPOS					m_SPos;												//!< ʒuWiDSBUFFERƓj
	SDSPOS					m_SVel;												//!< xWiDSBUFFERƓj
};

// NX-----------------------------------------------------------------------
/*******************************************************************************
 *	@class		CDLSndStream	DLSound.h			"DLSound.h"
 *	@brief		CDLSndStreamNX
 ******************************************************************************/
class CDLSndStream
{
// 萔`---------------------------------------------------------------------
private:
	static const int DSEVENT_MAX	= 3;										//!< Cxg
protected:
public:

// o֐-------------------------------------------------------------------
private:
	static unsigned __stdcall StreamThread( void* pVoid );						//!< Xbh

	int WaveReset( void );														//!< ŏ̈ʒuփV[N
	int BlockCopy( int n );														//!< f[^̃Rs[
	DWORD WaveRead( const UINT& cbRead,
					BYTE* pbDest );												//!< f[^̓ǂݍ

protected:
public:
	CDLSndStream( void );
	~CDLSndStream( void );

	int Init( const LPDIRECTSOUND8& pSound );									//!< 

	int LoadWav( const LPSTR& szName );											//!< Waveǂݍ݁iXg[~Oj
	int RemoveWav( void );														//!< Wave

	int Play( void );															//!< Đ
	int Stop( void );															//!< ~

	int SetVolume( const int& nVolume );										//!< {[ݒ

// oϐ-------------------------------------------------------------------
private:
	HMMIO					m_hMMIO;											//!< t@Cnh
	MMCKINFO				m_ckRiff;
	MMCKINFO				m_ckInfo;

	DWORD					m_dwBuffSize;										//!< TEhEf[^̃obt@TCY
	BOOL					m_bUsed;											//!< gptO
	int						m_nVolume;											//!< {[
	
	HANDLE					m_hEvent[ DSEVENT_MAX ];							//!< Cxgnh

	//
	LPDIRECTSOUND8			m_lpSound;											//!< DirectSound IuWFNg

	LPDIRECTSOUNDBUFFER8	m_lpBuffer;											//!< ZJ_Eobt@
	DSBUFFERDESC			m_DSDesc;											//!< obt@
	LPDIRECTSOUNDNOTIFY8	m_lpNotify;											//!< Cxg

protected:
public:

};

/*******************************************************************************
 *	@class		CDLSound		DLSound.h			"DLSound.h"
 *	@brief		CDLSoundNX
 ******************************************************************************/
class CDLSound
{
// 萔`---------------------------------------------------------------------
private:
protected:
public:
	static const int BUFFER_MAX		= 32;										//!< obt@
	static const int OBJECT_MAX		= 64;										//!< IuWFNg
	static const int STREAM_MAX		= 4;										//!< Xg[

// o֐-------------------------------------------------------------------
private:
	static int ( CDLSound::*StepDel[ EOBJECT_SOUNDEND - EOBJECT_SOUNDSTART ] )( const int& nNum );
	static int ( CDLSound::*StepPlay[ EDSPLAY_MAX ] )( const int& nNum );

	static BOOL CALLBACK DSEnumCallback( LPGUID lpGuid,
										 LPCSTR lpcstrDescription,
										 LPCSTR lpcstrModule,
										 LPVOID lpContext );					//!< foCX̗

	int CheckWave( const BYTE* byData );										//!< Wave

	// p[^ݒ
	int SetPosition( const SDSPOS& SPos );										//!< ʒuWݒ
	int SetVelocity( const SDSPOS& SVel );										//!< xWݒ
	int SetOrientation( const SDSPOS& SFront,
						const SDSPOS& STop );									//!< xNgݒ
	int SetRolloff( const D3DVALUE& fRolloff );									//!< [EItݒ
	int SetDoppler( const D3DVALUE& fDoppler );									//!< hbv[Wݒ

	int SetPosition( SDSBUFFER& pBuf,
					 const SDSPOS& SPos );										//!< ʒuWݒ
	int SetVelocity( SDSBUFFER& pBuf,
					 const SDSPOS& SVel );										//!< xWݒ

	// IuWFNg폜
	int DelBGM( const int& nNum );												//!< BGM폜
	int DelSE( const int& nNum );												//!< SE폜

	// IuWFNgs
	int ExecPlay( const int& nNum );											//!< Đ
	int ExecLoop( const int& nNum );											//!< [v
	int ExecStop( const int& nNum );											//!< ~
	int ExecPause( const int& nNum );											//!< ꎞ~
	int ExecFadeIn( const int& nNum );											//!< tF[hC
	int ExecFadeOut( const int& nNum );											//!< tF[hAEg

protected:
public:
	CDLSound( void );
	~CDLSound( void );

	void SetSound( const SDLSOUND& SSound );									//!< ZbgAbv\̐ݒ

	int Init( const HWND& hWnd );												//!< 
	int Init( const HWND& hWnd,
			  const BOOL& b3DSound );											//!< 
	int End( void );															//!< I

	// ڊ
	SDSBUFFER* GetBuffer( const int& nNum );									//!< obt@擾
	SDSOBJECT* GetObject( const int& nNum );									//!< IuWFNg擾

	// fޓǂݍ
	int LoadWav( const LPSTR& szName );											//!< Waveǂݍ
	int LoadWavStream( const int& nNum,
					   const LPSTR& szName );									//!< Waveǂݍ݁iXg[~Oj

	// fމ
	int RemoveWav( const int& nNum );											//!< Wave
	int RemoveWavStream( const int& nNum );										//!< WaveiXg[~Oj
	int RemoveALL( void );														//!< fޑS

	// IuWFNgǉ
	int AddBGM( const int& nPrio,
				const int& nMatNum,
				const EDSPLAY& ePlay,
				const SDSPOS& SPos,
				const SDSPOS& SVel );											//!< BGMǉ
	int AddSE( const int& nPrio,
			   const int& nMatNum,
			   const EDSPLAY& ePlay,
			   const SDSPOS& SPos,
			   const SDSPOS& SVel );											//!< SEǉ

	// IuWFNg폜
	int Del( const int& nNum );													//!< IuWFNg폜
	int DelALL( void );															//!< IuWFNgS폜

	// IuWFNgs
	int Play( const int& nNum );												//!< IuWFNgs
	int PlayStream( const int& nNum,
					const int& nVolume = 10000 );								//!< Xg[~Os
	int StopStream( const int& nNum );											//!< Xg[~Os

// oϐ-------------------------------------------------------------------
private:
	LPDIRECTSOUND8			m_lpSound;											//!< DirectSound IuWFNg
	DSBUFFERDESC			m_DSDesc;											//!< obt@
	LPDIRECTSOUNDBUFFER		m_lpPrimary;										//!< vC}Eobt@
	SDSLISTENER				m_SDSListener;										//!< Xi[\

	HWND					m_hWnd;												//!< EChEnh
	SDLSOUND				m_SSound;											//!< ZbgAbv\
	std::vector<SDSDEVICE>	m_vDevice;											//!< foCX
	DSCAPS					m_DSCaps;											//!< foCX̔\
	DWORD					m_dwSpeaker;										//!< Xs[J[\
	BOOL					m_b3DSound;											//!< RcTEhgptO

	// IuWFNg
	std::vector<SDSBUFFER>	m_vDSBuf;											//!< obt@\
	std::vector<SDSOBJECT>	m_vDSObj;											//!< IuWFNg\

	CDLSndStream			m_CStream0;
	CDLSndStream			m_CStream1;
	CDLSndStream			m_CStream2;
	CDLSndStream			m_CStream3;
	CDLSndStream*			m_pStream[ STREAM_MAX ];							//!< Xg[NX

protected:
public:

};

// OO[oϐ-----------------------------------------------------------

// O֐vg^Cv錾-----------------------------------------------------

}	// namespace	DL

#ifdef __cplusplus
}
#endif

#endif	// __DLSOUND_INCLUDE__
