/*******************************************************************************
 *	@file			DLSound.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			20-Jun-2010(Sun)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DLSound.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				unsigned __stdcall CDLSndStream::StreamThread( void* pVoid )
 *	@param[in]		pVoid						ėp
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Xbh
 ******************************************************************************/
unsigned __stdcall CDLSndStream::StreamThread( void* pVoid )
{
	CDLSndStream* pStream = reinterpret_cast<CDLSndStream*>( pVoid );
	HRESULT hr = DS_OK;

	// ŏ̃ubNɃf[^
	pStream->BlockCopy( 0 );

	// TEh̍Đ
	hr = pStream->m_lpBuffer->Play( 0, 0, DSBPLAY_LOOPING );
	if( SUCCEEDED( hr ) )
	{
		DWORD dwNew = 0xFFFFFFFF;
		// f[^ރ[v
		while( 1 )
		{
			// ʒ
			hr = pStream->m_lpBuffer->SetVolume( pStream->m_nVolume );

			// Cxg҂
			DWORD dwNow = ::WaitForMultipleObjects( DSEVENT_MAX, pStream->m_hEvent, FALSE, INFINITE );
			if( dwNew == dwNow ) continue;
			dwNew = dwNow;

			// ̃ubN֏
			switch( dwNow )
			{
			case WAIT_OBJECT_0 + 0: pStream->BlockCopy( 1 ); break;
			case WAIT_OBJECT_0 + 1: pStream->BlockCopy( 0 ); break;
			default: goto LOOP_END;
			}
		}
	}

LOOP_END:
	::_endthreadex( 0 );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::WaveReset( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ŏ̈ʒuփV[N
 ******************************************************************************/
int CDLSndStream::WaveReset( void )
{
	MMRESULT mmres;

	mmres = ::mmioSeek( m_hMMIO, m_ckRiff.dwDataOffset + sizeof( FOURCC ), SEEK_SET );
	if( mmres == -1 )
	{
		DXTRACE_MSG( "mmioSeek()" );
		::mmioClose( m_hMMIO, 0 );
		return FALSE;
	}

	// data
	m_ckInfo.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );
	mmres = ::mmioDescend( m_hMMIO, &m_ckInfo, &m_ckRiff, MMIO_FINDCHUNK );
	if( mmres == MMIOERR_CHUNKNOTFOUND )
	{
		DXTRACE_MSG( "mmioDescend()" );
		::mmioClose( m_hMMIO, 0 );
		return FALSE;
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::BlockCopy( int n )
 *	@param[in]		n							Rs[ubNԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			f[^̃Rs[
 ******************************************************************************/
int CDLSndStream::BlockCopy( int n )
{
	LPBYTE lpBlockAdd1, lpBlockAdd2;
	DWORD dwBlockSize1, dwBlockSize2;
	int nWaveSize;
	HRESULT hr = DS_OK;

	if( m_lpBuffer == NULL ) return FALSE;

	nWaveSize = static_cast<int>( m_dwBuffSize / ( DSEVENT_MAX - 1 ) );

	// obt@bN
	hr = m_lpBuffer->Lock( nWaveSize * n, nWaveSize,
						reinterpret_cast<LPVOID*>( &lpBlockAdd1 ), &dwBlockSize1,
						reinterpret_cast<LPVOID*>( &lpBlockAdd2 ), &dwBlockSize2, 0 );
	if( hr == DS_OK )
	{
		DWORD dwSize1 = 0, dwSize2 = 0;
		// obt@Ƀf[^Rs[
		for( dwSize1 = 0; dwSize1 < dwBlockSize1; dwSize1 += dwSize2 )
		{
			dwSize2 = WaveRead( dwBlockSize1 - dwSize1, lpBlockAdd1 + dwSize1 );
			if( dwBlockSize1 - dwSize1 != dwSize2 )
				WaveReset();
		}
		m_lpBuffer->Unlock( lpBlockAdd1, dwBlockSize1, lpBlockAdd2, dwBlockSize2 );
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				DWORD CDLSndStream::WaveRead( const UINT& cbRead,
 *												  BYTE* pbDest )
 *	@param[in]		cbRead						f[^TCY
 *	@param[in]		pbDest						Rs[Jnʒu
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			f[^̓ǂݍ
 ******************************************************************************/
DWORD CDLSndStream::WaveRead( const UINT& cbRead,
							  BYTE* pbDest )
{
	MMIOINFO mmioInfo;
	UINT cbDataIn;

	// hmmioɊւ̎擾
	if( 0 != ::mmioGetInfo( m_hMMIO, &mmioInfo, 0 ) )
		return 0;

	cbDataIn = cbRead;
	if( cbDataIn > m_ckInfo.cksize )
		cbDataIn = m_ckInfo.cksize;

	m_ckInfo.cksize = cbDataIn;

	// obt@Ɋmۂꂽ̈ɃRs[
	for( DWORD dw = 0; dw < cbDataIn; dw++ )
	{
		// ǂݍރt@CI[܂ł̌
		if( mmioInfo.pchNext == mmioInfo.pchEndRead )
		{
			if( 0 != ::mmioAdvance( m_hMMIO, &mmioInfo, MMIO_READ ) )
				return 0;
			if( mmioInfo.pchNext == mmioInfo.pchEndRead )
				return 0;
		}
		// ǂݍ񂾃t@Cobt@ɃRs[
		*( pbDest + dw ) = *( reinterpret_cast<BYTE*>( mmioInfo.pchNext ) );

		// ǂݍ񂾕𑗂
		mmioInfo.pchNext++;
	}

	// hmmioɊւ̍XV
	if( 0 != ::mmioSetInfo( m_hMMIO, &mmioInfo, 0 ) )
		return 0;

	return cbDataIn;
}

/*******************************************************************************
 *	@fn				CDLSndStream::CDLSndStream( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLSndStream::CDLSndStream( void )
	: m_hMMIO( NULL )
	, m_ckRiff()
	, m_ckInfo()

	, m_dwBuffSize( 0 )
	, m_bUsed( FALSE )
	, m_nVolume( DSBVOLUME_MAX )

	, m_lpSound( NULL )

	, m_lpBuffer( NULL )
	, m_DSDesc()
	, m_lpNotify( NULL )
{
	for( int i = 0; i < DSEVENT_MAX; i++ )
		m_hEvent[ i ] = NULL;
}

/*******************************************************************************
 *	@fn				CDLSndStream::~CDLSndStream( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLSndStream::~CDLSndStream( void )
{
}

/*******************************************************************************
 *	@fn				int CDLSndStream::Init( const LPDIRECTSOUND8& pSound )
 *	@param[in]		pSound						DirectSound IuWFNg
 *	@retval			none						Ȃ
 *	@brief			
 ******************************************************************************/
int CDLSndStream::Init( const LPDIRECTSOUND8& pSound )
{
	m_lpSound = pSound;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::LoadWav( const LPSTR& szName )
 *	@param[in]		szName						t@C
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			Waveǂݍ݁iXg[~Oj
 ******************************************************************************/
int CDLSndStream::LoadWav( const LPSTR& szName )
{
	int nRet = -1;
	HRESULT hr = DS_OK;
	MMRESULT mmres;
	WAVEFORMATEX wfex;

	// t@CnhI
	if( m_hMMIO != NULL )
	{
		::mmioClose( m_hMMIO, 0 );
		m_hMMIO = NULL;
	}
	// t@Cǂݍ
	m_hMMIO = ::mmioOpen( const_cast<char*>( szName ), NULL, MMIO_ALLOCBUF | MMIO_READ );
	if( m_hMMIO == NULL )
	{
		DXTRACE_MSG( "mmioOpen()" );
		return nRet;
	}
	// WAVE
	m_ckRiff.fccType = mmioFOURCC( 'W', 'A', 'V', 'E' );
	mmres = ::mmioDescend( m_hMMIO, static_cast<LPMMCKINFO>( &m_ckRiff ), NULL, MMIO_FINDRIFF );
	if( mmres == MMIOERR_CHUNKNOTFOUND )
	{
		DXTRACE_MSG( "mmioDescend()" );
		::mmioClose( m_hMMIO, 0 );
		return nRet;
	}
	// fmt 
	m_ckInfo.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );
	mmres = ::mmioDescend( m_hMMIO, &m_ckInfo, &m_ckRiff, MMIO_FINDCHUNK );
	if( mmres == MMIOERR_CHUNKNOTFOUND )
	{
		DXTRACE_MSG( "mmioDescend()" );
		::mmioClose( m_hMMIO, 0 );
		return nRet;
	}
	// WAVEFORMATEX\̂̓ǂݍ
	if( ::mmioRead( m_hMMIO, reinterpret_cast<HPSTR>( &wfex ), sizeof( WAVEFORMATEX ) ) != sizeof( WAVEFORMATEX ) )
	{
		DXTRACE_MSG( "mmioRead()" );
		::mmioClose( m_hMMIO, 0 );
		return nRet;
	}
	// `N̏I̎̈ʒuփV[N
	::mmioAscend( m_hMMIO, &m_ckInfo, 0 );

	WaveReset();

	// Qb̃obt@m
	m_dwBuffSize = ( DSEVENT_MAX - 1 ) * wfex.nAvgBytesPerSec;

	// CxgEIuWFNg̍쐬
	for( int i = 0; i < DSEVENT_MAX; i++ )
		m_hEvent[ i ] = ::CreateEvent( NULL, FALSE, FALSE, NULL );

	// Xg[~Op̃ZJ_Eobt@쐬
	// obt@\̂Ƃ͕ʂ̊Ǘɗp
	// DSBCAPS_LOCSOFTWAREɂ
	// http://corvette.blogzine.jp/blog/2005/11/notify_6c75.html
	::ZeroMemory( &m_DSDesc, sizeof( DSBUFFERDESC ) );
	m_DSDesc.dwSize			= sizeof( DSBUFFERDESC );
	m_DSDesc.dwFlags		= DSBCAPS_CTRLPOSITIONNOTIFY | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_LOCSOFTWARE | DSBCAPS_CTRLVOLUME;
	m_DSDesc.dwBufferBytes	= m_dwBuffSize;
	m_DSDesc.lpwfxFormat	= &wfex;

	// obt@
	LPDIRECTSOUNDBUFFER	lpBuffer;
	hr = m_lpSound->CreateSoundBuffer( &m_DSDesc, &lpBuffer, NULL );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "CreateSoundBuffer()" );
		goto CREATE_ERROR;
	}

	// IDirectSoundBuffer8C^[tFCX擾
	hr = lpBuffer->QueryInterface( IID_IDirectSoundBuffer8, reinterpret_cast<LPVOID*>( &m_lpBuffer ) );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "QueryInterface()" );
		goto INTERFACE_ERROR;
	}

	// IDirectSoundNotify8C^[tFCX擾
	hr = m_lpBuffer->QueryInterface( IID_IDirectSoundNotify8, reinterpret_cast<LPVOID*>( &m_lpNotify ) );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "QueryInterface()" );
		goto INTERFACE_ERROR;
	}

	// ʒmʒuݒ
	DSBPOSITIONNOTIFY pn[ DSEVENT_MAX ];
	for( int i = 0; i < DSEVENT_MAX - 1; i++ )
	{
		pn[ i ].dwOffset		= m_DSDesc.dwBufferBytes / ( DSEVENT_MAX - 1 ) * i;
		pn[ i ].hEventNotify	= m_hEvent[ i ];
	}
	pn[ DSEVENT_MAX - 1 ].dwOffset		= DSBPN_OFFSETSTOP;
	pn[ DSEVENT_MAX - 1 ].hEventNotify	= m_hEvent[ DSEVENT_MAX - 1 ];

	// ~ʒuݒ
	hr = m_lpNotify->SetNotificationPositions( DSEVENT_MAX, pn );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetNotificationPositions()" );
		goto NOTIFY_ERROR;
	}

	nRet = 1;
	m_bUsed = FALSE;

NOTIFY_ERROR:
INTERFACE_ERROR:

	_RELEASE( lpBuffer );

CREATE_ERROR:

	return nRet;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::RemoveWav( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Wave
 ******************************************************************************/
int CDLSndStream::RemoveWav( void )
{
	// 
	_RELEASE( m_lpNotify );
	if( m_lpBuffer != NULL )
	{
		m_lpBuffer->Stop();
		_RELEASE( m_lpBuffer );
	}
	// CxgEnh
	for( int i = 0; i < DSEVENT_MAX; i++ )
	{
		if( m_hEvent[ i ] != NULL )
		{
			::CloseHandle( m_hEvent[ i ] );
			m_hEvent[ i ] = NULL;
		}
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::Play( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Đ
 ******************************************************************************/
int CDLSndStream::Play( void )
{
	if( !m_bUsed )
	{
		// Xbh쐬
		unsigned int uiID;
		HANDLE hID = reinterpret_cast<HANDLE>( ::_beginthreadex( NULL, 0, &CDLSndStream::StreamThread, this, 0, &uiID ) );
		::CloseHandle( hID );
	}
	m_bUsed = TRUE;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::Stop( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			~
 ******************************************************************************/
int CDLSndStream::Stop( void )
{
	if( m_bUsed )
	{
		if( m_lpBuffer != NULL )
		{
			m_lpBuffer->Stop();
			m_bUsed = FALSE;
		}
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSndStream::SetVolume( const int& nVolume )
 *	@param[in]		nVolume						0:ŏ/10000:ő
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			{[ݒ
 ******************************************************************************/
int CDLSndStream::SetVolume( const int& nVolume )
{
	// ̎ł-5000ƕȂȂ
	m_nVolume = ( nVolume - 10000 ) / 2;
	if( m_nVolume >= DSBVOLUME_MAX ) m_nVolume = DSBVOLUME_MAX;
	if( m_nVolume <= DSBVOLUME_MIN / 2 ) m_nVolume = DSBVOLUME_MIN;

	return TRUE;
}

// -----------------------------------------------------------------------------
// o[֐|C^iIuWFNg폜j
int ( CDLSound::*CDLSound::StepDel[ EOBJECT_SOUNDEND - EOBJECT_SOUNDSTART ] )( const int& nNum ) =
{
	&CDLSound::DelBGM, &CDLSound::DelSE,
};
// o[֐|C^iIuWFNgsj
int ( CDLSound::*CDLSound::StepPlay[ EDSPLAY_MAX ] )( const int& nNum ) =
{
	NULL, NULL,
	&CDLSound::ExecPlay, &CDLSound::ExecLoop, &CDLSound::ExecStop,
	&CDLSound::ExecPause, &CDLSound::ExecFadeIn, &CDLSound::ExecFadeOut,
};

/*******************************************************************************
 *	@fn				BOOL CALLBACK CDLSound::DSEnumCallback( LPGUID lpGuid,
 *															LPCSTR lpcstrDescription,
 *															LPCSTR lpcstrModule,
 *															LPVOID lpContext )
 *	@param[in]		lpGuid						foCXGUID
 *	@param[in]		lpcstrDescription			foCX
 *	@param[in]		lpcstrModule				W[
 *	@param[in]		lpContext					nh
 *	@retval			int							TRUE=p/FALSE=~
 *	@brief			foCX̗񋓁Ao^
 ******************************************************************************/
BOOL CALLBACK CDLSound::DSEnumCallback( LPGUID lpGuid,
										LPCSTR lpcstrDescription,
										LPCSTR lpcstrModule,
										LPVOID lpContext )
{
	CDLSound *pSnd = static_cast<CDLSound*>( lpContext );

	// foCXo^
	const SDSDEVICE& v = SDSDEVICE( lpGuid, lpcstrDescription, lpcstrModule );
	pSnd->m_vDevice.push_back( v );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::CheckWave( const BYTE* byData )
 *	@param[in]		byData						f[^
 *	@retval			int							f[^̈ʒu
 *	@brief			Wave
 ******************************************************************************/
int CDLSound::CheckWave( const BYTE* byData )
{
	// RIFF
	if( *(DWORD*)( byData + 0 ) != mmioFOURCC( 'R', 'I', 'F', 'F' ) )
		return 0;
	// WAVE
	if( *(DWORD*)( byData + 8 ) != mmioFOURCC( 'W', 'A', 'V', 'E' ) )
		return 0;
	// data
	for( int i = 0; i < 128; i++ )
	{
		if( *(DWORD*)( byData + i ) == mmioFOURCC( 'd', 'a', 't', 'a' ) )
			return i;
	}
	return 0;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetPosition( const SDSPOS& SPos )
 *	@param[in]		SPos						ʒuW
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʒuWݒ
 ******************************************************************************/
int CDLSound::SetPosition( const SDSPOS& SPos )
{
	SDSLISTENER *pList = &m_SDSListener;
	// ʒu̐ݒ
	pList->m_SPos = SPos;

	HRESULT hr = pList->m_lpListener->SetPosition( pList->m_SPos.m_fX, pList->m_SPos.m_fY, pList->m_SPos.m_fZ, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetPosition()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetVelocity( const SDSPOS& SVel )
 *	@param[in]		SVel						xW
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			xWݒ
 ******************************************************************************/
int CDLSound::SetVelocity( const SDSPOS& SVel )
{
	SDSLISTENER *pList = &m_SDSListener;
	// x̐ݒ
	pList->m_SVel = SVel;

	HRESULT hr = pList->m_lpListener->SetVelocity( pList->m_SVel.m_fX, pList->m_SVel.m_fY, pList->m_SVel.m_fZ, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetVelocity()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetOrientation( const SDSPOS& SFront,
 *												  const SDSPOS& STop )
 *	@param[in]		SFront						OxNg
 *	@param[in]		STop						xNg
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			xNgݒ
 ******************************************************************************/
int CDLSound::SetOrientation( const SDSPOS& SFront,
							  const SDSPOS& STop )
{
	SDSLISTENER *pList = &m_SDSListener;
	// OxNg̐ݒ
	pList->m_SFront = SFront;
	// xNg̐ݒ
	pList->m_STop = STop;

	HRESULT hr = pList->m_lpListener->SetOrientation( pList->m_SFront.m_fX, pList->m_SFront.m_fY, pList->m_SFront.m_fZ,
													  pList->m_STop.m_fX, pList->m_STop.m_fY, pList->m_STop.m_fZ,
													  DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetOrientation()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetRolloff( const D3DVALUE& fRolloff )
 *	@param[in]		fRolloff					[EIt
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[EItݒ
 ******************************************************************************/
int CDLSound::SetRolloff( const D3DVALUE& fRolloff )
{
	SDSLISTENER *pList = &m_SDSListener;
	// [EItݒ
	pList->m_fRolloff = fRolloff;

	HRESULT hr = pList->m_lpListener->SetRolloffFactor( pList->m_fRolloff, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetRolloffFactor()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetDoppler( const D3DVALUE& fDoppler )
 *	@param[in]		fDoppler					hbv[W
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			hbv[Wݒ
 ******************************************************************************/
int CDLSound::SetDoppler( const D3DVALUE& fDoppler )
{
	SDSLISTENER *pList = &m_SDSListener;
	// hbv[Wݒ
	pList->m_fDoppler = fDoppler;

	HRESULT hr = pList->m_lpListener->SetDopplerFactor( pList->m_fDoppler, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetDopplerFactor()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetPosition( SDSBUFFER& pBuf,
 *											   const SDSPOS& SPos )
 *	@param[in]		pBuf						obt@
 *	@param[in]		SPos						ʒuW
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʒuWݒ
 ******************************************************************************/
int CDLSound::SetPosition( SDSBUFFER& pBuf,
						   const SDSPOS& SPos )
{
	// ʒu̐ݒ
	pBuf.m_SPos = SPos;

	// gp
	if( pBuf.m_lp3DBuffer == NULL ) return FALSE;

	HRESULT hr = pBuf.m_lp3DBuffer->SetPosition( pBuf.m_SPos.m_fX, pBuf.m_SPos.m_fY, pBuf.m_SPos.m_fZ, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetPosition()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::SetVelocity( SDSBUFFER& pBuf,
 *											   const SDSPOS& SVel )
 *	@param[in]		pBuf						obt@
 *	@param[in]		SVel						xW
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			xWݒ
 ******************************************************************************/
int CDLSound::SetVelocity( SDSBUFFER& pBuf,
						   const SDSPOS& SVel )
{
	// x̐ݒ
	pBuf.m_SVel = SVel;

	// gp
	if( pBuf.m_lp3DBuffer == NULL ) return FALSE;

	HRESULT hr = pBuf.m_lp3DBuffer->SetVelocity( pBuf.m_SVel.m_fX, pBuf.m_SVel.m_fY, pBuf.m_SVel.m_fZ, DS3D_IMMEDIATE );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetVelocity()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::DelBGM( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			BGM폜
 ******************************************************************************/
int CDLSound::DelBGM( const int& nNum )
{
	SDSOBJECT &vObj = m_vDSObj[ nNum ];

	// 
	SDSOBJECT n;
	vObj = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::DelBGM( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			SE폜
 ******************************************************************************/
int CDLSound::DelSE( const int& nNum )
{
	SDSOBJECT &vObj = m_vDSObj[ nNum ];

	// 
	SDSOBJECT n;
	vObj = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecPlay( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Đ
 ******************************************************************************/
int CDLSound::ExecPlay( const int& nNum )
{
	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	vObj.m_ePlay = EDSPLAY_WAIT;
	// obt@݂Ȃ
	if( !vBuf.m_lpBuffer ) return FALSE;

	// Wݒ
	SetPosition( vBuf, vObj.m_SPos );
	SetVelocity( vBuf, vObj.m_SVel );

	// obt@Đ
	hr = vBuf.m_lpBuffer->Play( 0, vObj.m_nPrio, 0 );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecLoop( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[v
 ******************************************************************************/
int CDLSound::ExecLoop( const int& nNum )
{
	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	vObj.m_ePlay = EDSPLAY_WAIT;
	// obt@݂Ȃ
	if( !vBuf.m_lpBuffer ) return FALSE;

	// Wݒ
	SetPosition( vBuf, vObj.m_SPos );
	SetVelocity( vBuf, vObj.m_SVel );

	// obt@[vĐ
	hr = vBuf.m_lpBuffer->Play( 0, vObj.m_nPrio, DSBPLAY_LOOPING );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecStop( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			~
 ******************************************************************************/
int CDLSound::ExecStop( const int& nNum )
{
	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	vObj.m_ePlay = EDSPLAY_WAIT;
	// obt@݂Ȃ
	if( !vBuf.m_lpBuffer ) return FALSE;

	// obt@~
	hr = vBuf.m_lpBuffer->Stop();

	// obt@̈ʒuŏɖ߂
	hr = vBuf.m_lpBuffer->SetCurrentPosition( 0 );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecPause( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ꎞ~
 ******************************************************************************/
int CDLSound::ExecPause( const int& nNum )
{
	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	vObj.m_ePlay = EDSPLAY_WAIT;
	// obt@݂Ȃ
	if( !vBuf.m_lpBuffer ) return FALSE;

	// obt@~
	hr = vBuf.m_lpBuffer->Stop();

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecFadeIn( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			tF[hC
 ******************************************************************************/
int CDLSound::ExecFadeIn( const int& nNum )
{
	_ASSERT( 0 && "ExecFadeIn() " );

	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::ExecFadeOut( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			tF[hAEg
 ******************************************************************************/
int CDLSound::ExecFadeOut( const int& nNum )
{
	_ASSERT( 0 && "ExecFadeOut() " );

	HRESULT hr = DS_OK;
	SDSOBJECT &vObj = m_vDSObj[ nNum ];
	SDSBUFFER &vBuf = m_vDSBuf[ vObj.m_nMatNum ];

	return TRUE;
}

/*******************************************************************************
 *	@fn				CDLSound::CDLSound( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLSound::CDLSound( void )
	: m_lpSound( NULL )
	, m_DSDesc()
	, m_lpPrimary( NULL )
	, m_SDSListener()

	, m_hWnd()
	, m_SSound()
	, m_vDevice()
	, m_DSCaps()
	, m_dwSpeaker( 0 )
	, m_b3DSound( FALSE )

	, m_CStream0()
	, m_CStream1()
	, m_CStream2()
	, m_CStream3()
{
	m_pStream[ 0 ] = &m_CStream0;
	m_pStream[ 1 ] = &m_CStream1;
	m_pStream[ 2 ] = &m_CStream2;
	m_pStream[ 3 ] = &m_CStream3;
	// e̐ݒAz񏉊
	m_vDSBuf.reserve( BUFFER_MAX );
	m_vDSBuf.clear();
	m_vDSObj.reserve( OBJECT_MAX );
	m_vDSObj.clear();
}

/*******************************************************************************
 *	@fn				CDLSound::~CDLSound( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLSound::~CDLSound( void )
{
	End();
}

/*******************************************************************************
 *	@fn				void CDLSound::SetSound( const SDLSOUND& SSound )
 *	@param[in]		SSound						\
 *	@retval			none						Ȃ
 *	@brief			ZbgAbv\̐ݒ
 ******************************************************************************/
void CDLSound::SetSound( const SDLSOUND& SSound )
{
	m_SSound = SSound;
}

/*******************************************************************************
 *	@fn				int CDLSound::Init( const HWND& hWnd )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLSound::Init( const HWND& hWnd )
{
	return Init( hWnd, m_SSound.m_b3DSound );
}

/*******************************************************************************
 *	@fn				int CDLSound::Init( const HWND& hWnd,
 *										const BOOL& b3DSound )
 *	@param[in]		hWnd						EChEnh
 *	@param[in]		b3DSound					RcTEhtO
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLSound::Init( const HWND& hWnd,
				    const BOOL& b3DSound )
{
	m_hWnd = hWnd;
	HRESULT hr = DS_OK;
	m_b3DSound = b3DSound;

	// TEhEfoCX̗
	hr = ::DirectSoundEnumerate( static_cast<LPDSENUMCALLBACK>( DSEnumCallback ),
								 static_cast<VOID*>( this ) );

	// IDirectSound8 C^[tFCX̎擾
	hr = ::DirectSoundCreate8( NULL, &m_lpSound, NULL );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "DirectSoundCreate8()", hr );
		return FALSE;
	}

	// x̐ݒ
	hr = m_lpSound->SetCooperativeLevel( m_hWnd, DSSCL_PRIORITY );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "SetCooperativeLevel()", hr );
		return FALSE;
	}

	// foCX̐\
	m_DSCaps.dwSize = sizeof( DSCAPS );
	hr = m_lpSound->GetCaps( &m_DSCaps );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "GetCaps()" );
		return FALSE;
	}

	// Xs[J[̒
	hr = m_lpSound->GetSpeakerConfig( &m_dwSpeaker );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "GetSpeakerConfig()" );
		return FALSE;
	}
	DSSPEAKER_CONFIG( m_dwSpeaker );
	DSSPEAKER_GEOMETRY( m_dwSpeaker );

	// DSBUFFERDESC ̐ݒ
	::ZeroMemory( &m_DSDesc, sizeof( DSBUFFERDESC ) );
	m_DSDesc.dwSize			= sizeof( DSBUFFERDESC );
	m_DSDesc.dwFlags		= DSBCAPS_PRIMARYBUFFER;
	m_DSDesc.dwBufferBytes	= 0;
	m_DSDesc.lpwfxFormat	= NULL;
	if( m_b3DSound ) m_DSDesc.dwFlags |= DSBCAPS_CTRL3D;

	// vC}Eobt@̍쐬
	hr = m_lpSound->CreateSoundBuffer( &m_DSDesc, &m_lpPrimary, NULL );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "CreateSoundBuffer()", hr );
		return FALSE;
	}

	// vC}Eobt@̃tH[}bgݒ
	// bcƓɐݒ
	WAVEFORMATEX	wfex;
	::ZeroMemory( &wfex, sizeof( WAVEFORMATEX ) );
	wfex.nChannels			= m_b3DSound ? 1 : 2;
	wfex.wFormatTag			= WAVE_FORMAT_PCM;
	wfex.wBitsPerSample		= 16;
	wfex.nBlockAlign		= wfex.nChannels * wfex.wBitsPerSample / 8;
	wfex.nSamplesPerSec		= 44100;
	wfex.nAvgBytesPerSec	= wfex.nSamplesPerSec * wfex.nBlockAlign;
	wfex.cbSize				= 0;
	hr = m_lpPrimary->SetFormat( &wfex );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "SetFormat()" );
		return FALSE;
	}

	if( m_b3DSound )
	{
		// Xi[擾
		hr = m_lpPrimary->QueryInterface( IID_IDirectSound3DListener8, reinterpret_cast<LPVOID*>( &m_SDSListener.m_lpListener ) );
		if( FAILED( hr ) )
		{
			DXTRACE_ERR( "QueryInterface()", hr );
			return FALSE;
		}
		// p[^
		SetPosition( SDSPOS( 0.0f, 0.0f, 0.0f ) );
		SetVelocity( SDSPOS( 0.0f, 0.0f, 0.0f ) );
		SetOrientation( SDSPOS( 0.0f, 0.0f, 1.0f ), SDSPOS( 0.0f, 1.0f, 0.0f ) );
		SetRolloff( 1.0f );
		SetDoppler( 0.0f );
	}

	// Xg[̏
	for( int i = 0; i < STREAM_MAX; i++ )
		m_pStream[ i ]->Init( m_lpSound );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::End( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			I
 ******************************************************************************/
int CDLSound::End( void )
{
	// Xi[̉
	_RELEASE( m_SDSListener.m_lpListener )
	// vC}Eobt@̉
	if( m_lpPrimary != NULL )
	{
		m_lpPrimary->Stop();
		m_lpPrimary->Release();
		m_lpPrimary = NULL;
	}
	// IDirectSound8 C^[tFCX̉
	_RELEASE( m_lpSound );
	// TEhEfoCX̃NA
	m_vDevice.clear();

	return TRUE;
}

/*******************************************************************************
 *	@fn				SDSBUFFER* CDLSound::GetBuffer( const int& nNum )
 *	@param[in]		int							obt@ԍ
 *	@retval			SDSOBJECT*					obt@
 *	@brief			obt@擾
 ******************************************************************************/
SDSBUFFER* CDLSound::GetBuffer( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vDSBuf.size() ) && "GetBuffer()" );
	return &m_vDSBuf[ nNum ];
}

/*******************************************************************************
 *	@fn				SDSOBJECT* CDLSound::GetObject( const int& nNum )
 *	@param[in]		int							IuWFNgԍ
 *	@retval			SDSOBJECT*					IuWFNg
 *	@brief			IuWFNg擾
 ******************************************************************************/
SDSOBJECT* CDLSound::GetObject( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vDSObj.size() ) && "GetObject()" );
	return &m_vDSObj[ nNum ];
}

/*******************************************************************************
 *	@fn				int CDLSound::LoadWav( const LPSTR& szName )
 *	@param[in]		szName						t@C
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			Waveǂݍ
 ******************************************************************************/
int CDLSound::LoadWav( const LPSTR& szName )
{
	int nRet = -1;
	HRESULT hr = DS_OK;
	SDSBUFFER SBuf;

	SBuf.m_szName = szName;

	// obt@̐ݒ
	HANDLE fh = ::CreateFile(
		SBuf.m_szName,
		GENERIC_READ,
		0,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL );
	if( fh == INVALID_HANDLE_VALUE )
	{
		DXTRACE_MSG( "CreateFile()" );
		return nRet;
	}
	// Wavet@C̃TCY擾
	int nFileSize = ::GetFileSize( fh, NULL );
	::SetFilePointer( fh, 0, 0, FILE_BEGIN );
	// m
	BYTE* byData = new BYTE[ nFileSize ];
	// t@C̓ǂݍ
	DWORD dwReadSize;
	::ReadFile( fh, byData, nFileSize, &dwReadSize, NULL );
	// t@C
	::CloseHandle( fh );

	// f[^
	int nBufNum = CheckWave( byData );
	if( nBufNum == 0 )
	{
		DXTRACE_MSG( "CheckWave()" );
		goto LOAD_ERROR;
	}

	// dǂݍ݂̖h~
	if( SBuf.m_lpBuffer != NULL )
	{
		DXTRACE_MSG( "double booking" );
		goto LOAD_ERROR;
	}

	// ZJ_Eobt@쐬
	::ZeroMemory( &SBuf.m_DSDesc, sizeof( DSBUFFERDESC ) );
	SBuf.m_DSDesc.dwSize			= sizeof( DSBUFFERDESC );
	SBuf.m_DSDesc.dwFlags			= DSBCAPS_STATIC | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_LOCDEFER;
	SBuf.m_DSDesc.dwBufferBytes		= *(DWORD *)( byData + nBufNum + 4 );				// f[^oCg
	SBuf.m_DSDesc.lpwfxFormat		= reinterpret_cast<LPWAVEFORMATEX>( byData + 20 );	// tH[}bg
	// iXeIł͂Rcobt@͍쐬łȂj
	if( m_b3DSound && ( SBuf.m_DSDesc.lpwfxFormat->nChannels != 2 ) )
		SBuf.m_DSDesc.dwFlags |= DSBCAPS_CTRL3D;

	// obt@
	LPDIRECTSOUNDBUFFER	lpBuffer;
	hr = m_lpSound->CreateSoundBuffer( &SBuf.m_DSDesc, &lpBuffer, NULL );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "CreateSoundBuffer()" );
		goto CREATE_ERROR;
	}

	// IDirectSoundBuffer8C^[tFCX擾
	hr = lpBuffer->QueryInterface( IID_IDirectSoundBuffer8, reinterpret_cast<LPVOID*>( &SBuf.m_lpBuffer ) );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "QueryInterface()" );
		goto INTERFACE_ERROR;
	}

	// iXeIł͂Rcobt@͍쐬łȂj
	if( m_b3DSound && ( SBuf.m_DSDesc.lpwfxFormat->nChannels != 2 ) )
	{
		// Rcobt@쐬
		hr = SBuf.m_lpBuffer->QueryInterface( IID_IDirectSound3DBuffer, reinterpret_cast<LPVOID*>( &SBuf.m_lp3DBuffer ) );
		if( FAILED( hr ) )
		{
			DXTRACE_MSG( "QueryInterface()" );
			goto INTERFACE_ERROR;
		}
		// Wݒ
		SetPosition( SBuf, SDSPOS( 0.0f, 0.0f, 0.0f ) );
		SetVelocity( SBuf, SDSPOS( 0.0f, 0.0f, 0.0f ) );
	}

	LPVOID	lpBuff1, lpBuff2;
	DWORD	dwSize1, dwSize2;
	// obt@ւ̏
	hr = SBuf.m_lpBuffer->Lock( 0, SBuf.m_DSDesc.dwBufferBytes,
								&lpBuff1, &dwSize1, &lpBuff2, &dwSize2, 0 );
	if( hr == DSERR_BUFFERLOST )
	{
		// xĂ݂
		SBuf.m_lpBuffer->Restore();
		hr = SBuf.m_lpBuffer->Lock( 0, SBuf.m_DSDesc.dwBufferBytes,
									&lpBuff1, &dwSize1, &lpBuff2, &dwSize2, 0 );
	}
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "Lock()" );
		goto LOCK_ERROR;
	}

	// f[^]
	::CopyMemory( lpBuff1, byData + 8, dwSize1 );
	if( dwSize2 > 0 )
		::CopyMemory( lpBuff2, byData + 8 + dwSize1, dwSize2 );

	// bN
	SBuf.m_lpBuffer->Unlock( lpBuff1, dwSize1, lpBuff2, dwSize2 );

	// Waveǉ
	m_vDSBuf.push_back( SBuf );
	nRet = ( m_vDSBuf.size() - 1 );

LOCK_ERROR:
INTERFACE_ERROR:

	_RELEASE( lpBuffer );

CREATE_ERROR:
LOAD_ERROR:
	// 
	delete[] byData;

	return nRet;
}

/*******************************************************************************
 *	@fn				int CDLSound::LoadWavStream( const int& nNum,
 *												 const LPSTR& szName )
 *	@param[in]		nNum						obt@ԍ
 *	@param[in]		szName						t@C
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			Waveǂݍ݁iXg[~Oj
 ******************************************************************************/
int CDLSound::LoadWavStream( const int& nNum,
							 const LPSTR& szName )
{
	_ASSERT( nNum < STREAM_MAX && "LoadWavStream()" );

	int nRet = -1;
	HRESULT hr = DS_OK;
	CDLSndStream *pStream = m_pStream[ nNum ];

	if( pStream->LoadWav( szName ) )
		nRet = nNum;

	return nRet;
}

/*******************************************************************************
 *	@fn				int CDLSound::RemoveWav( const int& nNum )
 *	@param[in]		nNum						obt@ԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Wave
 ******************************************************************************/
int CDLSound::RemoveWav( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vDSBuf.size() ) && "RemoveWav()" );

	SDSBUFFER &vBuf = m_vDSBuf[ nNum ];

	// 
	vBuf.m_szName = "";
	if( vBuf.m_lpBuffer != NULL )
	{
		vBuf.m_lpBuffer->Stop();
		_RELEASE( vBuf.m_lp3DBuffer );
		_RELEASE( vBuf.m_lpBuffer );
	}

	// 
	SDSBUFFER n;
	vBuf = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::RemoveWavStream( const int& nNum )
 *	@param[in]		nNum						obt@ԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			WaveiXg[~Oj
 ******************************************************************************/
int CDLSound::RemoveWavStream( const int& nNum )
{
	_ASSERT( nNum < STREAM_MAX && "RemoveWavStream()" );

	CDLSndStream *pStream = m_pStream[ nNum ];

	if( pStream->RemoveWav() )
		return TRUE;

	return FALSE;
}

/*******************************************************************************
 *	@fn				int CDLSound::RemoveALL( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			fޑS
 ******************************************************************************/
int CDLSound::RemoveALL( void )
{
	int nMax;
	// fމ
	nMax = static_cast<int>( m_vDSBuf.size() );
	for( int i = 0; i < nMax; i++ )
		RemoveWav( i );
	m_vDSBuf.clear();
	for( int i = 0; i < STREAM_MAX; i++ )
		RemoveWavStream( i );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::AddBGM( const int& nPrio,
 *										  const int& nMatNum,
 *										  const EDSPLAY& ePlay,
 *										  const SDSPOS& SPos,
 *										  const SDSPOS& SVel )
 *	@param[in]		nPrio						vCIeB
 *	@param[in]		nMatNum						obt@ԍ
 *	@param[in]		ePlay						Đ
 *	@param[in]		SPos						ʒuW
 *	@param[in]		SVel						xW
 *	@retval			int							IuWFNgԍ
 *	@brief			BGMǉ
 ******************************************************************************/
int CDLSound::AddBGM( const int& nPrio,
					  const int& nMatNum,
					  const EDSPLAY& ePlay,
					  const SDSPOS& SPos,
					  const SDSPOS& SVel )
{
	SDSOBJECT SObj;

	// {o^
	SObj.m_bUsed = TRUE;
	SObj.m_eObj = EOBJECT_BGM;
	SObj.m_nPrio = nPrio;
	// fޔԍo^
	SObj.m_nMatNum = nMatNum;
	// Đo^
	SObj.m_ePlay = ePlay;

	// Wݒ
	SObj.m_SPos = SPos;
	SObj.m_SVel = SVel;

	// IuWFNgǉ
	m_vDSObj.push_back( SObj );
	return ( m_vDSObj.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLSound::AddSE( const int& nPrio,
 *										 const int& nMatNum,
 *										 const EDSPLAY& ePlay,
 *										 const SDSPOS& SPos,
 *										 const SDSPOS& SVel )
 *	@param[in]		nPrio						vCIeB
 *	@param[in]		nMatNum						obt@ԍ
 *	@param[in]		ePlay						Đ
 *	@param[in]		SPos						ʒuW
 *	@param[in]		SVel						xW
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			SEǉ
 ******************************************************************************/
int CDLSound::AddSE( const int& nPrio,
					 const int& nMatNum,
					 const EDSPLAY& ePlay,
					 const SDSPOS& SPos,
					 const SDSPOS& SVel )
{
	SDSOBJECT SObj;

	// {o^
	SObj.m_bUsed = TRUE;
	SObj.m_eObj = EOBJECT_SE;
	SObj.m_nPrio = nPrio;
	// fޔԍo^
	SObj.m_nMatNum = nMatNum;
	// Đo^
	SObj.m_ePlay = ePlay;

	// Wݒ
	SObj.m_SPos = SPos;
	SObj.m_SVel = SVel;

	// IuWFNgǉ
	m_vDSObj.push_back( SObj );
	return ( m_vDSObj.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLSound::Del( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNg폜
 ******************************************************************************/
int CDLSound::Del( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vDSObj.size() ) && "Del()" );

	SDSOBJECT &vObj = m_vDSObj[ nNum ];

	// gp
	if( vObj.m_nMatNum == -1 ) return FALSE;

	// IuWFNg폜
	if( !( this->*StepDel[ vObj.m_eObj - EOBJECT_SOUNDSTART ] )( nNum ) )
		return FALSE;
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::DelALL( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNgS폜
 ******************************************************************************/
int CDLSound::DelALL( void )
{
	int nMax;
	// IuWFNg폜
	nMax = static_cast<int>( m_vDSObj.size() );
	for( int i = 0; i < nMax; i++ )
		Del( i );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::Play( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNgs
 ******************************************************************************/
int CDLSound::Play( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vDSObj.size() ) && "Play()" );

	SDSOBJECT &vObj = m_vDSObj[ nNum ];

	// gp
	if( vObj.m_nMatNum == -1 ) return FALSE;
	// s
	if( vObj.m_ePlay < EDSPLAY_PLAY ) return FALSE;

	// IuWFNgs
	if( !( this->*StepPlay[ vObj.m_ePlay ] )( nNum ) )
		return FALSE;
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::PlayStream( const int& nNum,
 *											  const int& nVolume )
 *	@param[in]		nNum						Xg[~Oԍ
 *	@param[in]		nVolume						{[(0:ŏ/10000:ő)
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Xg[~Os
 ******************************************************************************/
int CDLSound::PlayStream( const int& nNum,
						  const int& nVolume )
{
	_ASSERT( nNum < STREAM_MAX && "PlayStream()" );

	CDLSndStream *pStream = m_pStream[ nNum ];

	pStream->SetVolume( nVolume );
	pStream->Play();

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLSound::StopStream( const int& nNum )
 *	@param[in]		nNum						Xg[~Oԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Xg[~Os
 ******************************************************************************/
int CDLSound::StopStream( const int& nNum )
{
	_ASSERT( nNum < STREAM_MAX && "PlayStream()" );

	CDLSndStream *pStream = m_pStream[ nNum ];

	pStream->Stop();

	return TRUE;
}

}	// namespace	DL
