/*******************************************************************************
 *	@file			DLShow.h
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			24-May-2011(Tue)
 ******************************************************************************/

#ifndef	__DLSHOW_INCLUDE__
#define	__DLSHOW_INCLUDE__

// vvZbT---------------------------------------------------------------
#include "DL.h"
#include "DLGraph.h"
#include "smartptr.h"

#include "streams.h"
#ifdef	_DEBUG
	#pragma comment ( lib, "strmbasd.lib" )
#else	// _DEBUG
	#pragma comment ( lib, "strmbase.lib" )
#endif	// _DEBUG

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// 萔`---------------------------------------------------------------------
#pragma once

#define FAIL_RET( x ) do{ if( FAILED( hr = ( x ) ) ) return hr; } while( 0 )

struct __declspec( uuid( "{6E96646B-9428-47fd-9B9E-A1EF2A1289EA}" ) ) CLSID_DLMovie;

class CDLMovie;

// 񋓌^`-------------------------------------------------------------------

// \̒`-------------------------------------------------------------------
/*******************************************************************************
 *	@struct		SDSMOVIE		DLShow.h			"DLShow.h"
 *	@brief		[r[Ǘ\
 ******************************************************************************/
struct SDSMOVIE
{
	SDSMOVIE()
		: m_pD3DTex( NULL )

		, m_szName()
		, m_bLoop( FALSE )
		, m_dRate( 0.0f )
		, m_dLen( 0.0f )
		, m_lBalance( 0 )
		, m_lVolume( -5000 )
	{
		m_pBuilder = NULL;
		m_pFilter = NULL;

		m_pFSrcFilter = NULL;
		m_pFSrcPinOut = NULL;

		m_pControl = NULL;
		m_pPosition = NULL;
		m_pEvent = NULL;

		m_pAudio = NULL;

		m_CMovie = NULL;
	}

	// C^[tFCX
	SmartPtr<IGraphBuilder>		m_pBuilder;
	SmartPtr<IBaseFilter>		m_pFilter;

	SmartPtr<IBaseFilter>		m_pFSrcFilter;
	SmartPtr<IPin>				m_pFSrcPinOut;

	SmartPtr<IMediaControl>		m_pControl;
	SmartPtr<IMediaPosition>	m_pPosition;
	SmartPtr<IMediaEvent>		m_pEvent;

	SmartPtr<IBasicAudio>		m_pAudio;

	// IuWFNg
	SD3DTEXTURE*				m_pD3DTex;
	CDLMovie*					m_CMovie;										//!< [r[NX

	// ϐ
	LPWSTR						m_szName;										//!< t@C
	BOOL						m_bLoop;										//!< [vĐ
	double						m_dRate;										//!< Đ[g
	double						m_dLen;											//!< ̒
	long						m_lBalance;										//!< ̍EoX(-100 <-> 100)
	long						m_lVolume;										//!< ̃{[(0 <-> 100)
};

// NX-----------------------------------------------------------------------
/*******************************************************************************
 *	@class		CDLShow			DLShow.h			"DLShow.h"
 *	@brief		CDLMovieNX
 ******************************************************************************/
class CDLMovie : public CBaseVideoRenderer
{
// 萔`---------------------------------------------------------------------
private:
	static const int TEX_MAX		= 2;										//!< eNX`
protected:
public:

// o֐-------------------------------------------------------------------
private:
protected:
public:
	CDLMovie( LPUNKNOWN pUnk, HRESULT* phr,
			  const LPDIRECT3DDEVICE9& lpD3DDev );
	~CDLMovie( void );

	HRESULT CheckMediaType( const CMediaType* pmt );
	HRESULT SetMediaType( const CMediaType* pmt );
	HRESULT DoRenderSample( IMediaSample* pMediaSample );

	LPDIRECT3DTEXTURE9& GetTexture( void );
	D3DSURFACE_DESC& GetDesc( void ){ return m_D3DDesc; }

	int ReleaseTex( void );

// oϐ-------------------------------------------------------------------
private:
	BOOL m_bUseDynamicTextures;
	LONG m_lVidWidth;
	LONG m_lVidHeight;
	LONG m_lVidPitch;

	LPDIRECT3DDEVICE9		m_lpD3DDev;											//!< Direct3D foCX
	LPDIRECT3DTEXTURE9		m_lpD3DTex[ TEX_MAX ];								//!< eNX`
	D3DSURFACE_DESC			m_D3DDesc;											//!< \[X
	int						m_nNow;												//!< \ɎgpeNX`
	int						m_nNew;												//!< `悷eNX`

protected:
public:

};

/*******************************************************************************
 *	@class		CDLShow			DLShow.h			"DLShow.h"
 *	@brief		CDLShowNX
 ******************************************************************************/
class CDLShow
{
// 萔`---------------------------------------------------------------------
private:
protected:
public:
	static const int MOVIE_MAX		= 4;										//!< 摍

// o֐-------------------------------------------------------------------
private:
protected:
public:
	CDLShow( void );
	~CDLShow( void );

	int Init( const HWND& hWnd,
			  const LPDIRECT3DDEVICE9& lpD3DDev );								//!< 
	int End( void );															//!< I
	int Release( const int& nNum );												//!< 

	int Update( void );															//!< XV

	// ڊ
	SDSMOVIE* GetMovie( const int& nNum );										//!< [r[擾

	// fޓǂݍ
	int LoadMov( const LPWSTR& szName,
				 const int& nNum,
				 SD3DTEXTURE* pD3DTex );
	int ReloadMov( SD3DTEXTURE* pD3DTex );

	// fމ
	int RemoveMov( const int& nNum );
	int RemoveALL( void );

	// IuWFNgs
	int PlayMovie( const int& nNum,
				   const double& refLen = 0.0f,
				   const int& nVolume = 50,
				   const BOOL& bLoop = FALSE );
	int StopMovie( const int& nNum );

	// IuWFNg
	int SetPosition( const int& nNum,
					 const double& refLen );
	int SetVolume( const int& nNum,
				   const int& nVolume );

// oϐ-------------------------------------------------------------------
private:
	HWND					m_hWnd;												//!< EChEnh
	LPDIRECT3DDEVICE9		m_lpD3DDev;

	// IuWFNg
	SDSMOVIE				m_DSMovie0;
	SDSMOVIE				m_DSMovie1;
	SDSMOVIE				m_DSMovie2;
	SDSMOVIE				m_DSMovie3;
	SDSMOVIE*				m_pMovie[ MOVIE_MAX ];

protected:
public:

};

// OO[oϐ-----------------------------------------------------------

// O֐vg^Cv錾-----------------------------------------------------

}	// namespace	DL

#ifdef __cplusplus
}
#endif

#endif	// __DLSHOW_INCLUDE__
