/*******************************************************************************
 *	@file			DLShow.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			24-May-2011(Tue)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DLShow.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				CDLMovie::CDLMovie( LPUNKNOWN pUnk,
 *										HRESULT* phr,
 *										const LPDIRECT3DDEVICE9& lpD3DDev )
 *	@param[in]		pUnk						
 *	@param[in]		phr							
 *	@param[in]		lpD3DDev						
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLMovie::CDLMovie( LPUNKNOWN pUnk, HRESULT* phr, const LPDIRECT3DDEVICE9& lpD3DDev )
	: CBaseVideoRenderer( __uuidof( CLSID_DLMovie )
	, NAME( "Texture Renderer" ), pUnk, phr )
	, m_bUseDynamicTextures( FALSE )
	, m_lVidWidth( 0 )
	, m_lVidHeight( 0 )
	, m_lVidPitch( 0 )

	, m_lpD3DDev( lpD3DDev )
	, m_D3DDesc()
	, m_nNow( 0 )
	, m_nNew( -1 )
{
	m_lpD3DTex[ 0 ] = NULL;
	m_lpD3DTex[ 1 ] = NULL;
	
	ASSERT( phr );
	if( phr ) *phr = S_OK;
}

/*******************************************************************************
 *	@fn				CDLMovie::~CDLMovie( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLMovie::~CDLMovie( void )
{
	ReleaseTex();
}

/*******************************************************************************
 *	@fn				HRESULT CDLMovie::CheckMediaType( const CMediaType* pmt )
 *	@param[in]		pmt							
 *	@retval			HRESULT						S_OK/E_FAIL/E_INVALIDARG
 *	@brief			fBA^Cv̌
 ******************************************************************************/
//-----------------------------------------------------------------------------
// CheckMediaType: This method forces the graph to give us an R8G8B8 video
// type, making our copy to texture memory trivial.
//-----------------------------------------------------------------------------
HRESULT CDLMovie::CheckMediaType( const CMediaType* pmt )
{
	HRESULT hr = E_FAIL;
	VIDEOINFO *pvi = 0;

	CheckPointer( pmt, E_POINTER );

	// Reject the connection if this is not a video type
	if( *pmt->FormatType() != FORMAT_VideoInfo )
		return E_INVALIDARG;

	// Only accept RGB24 video
	pvi = reinterpret_cast<VIDEOINFO *>( pmt->Format() );

	if( IsEqualGUID( *pmt->Type(), MEDIATYPE_Video )
	&&  IsEqualGUID( *pmt->Subtype(), MEDIASUBTYPE_RGB24 ) )
		hr = S_OK;

	return hr;
}

/*******************************************************************************
 *	@fn				HRESULT CDLMovie::SetMediaType( const CMediaType* pmt )
 *	@param[in]		pmt							
 *	@retval			HRESULT						S_OK/E_FAIL/E_INVALIDARG
 *	@brief			fBA^Cv̐ݒ
 ******************************************************************************/
//-----------------------------------------------------------------------------
// SetMediaType: Graph connection has been made.
//-----------------------------------------------------------------------------
HRESULT CDLMovie::SetMediaType( const CMediaType* pmt )
{
	HRESULT hr;

	// VKǂݍݎ̏
	// ʃTCYύXƂ
	m_nNow = -1;
	m_nNew = -1;

	UINT uintWidth = 2;
	UINT uintHeight = 2;

	// Retrive the size of this media type
	D3DCAPS9 caps;
	VIDEOINFO *pviBmp;									// Bitmap info header
	pviBmp = reinterpret_cast<VIDEOINFO *>( pmt->Format() );

	m_lVidWidth  = pviBmp->bmiHeader.biWidth;
	m_lVidHeight = abs(pviBmp->bmiHeader.biHeight);
	m_lVidPitch  = ( m_lVidWidth * 3 + 3 ) & ~( 3 );	// We are forcing RGB24
	
	// here let's check if we can use dynamic textures
	ZeroMemory( &caps, sizeof( D3DCAPS9 ) );
	hr = m_lpD3DDev->GetDeviceCaps( &caps );
	if( caps.Caps2 & D3DCAPS2_DYNAMICTEXTURES )
		m_bUseDynamicTextures = TRUE;

	if( caps.TextureCaps & D3DPTEXTURECAPS_POW2 )
	{
		while( static_cast<LONG>( uintWidth ) < m_lVidWidth )
			uintWidth = uintWidth << 1;
		while( static_cast<LONG>( uintHeight ) < m_lVidHeight )
			uintHeight = uintHeight << 1;
	}else
	{
		uintWidth = m_lVidWidth;
		uintHeight = m_lVidHeight;
	}

	// eNX`Q쐬
	for( int i = 0; i < TEX_MAX; i++ )
	{
		_RELEASE( m_lpD3DTex[ i ] );
		// Create the texture that maps to this media type
		hr = E_UNEXPECTED;
		if( m_bUseDynamicTextures )
		{
			hr = m_lpD3DDev->CreateTexture( m_lVidWidth, m_lVidHeight, 1, D3DUSAGE_DYNAMIC,
											D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
											&m_lpD3DTex[ i ], NULL );
			if( FAILED( hr ) )
				m_bUseDynamicTextures = FALSE;
		}
		if( FALSE == m_bUseDynamicTextures )
		{
			hr = m_lpD3DDev->CreateTexture( m_lVidWidth, m_lVidHeight, 1, 0,
											D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
											&m_lpD3DTex[ i ], NULL );
		}
		if( FAILED( hr ) )
			return hr;
	}

	// CreateTexture can silently change the parameters on us
	ZeroMemory( &m_D3DDesc, sizeof( D3DSURFACE_DESC ) );
	if( FAILED( hr = m_lpD3DTex[ 0 ]->GetLevelDesc( 0, &m_D3DDesc ) ) )
		return hr;

	SmartPtr<IDirect3DSurface9> pSurf;

	if( SUCCEEDED( hr = m_lpD3DTex[ 0 ]->GetSurfaceLevel( 0, &pSurf ) ) )
		pSurf->GetDesc( &m_D3DDesc );

	// Save format info
	if( m_D3DDesc.Format != D3DFMT_A8R8G8B8 )
		return VFW_E_TYPE_NOT_ACCEPTED;

	return S_OK;
}

/*******************************************************************************
 *	@fn				HRESULT CDLMovie::DoRenderSample( IMediaSample* pSample )
 *	@param[in]		pSample							
 *	@retval			HRESULT						S_OK/E_FAIL/E_INVALIDARG
 *	@brief			eNX`[̃Rs[
 ******************************************************************************/
//-----------------------------------------------------------------------------
// DoRenderSample: A sample has been delivered. Copy it to the texture.
//-----------------------------------------------------------------------------
HRESULT CDLMovie::DoRenderSample( IMediaSample* pSample )
{
	BYTE *pBmpBuffer, *pTxtBuffer;							// Bitmap buffer, texture buffer
	LONG lTxtPitch;											// Pitch of bitmap, texture

	BYTE *pbS = NULL;
	DWORD *pdwS = NULL;
	DWORD *pdwD = NULL;
	UINT row, col, dwordWidth;

	if( m_nNew == -1 ) m_nNew = 0;

	CheckPointer( pSample, E_POINTER );
	CheckPointer( m_lpD3DTex[ m_nNew ], E_UNEXPECTED );

	// Get the video bitmap buffer
	pSample->GetPointer( &pBmpBuffer );

	// Lock the Texture
	D3DLOCKED_RECT d3dlr;
	if( m_bUseDynamicTextures )
	{
		if( FAILED( m_lpD3DTex[ m_nNew ]->LockRect( 0, &d3dlr, 0, D3DLOCK_DISCARD ) ) )
			return E_FAIL;
	}else
	{
		if( FAILED( m_lpD3DTex[ m_nNew ]->LockRect( 0, &d3dlr, 0, 0 ) ) )
			return E_FAIL;
	}
	// Get the texture buffer & pitch
	pTxtBuffer = static_cast<byte *>( d3dlr.pBits );
	lTxtPitch = d3dlr.Pitch;

	// Copy the bits
	{
		// Instead of copying data bytewise, we use DWORD alignment here.
		// We also unroll loop by copying 4 pixels at once.
		//
		// original BYTE array is [b0][g0][r0][b1][g1][r1][b2][g2][r2][b3][g3][r3]
		//
		// aligned DWORD array is     [b1 r0 g0 b0][g2 b2 r1 g1][r3 g3 b3 r2]
		//
		// We want to transform it to [ff r0 g0 b0][ff r1 g1 b1][ff r2 g2 b2][ff r3 b3 g3]
		// below, bitwise operations do exactly this.

		dwordWidth = m_lVidWidth / 4;				// aligned width of the row, in DWORDS
													// (pixel by 3 bytes over sizeof(DWORD))

		pTxtBuffer += ( ( m_lVidHeight - 1 ) * lTxtPitch );
		for( row = 0; row < static_cast<UINT>( m_lVidHeight ); row++ )
		{
			pdwS = reinterpret_cast<DWORD*>( pBmpBuffer );
			pdwD = reinterpret_cast<DWORD*>( pTxtBuffer );

			for( col = 0; col < dwordWidth; col++ )
			{
				pdwD[ 0 ] = ( ( pdwS[ 0 ]         | 0xFF000000 ) );
				pdwD[ 1 ] = ( ( pdwS[ 1 ] << 8 )  | 0xFF000000 ) | ( pdwS[ 0 ] >> 24 );
				pdwD[ 2 ] = ( ( pdwS[ 2 ] << 16 ) | 0xFF000000 ) | ( pdwS[ 1 ] >> 16 );
				pdwD[ 3 ] = (                       0xFF000000 ) | ( pdwS[ 2 ] >> 8 );
				pdwD += 4;
				pdwS += 3;
			}

			// we might have remaining (misaligned) bytes here
			pbS = reinterpret_cast<BYTE*>( pdwS );
			for( col = 0; col < static_cast<UINT>( m_lVidWidth % 4 ); col++ )
			{
				*pdwD = 0xFF000000
					  | ( pbS[ 2 ] << 16 )
					  | ( pbS[ 1 ] <<  8 )
					  | ( pbS[ 0 ] );
				pdwD++;
				pbS += 3;
			}

			pBmpBuffer += m_lVidPitch;
			pTxtBuffer -= lTxtPitch;
		}// for rows
	}

	// Unlock the Texture
    if( FAILED( m_lpD3DTex[ m_nNew ]->UnlockRect( 0 ) ) )
		return E_FAIL;

	// 
	m_nNew++;
	m_nNew &= 0x01;

    return S_OK;
}

/*******************************************************************************
 *	@fn				LPDIRECT3DTEXTURE9& CDLMovie::GetTexture( void )
 *	@retval			LPDIRECT3DTEXTURE9			eNX`
 *	@brief			eNX`[擾
 ******************************************************************************/
LPDIRECT3DTEXTURE9& CDLMovie::GetTexture( void )
{
	if( ( m_nNew >= 0 ) && ( m_nNow >= 0 ) )
	{
		m_nNow = m_nNew;
		m_nNow ^= 0x01;
	}else
		m_nNow = 0;

	return m_lpD3DTex[ m_nNow ];
}

/*******************************************************************************
 *	@fn				int CDLMovie::ReleaseTex( void )
 *	@retval			int							S_OK/E_FAIL/E_INVALIDARG
 *	@brief			eNX`[̉
 ******************************************************************************/
int CDLMovie::ReleaseTex( void )
{
	for( int i = 0; i < TEX_MAX; i++ )
		_RELEASE( m_lpD3DTex[ i ] );
	return S_OK;
}

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				CDLShow::CDLShow( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLShow::CDLShow( void )
	: m_hWnd()

	, m_DSMovie0()
	, m_DSMovie1()
	, m_DSMovie2()
	, m_DSMovie3()
{
	m_pMovie[ 0 ] = &m_DSMovie0;
	m_pMovie[ 1 ] = &m_DSMovie1;
	m_pMovie[ 2 ] = &m_DSMovie2;
	m_pMovie[ 3 ] = &m_DSMovie3;
}

/*******************************************************************************
 *	@fn				CDLShow::~CDLShow( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLShow::~CDLShow( void )
{
	End();
}

/*******************************************************************************
 *	@fn				int CDLShow::Init( const HWND& hWnd,
 *									   const LPDIRECT3DDEVICE9& lpD3DDev )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLShow::Init( const HWND& hWnd,
				   const LPDIRECT3DDEVICE9& lpD3DDev )
{
	HRESULT hr = S_OK;
	m_hWnd = hWnd;
	m_lpD3DDev = lpD3DDev;

	for( int i = 0; i < MOVIE_MAX; i++ )
		SDSMOVIE *pMovie = m_pMovie[ i ];

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::End( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			I
 ******************************************************************************/
int CDLShow::End( void )
{
	for( int i = 0; i < MOVIE_MAX; i++ )
		Release( i );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::Release( const int& nNum )
 *	@param[in]		nNum						ԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLShow::Release( const int& nNum )
{
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	pMovie->m_pFSrcPinOut = NULL;
	pMovie->m_pFSrcFilter = NULL;

	pMovie->m_pAudio = NULL;

	pMovie->m_pEvent = NULL;
	pMovie->m_pPosition = NULL;
	pMovie->m_pControl = NULL;

	pMovie->m_pFilter = NULL;
	pMovie->m_pBuilder = NULL;

	return TRUE;
}
/*******************************************************************************
 *	@fn				int CDLShow::Update( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʍXV
 ******************************************************************************/
int CDLShow::Update( void )
{
	HRESULT hr;

	for( int i = 0; i < MOVIE_MAX; i++ )
	{
		SDSMOVIE *pMovie = m_pMovie[ i ];
		// eNX`擾
		if( pMovie->m_pD3DTex != NULL )
			pMovie->m_pD3DTex->m_lpD3DTex = pMovie->m_CMovie->GetTexture();

		// [v
		if( pMovie->m_bLoop )
		{
			long lEventCode;
			LONG_PTR lParam1, lParam2;
			
			if( !pMovie->m_pEvent ) continue;

			// Check for completion events
			hr = pMovie->m_pEvent->GetEvent( &lEventCode, &lParam1, &lParam2, 0 );
			if( SUCCEEDED( hr ) )
			{
				// If we have reached the end of the media file, reset to beginning
				if( EC_COMPLETE == lEventCode )
					hr = pMovie->m_pPosition->put_CurrentPosition( 0 );
				// Free any memory associated with this event
				hr = pMovie->m_pEvent->FreeEventParams( lEventCode, lParam1, lParam2 );
			}
		}
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				SDSMOVIE* CDLShow::GetMovie( const int& nNum )
 *	@param[in]		int							[r[ԍ
 *	@retval			SDSMOVIE*					[r[
 *	@brief			[r[擾
 ******************************************************************************/
SDSMOVIE* CDLShow::GetMovie( const int& nNum )
{
	_ASSERT( nNum < MOVIE_MAX && "GetMovie()" );
	return m_pMovie[ nNum ];
}

/*******************************************************************************
 *	@fn				int CDLSound::LoadMov( const LPWSTR& szName,
 *										   const int& nNum,
 *										   SD3DTEXTURE* pD3DTex )
 *	@param[in]		szName						t@C
 *	@param[in]		nNum						ԍ
 *	@param[in]		pD3DTex						eNX`\
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[r[ǂݍ
 ******************************************************************************/
int CDLShow::LoadMov( const LPWSTR& szName,
					  const int& nNum,
					  SD3DTEXTURE* pD3DTex )
{
	_ASSERT( nNum < MOVIE_MAX && "LoadMov()" );

	HRESULT hr = S_OK;
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	pMovie->m_pD3DTex = pD3DTex;
	pMovie->m_pD3DTex->m_eTex = ED3DTEX_MOVIE;
	pMovie->m_pD3DTex->m_szName = "Movie";
	_RELEASE( pMovie->m_pD3DTex->m_lpD3DTex );

	pMovie->m_szName = szName;

	// IGraphBuilder ̏
	FAIL_RET( ::CoCreateInstance( CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, IID_IGraphBuilder, reinterpret_cast<void**>( &pMovie->m_pBuilder ) ) );

	// Create the Texture Renderer object
	// http://msdn.microsoft.com/ja-jp/library/cc352790.aspx
	pMovie->m_CMovie = new CDLMovie( NULL, &hr, m_lpD3DDev );
	pMovie->m_pFilter = pMovie->m_CMovie;

	FAIL_RET( pMovie->m_pBuilder->AddFilter( pMovie->m_pFilter, L"TEXTURERENDERER" ) );

	FAIL_RET( pMovie->m_pBuilder.QueryInterface( &pMovie->m_pControl ) );
	FAIL_RET( pMovie->m_pBuilder.QueryInterface( &pMovie->m_pPosition ) );
	FAIL_RET( pMovie->m_pBuilder.QueryInterface( &pMovie->m_pEvent ) );

	FAIL_RET( pMovie->m_pBuilder.QueryInterface( &pMovie->m_pAudio ) );

	// ǂݍ
	// Add the source filter to the graph.
	FAIL_RET( pMovie->m_pBuilder->AddSourceFilter( szName, L"SOURCE", &pMovie->m_pFSrcFilter ) );
	// If the media file was not found, inform the user.
	if( hr == VFW_E_NOT_FOUND ) return hr;
	else if( FAILED( hr ) )		return hr;
	
	FAIL_RET( pMovie->m_pFSrcFilter->FindPin( L"Output", &pMovie->m_pFSrcPinOut ) );
	FAIL_RET( pMovie->m_pBuilder->Render( pMovie->m_pFSrcPinOut ) );

	// ݒ
	pMovie->m_bLoop = FALSE;
	pMovie->m_pPosition->get_Rate( &pMovie->m_dRate );
	pMovie->m_pPosition->get_Duration( &pMovie->m_dLen );
	pMovie->m_pPosition->put_CurrentPosition( 0.0f );

	pMovie->m_pAudio->put_Balance( pMovie->m_lBalance );
	pMovie->m_pAudio->put_Volume( pMovie->m_lVolume );

	return TRUE;
}

/*******************************************************************************
 *	@fn				void CDLShow::ReloadMov( SD3DTEXTURE* pD3DTex )
 *	@param[in]		pD3DTex						eNX`\
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			č\zɎgȏ
 ******************************************************************************/
int CDLShow::ReloadMov( SD3DTEXTURE* pD3DTex )
{
	for( int i = 0; i < MOVIE_MAX; i++ )
	{
		SDSMOVIE *pMovie = m_pMovie[ i ];

		if( pMovie->m_pD3DTex == NULL )
		{
			LoadMov( pMovie->m_szName, i, pD3DTex );
			break;
		}
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::RemoveMov( const int& nNum )
 *	@param[in]		nNum						ԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[r[
 ******************************************************************************/
int CDLShow::RemoveMov( const int& nNum )
{
	_ASSERT( nNum < MOVIE_MAX && "RemoveMov()" );
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	StopMovie( nNum );

	// C^[tFCX
	Release( nNum );

	// eNX`
//	pMovie->m_CMovie->ReleaseTex();		// tB^̃fXgN^ŉ
	pMovie->m_pD3DTex = NULL;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::RemoveALL( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			fޑS
 ******************************************************************************/
int CDLShow::RemoveALL( void )
{
	for( int i = 0; i < MOVIE_MAX; i++ )
		RemoveMov( i );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::PlayMovie( const int& nNum,
 *											const double& refLen,
 *										    const int& nVolume,
 *											const BOOL& bLoop )
 *	@param[in]		nNum						ԍ
 *	@param[in]		refLen						ĐJnʒu(lF0.0f)
 *	@param[in]		nVolume						{[(0-100)(lF50)
 *	@param[in]		bLoop						[vtO(TRUE=ON/FALSE=OFF)(lFFALSE)
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[r[Đ
 ******************************************************************************/
int CDLShow::PlayMovie( const int& nNum,
					    const double& refLen,
					    const int& nVolume,
						const BOOL& bLoop )
{
	_ASSERT( nNum < MOVIE_MAX && "PlayMovie()" );
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	pMovie->m_pD3DTex->m_D3DDesc = pMovie->m_CMovie->GetDesc();

	SetPosition( nNum, refLen );
	SetVolume( nNum, nVolume );
	pMovie->m_bLoop = bLoop;

	if( pMovie->m_pControl != NULL )
		pMovie->m_pControl->Run();

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::StopMovie( const int& nNum )
 *	@param[in]		nNum						ԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			[r[~
 ******************************************************************************/
int CDLShow::StopMovie( const int& nNum )
{
	_ASSERT( nNum < MOVIE_MAX && "StopMovie()" );
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	if( pMovie->m_pControl != NULL )
		pMovie->m_pControl->Stop();

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::SetPosition( const int& nNum,
 *											  const double& refLen )
 *	@param[in]		nNum						ԍ
 *	@param[in]		refLen						ĐJnʒu
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ĐJnʒu
 ******************************************************************************/
int CDLShow::SetPosition( const int& nNum,
						  const double& refLen )
{
	_ASSERT( nNum < MOVIE_MAX && "SetPosition()" );
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	double dLenMax;
	pMovie->m_pPosition->get_Duration( &dLenMax );

	double dLen = refLen;
	if( refLen < 0.0f ) dLen = 0.0f;
	if( refLen > dLenMax ) dLen = dLenMax;

	pMovie->m_dLen = dLen;
	pMovie->m_pPosition->put_CurrentPosition( pMovie->m_dLen );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLShow::SetVolume( const int& nNum,
 *										    const int& nVolume )
 *	@param[in]		nNum						ԍ
 *	@param[in]		nVolume						{[(0-100)
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			{[
 ******************************************************************************/
int CDLShow::SetVolume( const int& nNum,
					    const int& nVolume )
{
	_ASSERT( nNum < MOVIE_MAX && "SetVolume()" );
	SDSMOVIE *pMovie = m_pMovie[ nNum ];

	int nVol = nVolume;
	if( nVolume < 0 ) nVol = 0;
	if( nVolume > 100 ) nVol = 100;

	pMovie->m_lVolume = ( nVol - 100 ) * 100;
	pMovie->m_pAudio->put_Volume( pMovie->m_lVolume );

	return TRUE;
}

}	// namespace	DL

