/*******************************************************************************
 *	@file			DLInput.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			31-Oct-2010(Sun)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DLInput.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				int CDLInput::InitKeyboard( const HWND& hWnd )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			L[{[h
 *					c_dfDIKeyboard gpAQTUoCg̔zp
 ******************************************************************************/
int CDLInput::InitKeyboard( const HWND& hWnd )
{
	HRESULT hr = DS_OK;
	if( !m_lpInput ) return FALSE;

	// IDirectInputDevice8 C^[tFCX̎擾
	hr = m_lpInput->CreateDevice( GUID_SysKeyboard, &m_lpKeyboard, NULL );
	if( FAILED( hr ) )
		DXTRACE_ERR( "CreateDevice()", hr );

	// f[^EtH[}bg̐ݒ
	hr = m_lpKeyboard->SetDataFormat( &c_dfDIKeyboard );
	if( FAILED( hr ) )
		DXTRACE_ERR( "SetDataFormat()", hr );

	// [h̐ݒ
	hr = m_lpKeyboard->SetCooperativeLevel( hWnd, DISCL_FOREGROUND | DISCL_EXCLUSIVE );
	if( FAILED( hr ) )
		DXTRACE_ERR( "SetCooperativeLevel()", hr );

	// ͐Jn
	hr = m_lpKeyboard->Acquire();
	if( FAILED( hr ) )
		DXTRACE_ERR( "Acquire()", hr );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLInput::InitMouse( const HWND& hWnd )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			}EX
 *					c_dfDIMouse gp
 *					c_dfDIMouse2 ͖gp
 ******************************************************************************/
int CDLInput::InitMouse( const HWND& hWnd )
{
	HRESULT hr = DS_OK;
	if( !m_lpInput ) return FALSE;

	// IDirectInputDevice8 C^[tFCX̎擾
	hr = m_lpInput->CreateDevice( GUID_SysMouse, &m_lpMouse, NULL );
	if( FAILED( hr ) )
		DXTRACE_ERR( "CreateDevice()", hr );

	// f[^EtH[}bg̐ݒ
	hr = m_lpMouse->SetDataFormat( &c_dfDIMouse );
	if( FAILED( hr ) )
		DXTRACE_ERR( "SetDataFormat()", hr );

	// [h̐ݒ
	hr = m_lpMouse->SetCooperativeLevel( hWnd, DISCL_FOREGROUND | DISCL_EXCLUSIVE );
	if( FAILED( hr ) )
		DXTRACE_ERR( "SetCooperativeLevel()", hr );

	// foCX̐ݒiΒl[hɐݒBftHgȂ̂Ŏۂ͕KvȂj
	DIPROPDWORD		diprop;
	diprop.diph.dwSize			= sizeof( diprop );
	diprop.diph.dwHeaderSize	= sizeof( diprop.diph );
	diprop.diph.dwObj			= 0;
	diprop.diph.dwHow			= DIPH_DEVICE;
	diprop.dwData				= DIPROPAXISMODE_REL;
	hr = m_lpMouse->SetProperty( DIPROP_AXISMODE, &diprop.diph );
	if( FAILED( hr ) )
		DXTRACE_ERR( "SetProperty()", hr );

	// ͐Jn
	hr = m_lpMouse->Acquire();
	if( FAILED( hr ) )
		DXTRACE_ERR( "Acquire()", hr );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLInput::GetKeyboardState( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			L[{[hԎ擾
 *					JE^[̃I[o[t[͍̂Ƃ떳
 *					obt@ÔƂ떢
 ******************************************************************************/
int CDLInput::GetKeyboardState( void )
{
	HRESULT hr = DS_OK;
	int nNow = ( ++m_nKeyNow ) % KEYSTATE_MAX;

	// L[{[h̏Ԃ擾
	hr = m_lpKeyboard->GetDeviceState( KEYBUFFER_MAX, m_byKey[ nNow ] );
	if( FAILED( hr ) )
	{
		if( ( hr == DIERR_INPUTLOST ) || ( hr == DIERR_NOTACQUIRED ) )
		{
			m_lpKeyboard->Acquire();
			return FALSE;
		}
		DXTRACE_ERR( "GetDeviceState()", hr );
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLInput::GetMouseState( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			}EXԎ擾
 ******************************************************************************/
int CDLInput::GetMouseState( void )
{
	HRESULT hr = DS_OK;

	// }EX̏Ԃ擾
	hr = m_lpMouse->GetDeviceState( sizeof( DIMOUSESTATE ), &m_DIMS );
	if( FAILED( hr ) )
	{
		if( ( hr == DIERR_INPUTLOST ) || ( hr == DIERR_NOTACQUIRED ) )
		{
			m_lpMouse->Acquire();
			return FALSE;
		}
		DXTRACE_ERR( "GetDeviceState()", hr );
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				CDLInput::CDLInput( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLInput::CDLInput( void )
	: m_lpInput( NULL )
	, m_lpKeyboard( NULL )
	, m_lpMouse( NULL )

	, m_nKeyNow( 0 )
	, m_DIMS()
{
}

/*******************************************************************************
 *	@fn				CDLInput::~CDLInput( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLInput::~CDLInput( void )
{
	End();
}

/*******************************************************************************
 *	@fn				int CDLInput::Init( const HWND& hWnd )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLInput::Init( const HWND& hWnd )
{
	HRESULT hr = DS_OK;
	HINSTANCE hInst = reinterpret_cast<HINSTANCE>( ::GetWindowLong( hWnd, GWL_HINSTANCE ) );

	// IDirectInput8 C^[tFCX̎擾
	hr = ::DirectInput8Create( hInst, DIRECTINPUT_VERSION, IID_IDirectInput8,
							   reinterpret_cast<void**>( &m_lpInput ), NULL );
	if( FAILED( hr ) )
		DXTRACE_ERR( "DirectInput8Create()", hr );

	// L[{[h
	if( !InitKeyboard( hWnd ) ) return FALSE;
	// }EX
	if( !InitMouse( hWnd ) ) return FALSE;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLInput::End( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			I
 ******************************************************************************/
int CDLInput::End( void )
{
	// }EXEfoCX̉
	if( m_lpMouse != NULL )
	{
		m_lpMouse->Unacquire();
		_RELEASE( m_lpMouse );
	}
	// L[{[hEfoCX̉
	if( m_lpKeyboard != NULL )
	{
		m_lpKeyboard->Unacquire();
		_RELEASE( m_lpKeyboard );
	}
	// IDirectInput8 C^[tFCX̉
	_RELEASE( m_lpInput );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLInput::GetState( BYTE* byKey, DIMOUSESTATE* diMouse )
 *	@param[out]		BYTE*						L[{[h̒l
 *	@param[out]		DIMOUSESTATE*				}EX̒l
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			Ԏ擾n
 ******************************************************************************/
int CDLInput::GetState( BYTE* byKey, DIMOUSESTATE* diMouse )
{
	HRESULT hr = DS_OK;
	if( !m_lpInput ) return FALSE;

	// foCX̏Ԏ擾Ǝ󂯓n
	if( byKey != NULL )
	{
		// L[{[h̏Ԏ擾
		if( GetKeyboardState() )
			// Ԏ󂯓n
			::memcpy_s( byKey, KEYBUFFER_MAX, m_byKey[ m_nKeyNow % KEYSTATE_MAX ], KEYBUFFER_MAX );
	}
	if( diMouse != NULL )
	{
		// }EX̏Ԏ擾
		if( GetMouseState() )
			// Ԏ󂯓n
			*diMouse = m_DIMS;
	}

	return TRUE;
}

}	// namespace	DL
