/*******************************************************************************
 *	@file			DLGraph.h
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			21-Apr-2010(Wed)
 ******************************************************************************/

#ifndef	__DLGRAPH_INCLUDE__
#define	__DLGRAPH_INCLUDE__

// vvZbT---------------------------------------------------------------
#include "DL.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// 萔`---------------------------------------------------------------------
#pragma once

#define SetTextureColorStage( dev, i, arg1, op, arg2 )			\
		dev->SetTextureStageState( i, D3DTSS_COLOROP, op );		\
		dev->SetTextureStageState( i, D3DTSS_COLORARG1, arg1 );	\
		dev->SetTextureStageState( i, D3DTSS_COLORARG2, arg2 );

#define SetTextureAlphaStage( dev, i, arg1, op, arg2 )			\
		dev->SetTextureStageState( i, D3DTSS_ALPHAOP, op );		\
		dev->SetTextureStageState( i, D3DTSS_ALPHAARG1, arg1 );	\
		dev->SetTextureStageState( i, D3DTSS_ALPHAARG2, arg2 );

#define	FVFTEX_MAX			8

// 񋓌^`-------------------------------------------------------------------
/*******************************************************************************
 *	@enum		ED3DDRAW			DLGraph.h		"DLGraph.h"
 *	@brief		`
 ******************************************************************************/
enum ED3DDRAW
{
	ED3DDRAW_NULL			= 0,												//!< Ȃ
	ED3DDRAW_ON,																//!< `悷
	ED3DDRAW_OFF,																//!< `悵Ȃ

	ED3DDRAW_MAX,
};

/*******************************************************************************
 *	@enum		ED3DSTATE			DLGraph.h		"DLGraph.h"
 *	@brief		Xe[g
 ******************************************************************************/
enum ED3DSTATE
{
	ED3DSTATE_NORMAL,															//!< ʏ
	ED3DSTATE_ADD,																//!< Z
	ED3DSTATE_SUB,																//!< Z
	ED3DSTATE_SUBTRACT		= ED3DSTATE_SUB,
	ED3DSTATE_MUL,																//!< Z
	ED3DSTATE_MULTIPLY		= ED3DSTATE_MUL,
	ED3DSTATE_SCR,																//!< XN[
	ED3DSTATE_SCREEN		= ED3DSTATE_SCR,
	ED3DSTATE_CMPD,																//!< riÁj
	ED3DSTATE_DARKEN		= ED3DSTATE_CMPD,
	ED3DSTATE_CMPL,																//!< rij
	ED3DSTATE_LIGHTEN		= ED3DSTATE_CMPL,
	ED3DSTATE_EXC,																//!< O
	ED3DSTATE_EXCLUSION	= ED3DSTATE_EXC,

	ED3DSTATE_MAX,
};

/*******************************************************************************
 *	@enum		ED3DTEX			DLGraph.h		"DLGraph.h"
 *	@brief		eNX`
 ******************************************************************************/
enum ED3DTEX
{
	ED3DTEX_NULL			= 0,												//!< Ȃ
	ED3DTEX_TEXTURE,															//!< eNX`
	ED3DTEX_FILE,																//!< t@C
	ED3DTEX_MEMORY,																//!< 
	ED3DTEX_MOVIE,																//!< [r[

	ED3DTEX_MAX,
};

// \̒`-------------------------------------------------------------------
/*******************************************************************************
 *	@struct		SDLGRAPH		DLGraph.h		"DLGraph.h"
 *	@brief		Graphics\
 ******************************************************************************/
struct SDLGRAPH
{
	SDLGRAPH()
		: m_nWidth( 0 )
		, m_nHeight( 0 )
		, m_bMode( FALSE )
	{
	}

	//
	int						m_nWidth;											//!< 
	int						m_nHeight;											//!< 
	BOOL					m_bMode;											//!< [h
};

/*******************************************************************************
 *	@struct		SD3DFVFTEX		DLGraph.h		"DLGraph.h"
 *	@brief		eNX`W\
 ******************************************************************************/
struct SD3DFVFTEX
{
	float					tu;													//!< eNX`W
	float					tv;													//!< eNX`W
};

/*******************************************************************************
 *	@struct		SD3DVERTEX		DLGraph.h		"DLGraph.h"
 *	@brief		_\
 ******************************************************************************/
struct SD3DVERTEX
{
	float					x, y, z;											//!< ʒuW
	float					rhw;												//!< ̋t
	D3DCOLOR				color;												//!< _F
	SD3DFVFTEX				tex[ FVFTEX_MAX ];									//!< eNX`W\
};

/*******************************************************************************
 *	@struct		SD3DTEXTURE		DLGraph.h		"DLGraph.h"
 *	@brief		eNX`\
 ******************************************************************************/
struct SD3DTEXTURE
{
	SD3DTEXTURE()
		: m_lpD3DTex( NULL )
		, m_D3DDesc()

		, m_eTex( ED3DTEX_NULL )

		, m_szName()
		, m_byData( NULL )
		, m_nSize( 0 )
	{
	}

	//
	LPDIRECT3DTEXTURE9		m_lpD3DTex;											//!< eNX`
	D3DSURFACE_DESC			m_D3DDesc;											//!< \[X

	ED3DTEX					m_eTex;												//!< eNX`tO

	LPCSTR					m_szName;											//!< O
	BYTE*					m_byData;											//!< f[^
	int						m_nSize;											//!< f[^TCY
};

/*******************************************************************************
 *	@struct		SD3DFONT		DLGraph.h		"DLGraph.h"
 *	@brief		tHg\
 ******************************************************************************/
struct SD3DFONT
{
	SD3DFONT()
		: m_lpD3DFont( NULL )

		, m_szName()
		, m_nHeight( 0 )
	{
	}

	//
	LPD3DXFONT				m_lpD3DFont;										//!< tHg

	LPCSTR					m_szName;											//!< O
	int						m_nHeight;											//!< 
};

/*******************************************************************************
 *	@struct		SD3DDATA		DLGraph.h		"DLGraph.h"
 *	@brief		IuWFNgf[^\
 ******************************************************************************/
struct SD3DDATA
{
	SD3DDATA()
		: m_nDataMax( 0 )
		, m_pData( NULL )
	{
	}

	//
	int						m_nDataMax;											//!< f[^
	SD3DVERTEX*				m_pData;											//!< f[^
};

/*******************************************************************************
 *	@struct		SD3DTEXT		DLGraph.h		"DLGraph.h"
 *	@brief		IuWFNgeLXg\
 ******************************************************************************/
struct SD3DTEXT
{
	SD3DTEXT()
		: m_reRect()
		, m_dwColor( 0x00000000 )
		, m_szStr()
	{
	}

	//
	RECT					m_reRect;											//!< \`
	DWORD					m_dwColor;											//!< \F

	LPSTR					m_szStr;											//!< iAhX̂݁j
};

/*******************************************************************************
 *	@struct		SD3DOBJECT		DLGraph.h		"DLGraph.h"
 *	@brief		IuWFNg\
 ******************************************************************************/
struct SD3DOBJECT
{
	SD3DOBJECT()
		: m_bUsed( FALSE )
		, m_eObj( EOBJECT_NULL )
		, m_nPrio( -1 )
		, m_eState( ED3DSTATE_NORMAL )
		, m_eDraw( ED3DDRAW_NULL )
		, m_pPrev( NULL )
		, m_pNext( NULL )
	{
		for( int i = 0; i < FVFTEX_MAX; i++ )
			m_nMatNum[ i ] = -1;
	}

	// {
	BOOL					m_bUsed;											//!< gptO
	EOBJECT					m_eObj;												//!< IuWFNg
	int						m_nPrio;											//!< `vCIeB
	// f
	int						m_nMatNum[ FVFTEX_MAX ];							//!< fޔԍ
	// 
	ED3DSTATE				m_eState;											//!< Xe[gtO
	// `
	ED3DDRAW				m_eDraw;											//!< `tO
	// Kw\
	SD3DOBJECT*				m_pPrev;											//!< O
	SD3DOBJECT*				m_pNext;											//!< 

	// ėpf[^
	void*					m_pObj;												//!< ėpf[^
};

// NX-----------------------------------------------------------------------
/*******************************************************************************
 *	@struct		CD3DTable		DLGraph.h		"DLGraph.h"
 *	@brief		e[uǗNX
 ******************************************************************************/
class CD3DTable
{
public:
	CD3DTable( int nPrio,
			   SD3DOBJECT* pObj )
		: m_nPrio( nPrio )
		, m_pObj( pObj )
	{
	}

	// rZq
	bool operator<( const CD3DTable& n ) const
	{
		return m_nPrio < n.m_nPrio;
	}

	int						m_nPrio;
	SD3DOBJECT*				m_pObj;
};

/*******************************************************************************
 *	@class		CDLGraph		DLGraph.h			"DLGraph.h"
 *	@brief		CDLGraphNX
 ******************************************************************************/
class CDLGraph
{
// 萔`---------------------------------------------------------------------
private:
protected:
public:
	static const int TEXTURE_MAX	= 4096;										//!< eNX`
	static const int FONT_MAX		= 1024;										//!< tHg
	static const int OBJECT_MAX		= 65536;									//!< IuWFNg

// o֐-------------------------------------------------------------------
private:
	static int ( CDLGraph::*StepDel[ EOBJECT_GRAPHEND - EOBJECT_GRAPHSTART ] )( const int& nNum );
	static int ( CDLGraph::*StepDraw[ EOBJECT_GRAPHEND - EOBJECT_GRAPHSTART ] )( SD3DOBJECT* pObj );

	BOOL SetViewPort( const int& nWidth,
					  const int& nHeight );										//!< r[|[g̐ݒ
	BOOL DeviceRestore( const HRESULT& hRes );									//!< foCX̕

	void Cleanup( void );														//!< \[X
	void Reconstruct( void );													//!< č\z

	// o^
	void EntryState( void );													//!< Xe[g̓o^

	// fލēǂݍ
	int ReloadTex( const int& nNum );											//!< eNX`ēǂݍ
	int ReloadBmp( const int& nNum );											//!< 摜ēǂݍ
	int ReloadMem( const int& nNum );											//!< ēǂݍ
	int ReloadFont( const int& nNum );											//!< tHgč쐬

	// IuWFNg폜
	int DelRect( const int& nNum );												//!< `폜
	int DelVertex( const int& nNum );											//!< ʍ폜
	int DelText( const int& nNum );												//!< eLXg폜

	// IuWFNg`
	int DrawPrimitiveUP( SD3DOBJECT* pObj );									//!< v~eBu`
	int DrawText( SD3DOBJECT* pObj );											//!< eLXg`

protected:
public:
	CDLGraph( void );
	~CDLGraph( void );

	void SetGraph( const SDLGRAPH& SGraph );									//!< ZbgAbv\̐ݒ

	int Init( const HWND& hWnd );												//!< 
	int Init( const HWND& hWnd,
			  const int& nWidth,
			  const int& nHeight,
			  const BOOL& bMode );												//!< 
	int End( void );															//!< I

	int Update( void );															//!< ʍXV

	int ChangeDisplay( const int& nPosX,
					   const int& nPosY,
					   const int& nWidth,
					   const int& nHeight,
					   const BOOL& bMode );										//!< ʐ؂ւ
	int SetDLShow( void* pDLShow );

	const LPDIRECT3D9& GetD3DObject( void ){ return m_lpD3D; }					//!< D3D IuWFNg擾
	const LPDIRECT3DDEVICE9& GetD3DDevice( void ){ return m_lpD3DDev; }			//!< D3D foCX擾

	// ڊ
	SD3DTEXTURE* GetTexture( const int& nNum );									//!< eNX`擾
	SD3DFONT* GetFont( const int& nNum );										//!< tHg擾
	SD3DOBJECT* GetObject( const int& nNum );									//!< IuWFNg擾

	// fޓǂݍ
	int LoadTex( const LPBYTE& lpBuf,
				 const int& nSize,
				 const int& nWidth,
				 const int& nHeight );											//!< eNX`̐VK쐬
	int LoadBmp( const LPSTR& szName );											//!< 摜ǂݍ
	int LoadMem( const LPBYTE& lpBuf,
				 const int& nSize );											//!< ǂݍ
	int LoadFont( const LPSTR& szName,
				  const int& nHeight );											//!< tHg쐬

	// fމ
	int RemoveTex( const int& nNum );											//!< eNX`
	int RemoveBmp( const int& nNum );											//!< 摜
	int RemoveMem( const int& nNum );											//!< 
	int RemoveFont( const int& nNum );											//!< tHg
	int RemoveALL( void );														//!< fޑS

	// IuWFNgǉ
	int AddRect( const int& nPrio,
				 const int (&nMatNum)[ FVFTEX_MAX ],
				 const ED3DDRAW& eDraw,
				 const ED3DSTATE& eState,
				 const RECT& rcRect,
				 const int& nColor );											//!< `ǉ
	int AddVertex( const int& nPrio,
				   const int (&nMatNum)[ FVFTEX_MAX ],
				   const ED3DDRAW& eDraw,
				   const ED3DSTATE& eState,
				   const int& nVertex,
				   const SD3DVERTEX* SVertex );									//!< ʒǉ
	int AddText( const int& nPrio,
				 const int (&nMatNum)[ FVFTEX_MAX ],
				 const ED3DDRAW& eDraw,
				 const RECT& rcRect,
				 const int& nColor,
				 const LPSTR& lpStr );											//!< eLXgǉ

	// IuWFNg폜
	int Del( const int& nNum );													//!< IuWFNg폜
	int DelALL( void );															//!< IuWFNgS폜

	// Kw\
	int Connect( const int& nNum1,
				 const int& nNum2 );											//!< IuWFNgm̐ڑ
	int Disconnect( const int& nNum );											//!< IuWFNgm̐ؒf

// oϐ-------------------------------------------------------------------
private:
	LPDIRECT3D9				m_lpD3D;											//!< Direct3D IuWFNg
	LPDIRECT3DDEVICE9		m_lpD3DDev;											//!< Direct3D foCX

	void*					m_pDLShow;											//!< DirectX Show

	HWND					m_hWnd;												//!< EChEnh
	SDLGRAPH				m_SGraph;											//!< ZbgAbv\
	D3DPRESENT_PARAMETERS	m_D3DPP;											//!< foCX\
	D3DDISPLAYMODE			m_D3DDM;											//!< fBXvC̏
	D3DVIEWPORT9			m_D3DVP;											//!< r[|[g\

	// Xe[g
	std::vector<LPDIRECT3DSTATEBLOCK9>	m_vState;								//!< Xe[gubN

	// e[u
	std::multiset<CD3DTable>	m_vTable;										//!< `e[u

	// IuWFNg
	std::vector<SD3DTEXTURE>	m_vD3DTex;										//!< eNX`\
	std::vector<SD3DFONT>	m_vD3DFont;											//!< tHg\
	std::vector<SD3DOBJECT>	m_vD3DObj;											//!< IuWFNg\

protected:
public:

};

// OO[oϐ-----------------------------------------------------------

// O֐vg^Cv錾-----------------------------------------------------

}	// namespace	DL

#ifdef __cplusplus
}
#endif

#endif	// __DLGRAPH_INCLUDE__
