/*******************************************************************************
 *	@file			DLGraph.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			21-Apr-2010(Wed)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DLGraph.h"
#include "DLShow.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------
// o[֐|C^iIuWFNg폜j
int ( CDLGraph::*CDLGraph::StepDel[ EOBJECT_GRAPHEND - EOBJECT_GRAPHSTART ] )( const int& nNum ) =
{
	&CDLGraph::DelRect, &CDLGraph::DelVertex,
	&CDLGraph::DelText,
};
// o[֐|C^iIuWFNg`j
int ( CDLGraph::*CDLGraph::StepDraw[ EOBJECT_GRAPHEND - EOBJECT_GRAPHSTART ] )( SD3DOBJECT* pObj ) =
{
	&CDLGraph::DrawPrimitiveUP, &CDLGraph::DrawPrimitiveUP,
	&CDLGraph::DrawText,
};

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				BOOL CDLGraph::SetViewPort( const int& nWidth,
 *												const int& nHeight )
 *	@retval			BOOL						TRUE=OK/FALSE=NG
 *	@brief			r[|[g̐ݒ
 ******************************************************************************/
BOOL CDLGraph::SetViewPort( const int& nWidth,
							const int& nHeight )
{
	HRESULT hr = D3D_OK;
	// http://msdn.microsoft.com/ja-jp/library/cc323943.aspx
	m_D3DVP.X		= 0;
	m_D3DVP.Y		= 0;
	m_D3DVP.Width	= nWidth;
	m_D3DVP.Height	= nHeight;
	m_D3DVP.MinZ	= 0.0f;
	m_D3DVP.MaxZ	= 1.0f;
	hr = m_lpD3DDev->SetViewport( &m_D3DVP );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "SetViewport()", hr );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				BOOL CDLGraph::DeviceRestore( const HRESULT& hRes )
 *	@param[in]		hRes						
 *	@retval			BOOL						TRUE=OK/FALSE=NG
 *	@brief			foCX̕
 ******************************************************************************/
BOOL CDLGraph::DeviceRestore( const HRESULT& hRes )
{
	// foCX̊mF
	if( SUCCEEDED( hRes ) ) return TRUE;

	HRESULT hr;
	// foCX̏
	hr = m_lpD3DDev->TestCooperativeLevel();
	if( FAILED( hr ) )
	{
		// foCX͂܂Ă
		if( hr == D3DERR_DEVICELOST )
			return TRUE;
		// \ʃG[
		if( hr != D3DERR_DEVICENOTRESET )
			return FALSE;

		// \[X
		Cleanup();
		// Ă݂
		hr = m_lpD3DDev->Reset( &m_D3DPP );
		if( FAILED( hr ) )
		{
			// foCX͂܂Ă
			if( hr == D3DERR_DEVICELOST )
				return TRUE;
			return FALSE;
		}
		// č\z
		Reconstruct();
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				void CDLGraph::Cleanup( void )
 *	@retval			none						Ȃ
 *	@brief			\[X
 *					z clear() ͍sȂ
 ******************************************************************************/
void CDLGraph::Cleanup( void )
{
	// DLShow
	CDLShow *pDLShow = static_cast<CDLShow*>( m_pDLShow );
	pDLShow->RemoveALL();
	// 摜
	std::vector<SD3DTEXTURE>::iterator itTex = m_vD3DTex.begin();
	while( itTex != m_vD3DTex.end() )
	{
		SD3DTEXTURE &vTex = (*itTex);
		// [r[DLShowŊǗ
		if( vTex.m_eTex != ED3DTEX_MOVIE )
		{
			_RELEASE( vTex.m_lpD3DTex );
		}else
			vTex.m_lpD3DTex = NULL;
		itTex++;
	}
	// tHg
	std::vector<SD3DFONT>::iterator itFont = m_vD3DFont.begin();
	while( itFont != m_vD3DFont.end() )
	{
		SD3DFONT &vFont = (*itFont);
		_RELEASE( vFont.m_lpD3DFont );
		itFont++;
	}
	// Xe[g
	std::vector<LPDIRECT3DSTATEBLOCK9>::iterator itState = m_vState.begin();
	while( itState != m_vState.end() )
	{
		LPDIRECT3DSTATEBLOCK9 &vState = (*itState);
		_RELEASE( vState );
		itState++;
	}
	m_vState.clear();
}

/*******************************************************************************
 *	@fn				void CDLGraph::Reconstruct( void )
 *	@retval			none						Ȃ
 *	@brief			č\z
 ******************************************************************************/
void CDLGraph::Reconstruct( void )
{
	int nMax;
	// 摜Ď擾
	nMax = m_vD3DTex.size();
	for( int i = 0; i < nMax; i++ )
	{
		SD3DTEXTURE &vTex = m_vD3DTex[ i ];
		// OȂꍇ͖
		if( vTex.m_szName == NULL ) continue;
		switch( vTex.m_eTex )
		{
		case ED3DTEX_TEXTURE:	ReloadTex( i );	break;
		case ED3DTEX_FILE:		ReloadBmp( i );	break;
		case ED3DTEX_MEMORY:	ReloadMem( i );	break;
		case ED3DTEX_MOVIE:										// [r[DLShowŊǗ
			{
				// DLShowč\z
				CDLShow *pDLShow = static_cast<CDLShow*>( m_pDLShow );
				pDLShow->ReloadMov( &vTex );
			}
			break;
		}
	}
	// tHgĎ擾
	nMax = m_vD3DFont.size();
	for( int i = 0; i < nMax; i++ )
	{
		SD3DFONT &vFont = m_vD3DFont[ i ];
		// OȂꍇ͖
		if( vFont.m_szName == NULL ) continue;
		ReloadFont( i );
	}
	// Xe[gĎ擾
	EntryState();
}

/*******************************************************************************
 *	@fn				void CDLGraph::EntryState( void )
 *	@retval			none						Ȃ
 *	@brief			Xe[g̐ݒ
 ******************************************************************************/
void CDLGraph::EntryState( void )
{
	HRESULT hr = D3D_OK;

	for( int i = 0; i < ED3DSTATE_MAX; i++ )
	{
		LPDIRECT3DSTATEBLOCK9 pState;

		// L^Jn
		hr = m_lpD3DDev->BeginStateBlock();

		// http://marupeke296.com/DXG_TextureStage.html
		// http://www.tom.sfc.keio.ac.jp/~fjedi/wiki/index.php?%A5%C6%A5%AF%A5%B9%A5%C1%A5%E3
		// http://d.hatena.ne.jp/Ko-Ta/20070618/p1
		// http://www.bea.hi-ho.ne.jp/gaku-iwa/color/conjn.html
		switch( i )
		{
		case ED3DSTATE_NORMAL:					//!< ʏ(=Src)
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );						//!< (As,As,As,As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );					//!< (1-As,1-As,1-As,1-As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );
			break;
		case ED3DSTATE_ADD:						//!< Z(=Dst+Src)
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );						//!< (As,As,As,As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );
			break;
		case ED3DSTATE_SUB:						//!< Z(=Dst-Src)
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );						//!< (As,As,As,As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT );
			break;
		case ED3DSTATE_MUL:						//!< Z(=Dst*Src)
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureColorStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_BLENDCURRENTALPHA, D3DTA_TEXTURE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ZERO );							//!< (0,0,0,0)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_SRCCOLOR );						//!< (Rs,Gs,Bs,As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );
			break;
		case ED3DSTATE_SCR:						//!< XN[(=255-(255-Dst)*(255-Src))
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureColorStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_BLENDCURRENTALPHA, D3DTA_TEXTURE );
			SetTextureAlphaStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_INVDESTCOLOR );					//!< (1-Rd,1-Gd,1-Bd,1-Ad)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );
			break;
		case ED3DSTATE_CMPD:					//!< riÁj(=min(Dst,Src))
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureColorStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_BLENDCURRENTALPHA, D3DTA_TEXTURE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_MIN );
			break;
		case ED3DSTATE_CMPL:					//!< rij(=max(Dst,Src))
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureColorStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_BLENDCURRENTALPHA, D3DTA_TEXTURE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );							//!< (1,1,1,1)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_MAX );
			break;
		case ED3DSTATE_EXC:						//!< O(=(255-Dst)*Src+(255-Src)*Dst)
			// eNX`EXe[WEXe[g
			SetTextureColorStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureAlphaStage( m_lpD3DDev, 0, D3DTA_TEXTURE, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			SetTextureColorStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_BLENDCURRENTALPHA, D3DTA_TEXTURE );
			SetTextureAlphaStage( m_lpD3DDev, 1, D3DTA_CURRENT, D3DTOP_MODULATE, D3DTA_DIFFUSE );
			// _OEXe[g̐ݒ
			hr = m_lpD3DDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );							//!< At@uhgp
			hr = m_lpD3DDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_INVDESTCOLOR );					//!< (1-Rd,1-Gd,1-Bd,1-Ad)
			hr = m_lpD3DDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCCOLOR );					//!< (1-Rs,1-Gs,1-Bs,1-As)
			hr = m_lpD3DDev->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );
			break;
		default:
			_ASSERT( 0 && "EntryState()" );
			break;
		}

		// L^I
		hr = m_lpD3DDev->EndStateBlock( &pState );

		m_vState.push_back( pState );
	}
}

/*******************************************************************************
 *	@fn				int CDLGraph::ReloadTex( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			eNX`č\z
 ******************************************************************************/
int CDLGraph::ReloadTex( const int& nNum )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE &vTex = m_vD3DTex[ nNum ];

	// eNX`̍쐬
	hr = D3DXCreateTexture(
			m_lpD3DDev,
			vTex.m_D3DDesc.Width,
			vTex.m_D3DDesc.Height,
			D3DX_DEFAULT,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			&vTex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateTexture()" );
		return FALSE;
	}
	// eNX`ɏ
	int nW = ( ( vTex.m_D3DDesc.Width + 3 ) & 0xFFFFFFFC );
	int nH = vTex.m_D3DDesc.Height;
	D3DLOCKED_RECT TexRect;
	vTex.m_lpD3DTex->LockRect( 0, &TexRect, NULL, 0 );
	BYTE *pData = static_cast<BYTE*>( TexRect.pBits );
	for( int i = 0; i < nH; i++ )
		for( int j = 0, k = 0; j < TexRect.Pitch; j++ )
			pData[ i * TexRect.Pitch + j ] = vTex.m_byData[ i * TexRect.Pitch + j ];
	vTex.m_lpD3DTex->UnlockRect( 0 );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::ReloadBmp( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			摜ēǂݍ
 ******************************************************************************/
int CDLGraph::ReloadBmp( const int& nNum )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE &vTex = m_vD3DTex[ nNum ];

	// eNX`̍Đݒ
	// 摜̓ǂݍ
	hr = D3DXCreateTextureFromFileEx(
			m_lpD3DDev,
			vTex.m_szName,
			D3DX_DEFAULT_NONPOW2,
			D3DX_DEFAULT_NONPOW2,
			D3DFMT_FROM_FILE,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			0,
			NULL,
			NULL,
			&vTex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateTextureFromFileEx()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::ReloadMem( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			摜ēǂݍ
 ******************************************************************************/
int CDLGraph::ReloadMem( const int& nNum )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE &vTex = m_vD3DTex[ nNum ];

	// eNX`̍Đݒ
	// 񂩂̃eNX`쐬
	hr = D3DXCreateTextureFromFileInMemoryEx(
			m_lpD3DDev,
			vTex.m_byData,
			vTex.m_nSize,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			D3DX_FILTER_LINEAR,
			D3DX_FILTER_LINEAR,
			0,
			NULL,
			NULL,
			&vTex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateTextureFromFileInMemoryEx()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::ReloadFont( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			tHgč쐬
 ******************************************************************************/
int CDLGraph::ReloadFont( const int& nNum )
{
	HRESULT hr = D3D_OK;
	SD3DFONT &vFont = m_vD3DFont[ nNum ];

	// tHg̐ݒ
	hr = D3DXCreateFont(
			m_lpD3DDev,
			vFont.m_nHeight,
			0,
			FW_NORMAL,
			0,
			FALSE,
			SHIFTJIS_CHARSET,
			OUT_DEFAULT_PRECIS,
			DEFAULT_QUALITY,
			DEFAULT_PITCH | FF_ROMAN,
			vFont.m_szName,
			&vFont.m_lpD3DFont );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateFont()" );
		return FALSE;
	}
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DelRect( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			`폜
 ******************************************************************************/
int CDLGraph::DelRect( const int& nNum )
{
	SD3DOBJECT &vObj = m_vD3DObj[ nNum ];

	// ؒf
	Disconnect( nNum );

	// 
	SD3DDATA* pData = static_cast<SD3DDATA*>( vObj.m_pObj );
	if( pData != NULL )
		_MEMCHECK( pData->m_pData );
	_MEMCHECK( vObj.m_pObj );

	// 
	SD3DOBJECT n;
	vObj = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DelVertex( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʍ폜
 ******************************************************************************/
int CDLGraph::DelVertex( const int& nNum )
{
	SD3DOBJECT &vObj = m_vD3DObj[ nNum ];

	// ؒf
	Disconnect( nNum );

	// 
	SD3DDATA* pData = static_cast<SD3DDATA*>( vObj.m_pObj );
	if( pData != NULL )
		_MEMCHECK( pData->m_pData );
	_MEMCHECK( vObj.m_pObj );

	// 
	SD3DOBJECT n;
	vObj = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DelText( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			eLXg폜
 ******************************************************************************/
int CDLGraph::DelText( const int& nNum )
{
	SD3DOBJECT &vObj = m_vD3DObj[ nNum ];

	// ؒf
	Disconnect( nNum );

	// 
	SD3DTEXT* pText = static_cast<SD3DTEXT*>( vObj.m_pObj );
	if( pText != NULL )
		pText->m_szStr = "";
	_MEMCHECK( vObj.m_pObj );

	// 
	SD3DOBJECT n;
	vObj = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DrawPrimitiveUP( SD3DOBJECT* pObj )
 *	@param[in]		pObj						IuWFNg\
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			v~eBu`
 ******************************************************************************/
int CDLGraph::DrawPrimitiveUP( SD3DOBJECT* pObj )
{
	HRESULT hr = D3D_OK;

	// Xe[g̐ݒ
	hr = m_vState[ pObj->m_eState ]->Apply();
	// eNX`̐ݒ
	for( int i = 0; i < FVFTEX_MAX; i++ )
		hr = m_lpD3DDev->SetTexture( i, ( pObj->m_nMatNum[ i ] >= 0 ) ? m_vD3DTex[ pObj->m_nMatNum[ i ] ].m_lpD3DTex : NULL );
	// _Xg[̐錾ݒ
	hr = m_lpD3DDev->SetFVF( D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX8 );
	SD3DDATA* pData = static_cast<SD3DDATA*>( pObj->m_pObj );
	// v~eBu`
	hr = m_lpD3DDev->DrawPrimitiveUP( D3DPT_TRIANGLEFAN,
									  pData->m_nDataMax - 2,
									  pData->m_pData,
									  sizeof( SD3DVERTEX ) );
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DrawText( SD3DOBJECT* pObj )
 *	@param[in]		pObj						IuWFNg\
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			eLXg`
 ******************************************************************************/
int CDLGraph::DrawText( SD3DOBJECT *pObj )
{
	HRESULT hr = D3D_OK;
	SD3DFONT &vFont = m_vD3DFont[ pObj->m_nMatNum[ 0 ] ];
	SD3DTEXT *pText = static_cast<SD3DTEXT*>( pObj->m_pObj );
	// eLXg̕`
	if( vFont.m_lpD3DFont != NULL )
		hr = vFont.m_lpD3DFont->DrawText( NULL,
										  pText->m_szStr,
										  -1,
										  &pText->m_reRect,
										  DT_LEFT | DT_EXPANDTABS,
										  pText->m_dwColor );
	return TRUE;
}

/*******************************************************************************
 *	@fn				CDLGraph::CDLGraph( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLGraph::CDLGraph( void )
	: m_lpD3D( NULL )
	, m_lpD3DDev( NULL )

	, m_pDLShow( NULL )

	, m_hWnd()
	, m_SGraph()
	, m_D3DPP()
	, m_D3DDM()
	, m_D3DVP()
{
	// Xe[g
	m_vState.reserve( ED3DSTATE_MAX );
	m_vState.clear();
	// `e[u
	m_vTable.clear();
	// e̐ݒAz񏉊
	m_vD3DTex.reserve( TEXTURE_MAX );
	m_vD3DTex.clear();
	m_vD3DFont.reserve( FONT_MAX );
	m_vD3DFont.clear();
	m_vD3DObj.reserve( OBJECT_MAX );
	m_vD3DObj.clear();
}

/*******************************************************************************
 *	@fn				CDLGraph::~CDLGraph( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLGraph::~CDLGraph( void )
{
	End();
}

/*******************************************************************************
 *	@fn				void CDLGraph::SetGraph( const SDLGRAPH& SGraph )
 *	@param[in]		SGraph						\
 *	@retval			none						Ȃ
 *	@brief			ZbgAbv\̐ݒ
 ******************************************************************************/
void CDLGraph::SetGraph( const SDLGRAPH& SGraph )
{
	m_SGraph = SGraph;
}

/*******************************************************************************
 *	@fn				int CDLGraph::Init( const HWND& hWnd )
 *	@param[in]		hWnd						EChEnh
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLGraph::Init( const HWND& hWnd )
{
	return Init( hWnd, m_SGraph.m_nWidth, m_SGraph.m_nHeight, m_SGraph.m_bMode );
}

/*******************************************************************************
 *	@fn				int CDLGraph::Init( const HWND& hWnd,
 *									    const int& nWidth,
 *										const int& nHeight,
 *										const BOOL& bMode )
 *	@param[in]		hWnd						EChEnh
 *	@param[in]		nWidth						EChE
 *	@param[in]		nHeight						EChE
 *	@param[in]		bMode						EChE[hiTRUE=EChE/FALSE=tXN[j
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLGraph::Init( const HWND& hWnd,
				    const int& nWidth,
					const int& nHeight,
					const BOOL& bMode )
{
	m_hWnd = hWnd;
	HRESULT hr = D3D_OK;

	// IDirect3D9 C^[tFCX̎擾
	// http://msdn.microsoft.com/ja-jp/library/cc324303.aspx
	m_lpD3D = ::Direct3DCreate9( D3D_SDK_VERSION );
	if( m_lpD3D == NULL )
	{
		DXTRACE_MSG( "Direct3DCreate9()" );
		return FALSE;
	}

	// foCX\̂̏
	::ZeroMemory( &m_D3DPP, sizeof( D3DPRESENT_PARAMETERS ) );

	// ݂̉ʃ[h擾܂
	// http://msdn.microsoft.com/ja-jp/library/cc324298.aspx
	hr = m_lpD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &m_D3DDM );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "GetAdapterDisplayMode()", hr );
		return FALSE;
	}

	// foCX\̂̐ݒ
	// http://msdn.microsoft.com/ja-jp/library/cc323931.aspx
	m_D3DPP.Windowed			= bMode;
	m_D3DPP.SwapEffect			= D3DSWAPEFFECT_DISCARD;
	m_D3DPP.BackBufferFormat	= m_D3DDM.Format;
	m_D3DPP.BackBufferWidth		= nWidth;
	m_D3DPP.BackBufferHeight	= nHeight;
	m_D3DPP.BackBufferCount		= 1;

	// ^C}[x̍ŏPʂ 1ms ɐݒ
	::timeBeginPeriod( 1 );

	// foCX̊mF
	hr = m_lpD3D->CheckDeviceType( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, m_D3DPP.BackBufferFormat, m_D3DPP.BackBufferFormat, FALSE );
	if( FAILED( hr ) )
		DXTRACE_ERR( "CheckDeviceType()", hr );

	// IDirect3Device9 C^[tFCX̎擾
	// http://msdn.microsoft.com/ja-jp/library/cc324295.aspx
	// HAL + HARDWARE
	hr = m_lpD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, m_hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED, &m_D3DPP, &m_lpD3DDev );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "CreateDevice()", hr );
		// HAL + SOFTWARE
		hr = m_lpD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, m_hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED, &m_D3DPP, &m_lpD3DDev );
		if( FAILED( hr ) )
		{
			// REF + SOFTWARE ͎gpȂ
			DXTRACE_ERR( "CreateDevice()", hr );
			return FALSE;
		}
	}

	// r[|[g̐ݒ
	if( !SetViewPort( nWidth, nHeight ) )
		return FALSE;

	// Xe[g̓o^
	EntryState();

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::End( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			I
 ******************************************************************************/
int CDLGraph::End( void )
{
	// \[X
	Cleanup();

	// Xe[gNA
	m_vState.clear();
	// `e[uNA
	m_vTable.clear();
	// zNA
	m_vD3DTex.clear();
	m_vD3DFont.clear();
	m_vD3DObj.clear();

	// IDirect3Device9 C^[tFCX̉
	_RELEASE( m_lpD3DDev );
	// IDirect3D9 C^[tFCX̉
	_RELEASE( m_lpD3D );

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::Update( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʍXV
 ******************************************************************************/
int CDLGraph::Update( void )
{
	HRESULT hr = D3D_OK;

	// V[̃NA
	hr = m_lpD3DDev->Clear( 0,
							NULL,
							D3DCLEAR_TARGET,
							D3DCOLOR_ARGB( 0x00, 0x00, 0x00, 0x00 ),
							1.0f,
							0 );
	if( FAILED( hr ) )
	{
		DXTRACE_ERR( "Clear()", hr );
		return FALSE;
	}

	// V[̕`Jn
	hr = m_lpD3DDev->BeginScene();
	if( SUCCEEDED( hr ) )
	{
		// V[̕`
		std::multiset<CD3DTable>::iterator it = m_vTable.begin();
		while( it != m_vTable.end() )
		{
			SD3DOBJECT *vObj = (*it).m_pObj;

			// IuWFNgȂꍇ͎gpȂ
			if( vObj->m_eObj == EOBJECT_NULL ){ it++; continue; }
			// gpĂȂꍇ͕`悵Ȃ
			if( !vObj->m_bUsed ){ it++; continue; }
			// `悪LɂȂĂȂꍇ͕`悵Ȃ
			if( vObj->m_eDraw != ED3DDRAW_ON ){ it++; continue; }

			// IuWFNg`
			( this->*StepDraw[ vObj->m_eObj - EOBJECT_GRAPHSTART ] )( vObj );

			it++;
		}

		// V[̕`I
		m_lpD3DDev->EndScene();
	}

	// V[̕\
	hr = m_lpD3DDev->Present( NULL, NULL, NULL, NULL );
	// foCX̕
	if( !DeviceRestore( hr ) )
	{
		DXTRACE_ERR( "DeviceRestore()", hr );
		return FALSE;
	}

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::ChangeDisplay( const int& nPosX,
 *												 const int& nPosY,
 *												 const int& nWidth,
 *												 const int& nHeight,
 *												 const BOOL& bMode )
 *	@param[in]		nPosX						EChEwW
 *	@param[in]		nPosY						EChExW
 *	@param[in]		nWidth						EChE
 *	@param[in]		nHeight						EChE
 *	@param[in]		bMode						EChE[h
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			ʐ؂ւ
 ******************************************************************************/
int CDLGraph::ChangeDisplay( const int& nPosX,
							 const int& nPosY,
							 const int& nWidth,
							 const int& nHeight,
							 const BOOL& bMode )
{
	HRESULT hr = D3D_OK;

	// \TCY̐ݒ
	m_D3DPP.BackBufferWidth		= nWidth;
	m_D3DPP.BackBufferHeight	= nHeight;
	// rfI[hݒ
	m_D3DPP.Windowed			= bMode;

	// \[X
	Cleanup();
	// ʂ̐؂ւ
	hr = m_lpD3DDev->Reset( &m_D3DPP );
	// č\z
	Reconstruct();

	// EChE[h̏ꍇAWS_EX_TOPMOST͂
	if( bMode )
		::SetWindowPos( m_hWnd, HWND_NOTOPMOST, nPosX, nPosY, nWidth, nHeight, SWP_SHOWWINDOW );

	// r[|[g̐ݒ
	if( !SetViewPort( nWidth, nHeight ) )
		return FALSE;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::SetDLShow( void* pDLShow )
 *	@param[in]		pDLShow						DLShow̃NX
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			DLShow̃NXݒ
 ******************************************************************************/
int CDLGraph::SetDLShow( void* pDLShow )
{
	m_pDLShow = static_cast<CDLShow*>( pDLShow );
	return TRUE;
}

/*******************************************************************************
 *	@fn				SD3DTEXTURE* CDLGraph::GetTexture( const int& nNum )
 *	@param[in]		int							eNX`ԍ
 *	@retval			SD3DTEXTURE*				eNX`
 *	@brief			eNX`擾
 ******************************************************************************/
SD3DTEXTURE* CDLGraph::GetTexture( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DTex.size() ) && "GetTexture()" );
	return &m_vD3DTex[ nNum ];
}

/*******************************************************************************
 *	@fn				SD3DFONT* CDLGraph::GetFont( const int& nNum )
 *	@param[in]		int							tHgԍ
 *	@retval			SD3DFONT*					tHg
 *	@brief			tHg擾
 ******************************************************************************/
SD3DFONT* CDLGraph::GetFont( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DFont.size() ) && "GetFont()" );
	return &m_vD3DFont[ nNum ];
}

/*******************************************************************************
 *	@fn				SD3DOBJECT* CDLGraph::GetObject( const int& nNum )
 *	@param[in]		int							IuWFNgԍ
 *	@retval			SD3DOBJECT*					IuWFNg
 *	@brief			IuWFNg擾
 ******************************************************************************/
SD3DOBJECT* CDLGraph::GetObject( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DObj.size() ) && "GetObject()" );
	return &m_vD3DObj[ nNum ];
}

/*******************************************************************************
 *	@fn				int CDLGraph::LoadTex( const LPBYTE& lpBuf,
 *										   const int& nSize,
 *										   const int& nWidth,
 *										   const int& nHeight )
 *	@param[in]		lpBuf						̃|C^(RGBA)
 *	@param[in]		nSize						̃TCY
 *	@param[in]		nWidth						
 *	@param[in]		nHeight						
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			eNX`̐VK쐬
 ******************************************************************************/
int CDLGraph::LoadTex( const LPBYTE& lpBuf,
					   const int& nSize,
					   const int& nWidth,
					   const int& nHeight )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE STex;

	STex.m_eTex = ED3DTEX_TEXTURE;
	STex.m_szName = "Create";
	STex.m_nSize = nSize;
	// f[^o^
	STex.m_byData = new BYTE[ STex.m_nSize ];
	::memcpy_s( STex.m_byData, STex.m_nSize, lpBuf, STex.m_nSize );

	// eNX`̍쐬
	hr = D3DXCreateTexture(
			m_lpD3DDev,
			nWidth,
			nHeight,
			D3DX_DEFAULT,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			&STex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		_MEMCHECK( STex.m_byData );
		DXTRACE_MSG( "D3DXCreateTexture()" );
		return -1;
	}
	// \[X擾
	hr = STex.m_lpD3DTex->GetLevelDesc( 0, &STex.m_D3DDesc );
	if( FAILED( hr ) )
	{
		_MEMCHECK( STex.m_byData );
		DXTRACE_MSG( "GetLevelDesc()" );
		return -1;
	}
	// eNX`ɏ
	int nW = ( ( nWidth + 3 ) & 0xFFFFFFFC );
	int nH = nHeight;
	D3DLOCKED_RECT TexRect;
	STex.m_lpD3DTex->LockRect( 0, &TexRect, NULL, 0 );
	BYTE *pData = static_cast<BYTE*>( TexRect.pBits );
	for( int i = 0; i < nH; i++ )
		for( int j = 0; j < TexRect.Pitch; j++ )
			pData[ i * TexRect.Pitch + j ] = lpBuf[ i * TexRect.Pitch + j ];
	STex.m_lpD3DTex->UnlockRect( 0 );

	// eNX`ǉ
	m_vD3DTex.push_back( STex );
	return ( m_vD3DTex.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLGraph::LoadBmp( const LPSTR& szName )
 *	@param[in]		szName						t@C
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			摜ǂݍ
 ******************************************************************************/
int CDLGraph::LoadBmp( const LPSTR& szName )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE STex;

	STex.m_eTex = ED3DTEX_FILE;
	STex.m_szName = szName;

	// eNX`̐ݒ
	// 摜̓ǂݍ
	hr = D3DXCreateTextureFromFileEx(
			m_lpD3DDev,
			STex.m_szName,
			D3DX_DEFAULT_NONPOW2,
			D3DX_DEFAULT_NONPOW2,
			D3DFMT_FROM_FILE,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			0,
			NULL,
			NULL,
			&STex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateTextureFromFileEx()" );
		return -1;
	}
	// \[X擾
	hr = STex.m_lpD3DTex->GetLevelDesc( 0, &STex.m_D3DDesc );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "GetLevelDesc()" );
		return -1;
	}

	// eNX`ǉ
	m_vD3DTex.push_back( STex );
	return ( m_vD3DTex.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLGraph::LoadMem( const LPBYTE& lpBuf,
 *										   const int& nSize )
 *	@param[in]		lpBuf						̃|C^
 *	@param[in]		nSize						̃TCY
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			ǂݍ
 ******************************************************************************/
int CDLGraph::LoadMem( const LPBYTE& lpBuf,
					   const int& nSize )
{
	HRESULT hr = D3D_OK;
	SD3DTEXTURE STex;

	STex.m_eTex = ED3DTEX_MEMORY;
	STex.m_szName = "Memory";
	STex.m_nSize = nSize;
	// f[^o^
	STex.m_byData = new BYTE[ STex.m_nSize ];
	::memcpy_s( STex.m_byData, STex.m_nSize, lpBuf, STex.m_nSize );

	// 񂩂̃eNX`쐬
	hr = D3DXCreateTextureFromFileInMemoryEx(
			m_lpD3DDev,
			STex.m_byData,
			STex.m_nSize,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			D3DX_DEFAULT,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			D3DX_FILTER_LINEAR,
			D3DX_FILTER_LINEAR,
			0,
			NULL,
			NULL,
			&STex.m_lpD3DTex );
	if( FAILED( hr ) )
	{
		_MEMCHECK( STex.m_byData );
		DXTRACE_MSG( "D3DXCreateTextureFromFileInMemoryEx()" );
		return -1;
	}
	// \[X擾
	hr = STex.m_lpD3DTex->GetLevelDesc( 0, &STex.m_D3DDesc );
	if( FAILED( hr ) )
	{
		_MEMCHECK( STex.m_byData );
		DXTRACE_MSG( "GetLevelDesc()" );
		return -1;
	}

	// eNX`ǉ
	m_vD3DTex.push_back( STex );
	return ( m_vD3DTex.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLGraph::LoadBmp( const LPSTR& szName,
 *										   const int& nHeight 
 *	@param[in]		szName						tHg
 *	@param[in]		nHeight						
 *	@retval			int							fޔԍ(-1FError)
 *	@brief			tHg쐬
 ******************************************************************************/
int CDLGraph::LoadFont( const LPSTR& szName,
						const int& nHeight )
{
	HRESULT hr = D3D_OK;
	SD3DFONT SFont;

	SFont.m_szName = szName;
	SFont.m_nHeight = nHeight;

	// tHg̐ݒ
	hr = D3DXCreateFont(
			m_lpD3DDev,
			SFont.m_nHeight,
			0,
			FW_NORMAL,
			0,
			FALSE,
			SHIFTJIS_CHARSET,
			OUT_DEFAULT_PRECIS,
			DEFAULT_QUALITY,
			DEFAULT_PITCH | FF_ROMAN,
			SFont.m_szName,
			&SFont.m_lpD3DFont );
	if( FAILED( hr ) )
	{
		DXTRACE_MSG( "D3DXCreateFont()" );
		return -1;
	}

	// tHgǉ
	m_vD3DFont.push_back( SFont );
	return ( m_vD3DFont.size() - 1 );
}

/*******************************************************************************
 *	@fn				int CDLGraph::RemoveTex( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			eNX`
 ******************************************************************************/
int CDLGraph::RemoveTex( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DTex.size() ) && "RemoveTex()" );

	SD3DTEXTURE &vTex = m_vD3DTex[ nNum ];

	// 
	vTex.m_szName = "";
	_MEMCHECK( vTex.m_byData );
	if( vTex.m_eTex != ED3DTEX_MOVIE )
	{
		_RELEASE( vTex.m_lpD3DTex );
	}else
		vTex.m_lpD3DTex = NULL;
	// 
	SD3DTEXTURE n;
	vTex = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::RemoveBmp( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			摜
 ******************************************************************************/
int CDLGraph::RemoveBmp( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DTex.size() ) && "RemoveBmp()" );
	return RemoveTex( nNum );
}

/*******************************************************************************
 *	@fn				int CDLGraph::RemoveMem( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLGraph::RemoveMem( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DTex.size() ) && "RemoveMem()" );
	return RemoveTex( nNum );
}

/*******************************************************************************
 *	@fn				int CDLGraph::RemoveFont( const int& nNum )
 *	@param[in]		nNum						fޔԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			tHg
 ******************************************************************************/
int CDLGraph::RemoveFont( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DFont.size() ) && "RemoveFont()" );

	SD3DFONT &vFont = m_vD3DFont[ nNum ];

	// 
	_RELEASE( vFont.m_lpD3DFont );

	// 
	SD3DFONT n;
	vFont = n;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::RemoveALL( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			fޑS
 ******************************************************************************/
int CDLGraph::RemoveALL( void )
{
	int nMax;
	// fމieNX`j
	nMax = static_cast<int>( m_vD3DTex.size() );
	for( int i = 0; i < nMax; i++ )
		RemoveTex( i );
	m_vD3DTex.clear();
	// fމitHgj
	nMax = static_cast<int>( m_vD3DFont.size() );
	for( int i = 0; i < nMax; i++ )
		RemoveFont( i );
	m_vD3DFont.clear();
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::AddRect( const int& nPrio,
 *										   const int (&nMatNum)[ FVFTEX_MAX ],
 *										   const ED3DDRAW& eDraw,
 *										   const ED3DSTATE& eState,
 *										   const RECT& rcRect,
 *										   const int& nColor )
 *	@param[in]		nPrio						`D揇
 *	@param[in]		nMatNum						fޔԍ
 *	@param[in]		eDraw						`
 *	@param[in]		eState						`Xe[g
 *	@param[in]		rcRect						`W
 *	@param[in]		nColor						_F
 *	@retval			int							IuWFNgԍ
 *	@brief			`ǉ
 ******************************************************************************/
int CDLGraph::AddRect( const int& nPrio,
					   const int (&nMatNum)[ FVFTEX_MAX ],
					   const ED3DDRAW& eDraw,
					   const ED3DSTATE& eState,
					   const RECT& rcRect,
					   const int& nColor )
{
	SD3DOBJECT SObj;

	// {o^
	SObj.m_bUsed = TRUE;
	SObj.m_eObj = EOBJECT_RECT;
	SObj.m_nPrio = nPrio;
	// fޔԍo^
	for( int i = 0; i < FVFTEX_MAX; i++ )
		SObj.m_nMatNum[ i ] = nMatNum[ i ];
	// `o^
	SObj.m_eDraw = eDraw;
	SObj.m_eState = eState;
	// f[^o^
	SObj.m_pObj = new SD3DDATA[ sizeof( SD3DDATA ) ];
	SD3DDATA *pData = static_cast<SD3DDATA*>( SObj.m_pObj );

	pData->m_nDataMax = 4;
	pData->m_pData = new SD3DVERTEX[ pData->m_nDataMax * sizeof( SD3DVERTEX ) ];

	SD3DVERTEX v[ 4 ] =
	{
		{ static_cast<float>( rcRect.left  ), static_cast<float>( rcRect.top    ), 0.0f, 1.0f, nColor, 0.0f, 0.0f },			// 
		{ static_cast<float>( rcRect.right ), static_cast<float>( rcRect.top    ), 0.0f, 1.0f, nColor, 1.0f, 0.0f },			// E
		{ static_cast<float>( rcRect.right ), static_cast<float>( rcRect.bottom ), 0.0f, 1.0f, nColor, 1.0f, 1.0f },			// E
		{ static_cast<float>( rcRect.left  ), static_cast<float>( rcRect.bottom ), 0.0f, 1.0f, nColor, 0.0f, 1.0f },			// 
	};
	for( int i = 0; i < FVFTEX_MAX; i++ )
	{
		v[ 0 ].tex[ i ].tu = 0.0f; v[ 0 ].tex[ i ].tv = 0.0f; 
		v[ 1 ].tex[ i ].tu = 1.0f; v[ 1 ].tex[ i ].tv = 0.0f; 
		v[ 2 ].tex[ i ].tu = 1.0f; v[ 2 ].tex[ i ].tv = 1.0f; 
		v[ 3 ].tex[ i ].tu = 0.0f; v[ 3 ].tex[ i ].tv = 1.0f; 
	}

	for( int i = 0; i < pData->m_nDataMax; i++ )
		pData->m_pData[ i ] = v[ i ];

	// IuWFNgǉ
	m_vD3DObj.push_back( SObj );
	int nNum = m_vD3DObj.size() - 1;
	// e[uǉ
	m_vTable.insert( CD3DTable( SObj.m_nPrio, &m_vD3DObj[ nNum ] ) );
	return nNum;
}

/*******************************************************************************
 *	@fn				int CDLGraph::AddVertex( const int& nPrio,
 *											 const int (&nMatNum)[ FVFTEX_MAX ],
 *											 const ED3DDRAW& eDraw,
 *											 const ED3DSTATE& eState,
 *											 const int& nVertex,
 *											 const SD3DVERTEX* SVertex )
 *	@param[in]		nPrio						`D揇
 *	@param[in]		nMatNum						fޔԍ
 *	@param[in]		eDraw						`
 *	@param[in]		eState						`Xe[g
 *	@param[in]		nVertex						_
 *	@param[in]		SVertex						_
 *	@retval			int							IuWFNgԍ
 *	@brief			ʒǉ
 ******************************************************************************/
int CDLGraph::AddVertex( const int& nPrio,
						 const int (&nMatNum)[ FVFTEX_MAX ],
						 const ED3DDRAW& eDraw,
						 const ED3DSTATE& eState,
						 const int& nVertex,
						 const SD3DVERTEX* SVertex )
{
	SD3DOBJECT SObj;

	// {o^
	SObj.m_bUsed = TRUE;
	SObj.m_eObj = EOBJECT_VERTEX;
	SObj.m_nPrio = nPrio;
	// fޔԍo^
	for( int i = 0; i < FVFTEX_MAX; i++ )
		SObj.m_nMatNum[ i ] = nMatNum[ i ];
	// `o^
	SObj.m_eDraw = eDraw;
	SObj.m_eState = eState;
	// f[^o^
	SObj.m_pObj = new SD3DDATA[ sizeof( SD3DDATA ) ];
	SD3DDATA *pData = static_cast<SD3DDATA*>( SObj.m_pObj );

	pData->m_nDataMax = nVertex;
	pData->m_pData = new SD3DVERTEX[ pData->m_nDataMax * sizeof( SD3DVERTEX ) ];

	for( int i = 0; i < pData->m_nDataMax; i++ )
		pData->m_pData[ i ] = SVertex[ i ];

	// IuWFNgǉ
	m_vD3DObj.push_back( SObj );
	int nNum = m_vD3DObj.size() - 1;
	// e[uǉ
	m_vTable.insert( CD3DTable( SObj.m_nPrio, &m_vD3DObj[ nNum ] ) );
	return nNum;
}

/*******************************************************************************
 *	@fn				int CDLGraph::AddText( const int& nPrio,
 *										   const int (&nMatNum)[ FVFTEX_MAX ],
 *										   const ED3DDRAW& eDraw,
 *										   const RECT& rcRect,
 *										   const int& nColor,
 *										   const LPSTR& lpStr )
 *	@param[in]		nPrio						`D揇
 *	@param[in]		nMatNum						fޔԍ
 *	@param[in]		eDraw						`
 *	@param[in]		rcRect						`W
 *	@param[in]		nColor						F
 *	@param[in]		lpStr						
 *	@retval			int							IuWFNgԍ
 *	@brief			eLXgǉ
 ******************************************************************************/
int CDLGraph::AddText( const int& nPrio,
					   const int (&nMatNum)[ FVFTEX_MAX ],
					   const ED3DDRAW& eDraw,
					   const RECT& rcRect,
					   const int& nColor,
					   const LPSTR& lpStr )
{
	SD3DOBJECT SObj;

	// gp
	if( nMatNum[ 0 ] == -1 ) return -1;

	// {o^
	SObj.m_bUsed = TRUE;
	SObj.m_eObj = EOBJECT_TEXT;
	SObj.m_nPrio = nPrio;
	// fޔԍo^
	for( int i = 0; i < FVFTEX_MAX; i++ )
		SObj.m_nMatNum[ i ] = nMatNum[ i ];
	// `o^
	SObj.m_eDraw = eDraw;
	SObj.m_eState = ED3DSTATE_NORMAL;
	// f[^o^
	SObj.m_pObj = new SD3DTEXT[ sizeof( SD3DTEXT ) ];
	SD3DTEXT *pText = static_cast<SD3DTEXT*>( SObj.m_pObj );

	pText->m_reRect = rcRect;
	pText->m_dwColor = D3DCOLOR_XRGB( ( nColor & 0x00FF0000 ) >> 16,
									  ( nColor & 0x0000FF00 ) >>  8,
									  ( nColor & 0x000000FF ) >>  0 );
	pText->m_szStr = lpStr;

	// IuWFNgǉ
	m_vD3DObj.push_back( SObj );
	int nNum = m_vD3DObj.size() - 1;
	// e[uǉ
	m_vTable.insert( CD3DTable( SObj.m_nPrio, &m_vD3DObj[ nNum ] ) );
	return nNum;
}

/*******************************************************************************
 *	@fn				int CDLGraph::Del( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNg폜
 ******************************************************************************/
int CDLGraph::Del( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DObj.size() ) && "Del()" );

	SD3DOBJECT &vObj = m_vD3DObj[ nNum ];

	// gp
	if( !vObj.m_bUsed ) return FALSE;

	// e[u폜
	std::multiset<CD3DTable>::iterator it = m_vTable.find( CD3DTable( vObj.m_nPrio, &vObj ) );
	m_vTable.erase( it );

	// IuWFNg폜
	if( !( this->*StepDel[ vObj.m_eObj - EOBJECT_GRAPHSTART ] )( nNum ) )
		return FALSE;
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::DelALL( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNgS폜
 ******************************************************************************/
int CDLGraph::DelALL( void )
{
	int nMax;
	// IuWFNg폜
	nMax = static_cast<int>( m_vD3DObj.size() );
	for( int i = 0; i < nMax; i++ )
		Del( i );
	m_vD3DObj.clear();
	// e[uNA
	m_vTable.clear();
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::Connect( const int& nNum1,
 *										   const int& nNum2 )
 *	@param[in]		nNum1						ÕIuWFNgԍ
 *	@param[in]		nNum2						̃IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNgm̐ڑ
 ******************************************************************************/
int CDLGraph::Connect( const int& nNum1,
					   const int& nNum2 )
{
	_ASSERT( nNum1 < static_cast<int>( m_vD3DObj.size() ) && "Connect()" );
	_ASSERT( nNum2 < static_cast<int>( m_vD3DObj.size() ) && "Connect()" );

	SD3DOBJECT &vObj1 = m_vD3DObj[ nNum1 ];
	SD3DOBJECT &vObj2 = m_vD3DObj[ nNum2 ];

	if( vObj1.m_pNext != NULL )
	{
		vObj1.m_pNext->m_pPrev = &vObj2;
		vObj2.m_pNext = vObj1.m_pNext;
	}
	vObj1.m_pNext = &vObj2;
	vObj2.m_pPrev = &vObj1;

	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLGraph::Disconnect( const int& nNum )
 *	@param[in]		nNum						IuWFNgԍ
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			IuWFNgm̐ؒf
 ******************************************************************************/
int CDLGraph::Disconnect( const int& nNum )
{
	_ASSERT( nNum < static_cast<int>( m_vD3DObj.size() ) && "Disconnect()" );

	SD3DOBJECT &vObj = m_vD3DObj[ nNum ];

	if( vObj.m_pPrev != NULL )
		vObj.m_pPrev->m_pNext = vObj.m_pNext;
	if( vObj.m_pNext != NULL )
		vObj.m_pNext->m_pPrev = vObj.m_pPrev;
	vObj.m_pPrev = NULL;
	vObj.m_pNext = NULL;

	return TRUE;
}

}	// namespace	DL
