/*******************************************************************************
 *	@file			DLDebug.h
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			29-May-2010(Sat)
 ******************************************************************************/

#ifndef	__DLDEBUG_INCLUDE__
#define	__DLDEBUG_INCLUDE__

// vvZbT---------------------------------------------------------------
#include "DL.h"
#include "DLGraph.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// 萔`---------------------------------------------------------------------
#pragma once

// 񋓌^`-------------------------------------------------------------------
/*******************************************************************************
 *	@enum		EDDMETER		DLDebug.h		"DLDebug.h"
 *	@brief		v
 ******************************************************************************/
enum EDDMETER
{
	EDDMETER_PROGRAM		= 0,												//!< vO
	EDDMETER_MOVIE,																//!< 揈
	EDDMETER_LIBRARY,															//!< Cu
	EDDMETER_SYNC,																//!< 
	EDDMETER_PARAM0,															//!< ėpO
	EDDMETER_PARAM1,															//!< ėpP
	EDDMETER_PARAM2,															//!< ėpQ
	EDDMETER_PARAM3,															//!< ėpR
	EDDMETER_PARAM4,															//!< ėpS
	EDDMETER_MAX,
};

// \̒`-------------------------------------------------------------------

// NX-----------------------------------------------------------------------
/*******************************************************************************
 *	@class		CDLDebug		DLDebug.h			"DLDebug.h"
 *	@brief		CDLDebugNX
 ******************************************************************************/
class CDLDebug
{
// 萔`---------------------------------------------------------------------
private:
protected:
public:
	static const int LOG_MAX		= 64;										//!< O

// o֐-------------------------------------------------------------------
private:
protected:
public:
	CDLDebug( void );
	~CDLDebug( void );

	int Init( void );															//!< 
	int End( void );															//!< I

	// vl
	void ClearMeasure( void );													//!< vlNA
	void SetMeasure( const int& nNum );											//!< vlݒ
	const float GetMeasure( const int& nNum );									//!< vl擾

	// O
	void ClearLog( void );														//!< ONA
	void SetLog( const char* cLog );											//!< Oݒ
	const std::string GetLog( const int& nNum );								//!< O擾
	const int& GetLogCnt( void ) const { return m_nLogCnt; }					//!< OJEg擾

// oϐ-------------------------------------------------------------------
private:
	LARGE_INTEGER			m_lnBase;											//!< v̓y
	LARGE_INTEGER			m_lnMeter[ EDDMETER_MAX ][ 2 ];						//!< v
	int						m_nMeterNum;										//!< v
	BOOL					m_bMeterFlag;										//!< vJE^[

	std::vector<std::string>	m_vLog;											//!< O
	int						m_nLogCnt;											//!< OJEg

protected:
public:

};

// OO[oϐ-----------------------------------------------------------

// O֐vg^Cv錾-----------------------------------------------------

}	// namespace	DL

#ifdef __cplusplus
}
#endif

#endif	// __DLDEBUG_INCLUDE__
