/*******************************************************************************
 *	@file			DLDebug.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			29-May-2010(Sat)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DLDebug.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				CDLDebug::CDLDebug( void )
 *	@retval			none						Ȃ
 *	@brief			RXgN^
 ******************************************************************************/
CDLDebug::CDLDebug( void )
	: m_nMeterNum( 0 )
	, m_bMeterFlag( FALSE )
	, m_nLogCnt( 0 )
{
#ifdef _DEBUG
	ClearMeasure();
	ClearLog();
	// e̐ݒAz񏉊
	m_vLog.reserve( LOG_MAX );
	m_vLog.assign( LOG_MAX, "" );
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				CDLGraph::~CDLGraph( void )
 *	@retval			none						Ȃ
 *	@brief			fXgN^
 ******************************************************************************/
CDLDebug::~CDLDebug( void )
{
#ifdef _DEBUG
	m_vLog.clear();
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				int CDLDebug::Init( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
int CDLDebug::Init( void )
{
#ifdef _DEBUG
	m_bMeterFlag = ::QueryPerformanceFrequency( &m_lnBase );

#endif	// _DEBUG
	return TRUE;
}

/*******************************************************************************
 *	@fn				int CDLDebug::End( void )
 *	@retval			int							TRUE=OK/FALSE=NG
 *	@brief			I
 ******************************************************************************/
int CDLDebug::End( void )
{
#ifdef _DEBUG
#endif	// _DEBUG
	return TRUE;
}

/*******************************************************************************
 *	@fn				void CDLDebug::ClearMeasure( void )
 *	@retval			none						Ȃ
 *	@brief			vlNA
 ******************************************************************************/
void CDLDebug::ClearMeasure( void )
{
#ifdef _DEBUG
	// v
	for( int i = 0; i < EDDMETER_MAX; i++ )
		for( int j = 0; j < 2; j++ )
			m_lnMeter[ i ][ j ].QuadPart = 0;
	m_nMeterNum = 0;
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				void CDLDebug::SetMeasure( const int& nNum )
 *	@param[in]		nNum						擾ԍ
 *	@retval			none						Ȃ
 *	@brief			vlݒ
 *					OFvO
 *					PFCu
 *					QF
 *					R`VFėp
 ******************************************************************************/
void CDLDebug::SetMeasure( const int& nNum )
{
#ifdef _DEBUG
	int nMeterNum = nNum;
	_ASSERT( ( -1 < nMeterNum && nMeterNum < EDDMETER_MAX ) && "Measurement()" );
	// vJn
	if( m_lnMeter[ nMeterNum ][ 0 ].QuadPart == 0 )
	{
		::QueryPerformanceCounter( &m_lnMeter[ nMeterNum ][ 0 ] );
	}else
	// vI
	{
		::QueryPerformanceCounter( &m_lnMeter[ nMeterNum ][ 1 ] );
	}
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				const float CDLDebug::GetMeasure( const int& nNum )
 *	@param[in]		nNum						擾ԍ
 *	@retval			float						fTime
 *	@brief			vl擾
 *					OFvO
 *					PFCu
 *					QF
 *					R`VFėp
 ******************************************************************************/
const float CDLDebug::GetMeasure( const int& nNum )
{
	float fTime = 0.0f;
#ifdef _DEBUG
	_ASSERT( nNum < EDDMETER_MAX && "GetMeasurement()" );

	fTime = static_cast<float>( ( ( m_lnMeter[ nNum ][ 1 ].QuadPart - m_lnMeter[ nNum ][ 0 ].QuadPart ) * 1000 ) / m_lnBase.QuadPart );
	if( fTime < 0.0f ) fTime = 0.0f;
#endif	// _DEBUG
	return fTime;
}

/*******************************************************************************
 *	@fn				void CDLDebug::ClearLog( void )
 *	@retval			none						Ȃ
 *	@brief			ONA
 ******************************************************************************/
void CDLDebug::ClearLog( void )
{
#ifdef _DEBUG
	int nMax = m_vLog.size();
	for( int i = 0; i < nMax; i++ )
		m_vLog[ i ] = "";

	m_nLogCnt = 0;
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				void CDLDebug::SetLog( const char* cLog )
 *	@retval			none						Ȃ
 *	@brief			Oݒ
 ******************************************************************************/
void CDLDebug::SetLog( const char* cLog )
{
#ifdef _DEBUG
	int nCnt = m_nLogCnt % m_vLog.size();
	m_vLog[ nCnt ] = cLog;
	m_nLogCnt++;
#endif	// _DEBUG
}

/*******************************************************************************
 *	@fn				const string* CDLDebug::GetLog( const int& nNum )
 *	@param[in]		nNum						擾ԍ
 *	@retval			string*						ObZ[W
 *	@brief			O擾
 ******************************************************************************/
const std::string CDLDebug::GetLog( const int& nNum )
{
	std::string str;
#ifdef _DEBUG
	int nCnt = nNum % m_vLog.size();
	str = m_vLog[ nCnt ];
#endif	// _DEBUG
	return str;
}

}	// namespace	DL
