/*******************************************************************************
 *	@file			DL.h
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			08-Apr-2009(Wed)
 ******************************************************************************/

#ifndef	__DL_INCLUDE__
#define	__DL_INCLUDE__

// ܂Ȃ
#define STRICT																	//!< ^`FbNɍs
#define	WIN32_LEAN_AND_MEAN														//!< wb_[炠܂gȂ֐Ȃ

// vvZbT---------------------------------------------------------------
//#pragma warning( disable : 4748 )
//#pragma warning( disable : 4995 )

// Windows Library
#pragma comment ( lib, "winmm.lib" )
// DirectX Library
#pragma comment ( lib, "d3d9.lib" )
#ifdef	_DEBUG
	#pragma comment ( lib, "d3dx9d.lib" )
#else	// _DEBUG
	#pragma comment ( lib, "d3dx9.lib" )
#endif	// _DEBUG
#pragma comment ( lib, "dsound.lib" )
#pragma comment ( lib, "dinput8.lib" )
#pragma comment ( lib, "dxguid.lib" )
//#pragma comment ( lib, "dxerr9.lib" )
#pragma comment ( lib, "dxerr.lib" )
// Microsoft SDKs
#pragma comment ( lib, "strmiids.lib" )

// Windows
#include <windows.h>
#include <tchar.h>
#include <assert.h>
#include <mmsystem.h>															//!< timeGetTime()
#include <stdio.h>
// DirectX9
#define DIRECTINPUT_VERSION	0x0800												//!< ꉞŉĂ
#include <d3dx9.h>																//!< Direct3D & Direct3DX
#include <dsound.h>																//!< DirectSound
#include <dinput.h>																//!< DirectInput
//#include <dxerr9.h>																//!< DirectX̃G[
#include <dxerr.h>																//!< DirectX̃G[
// STL
#include <vector>																//!< vector
#include <string>																//!< string
#include <set>																	//!< multiset
// Microsoft SDKs
#include <iostream>
#include <intrin.h>
#include <dshow.h>																//!< DirectShow

// _DXLibv2

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// 萔`---------------------------------------------------------------------
#define EXIT				1
#define TRUE				1
#define FALSE				0

#define _RELEASE( x )		if( x != NULL ){ x->Release(); x = NULL; }
#define _MEMCHECK( m )		if( m != NULL ){ delete[] m; m = NULL; }
/*
#ifdef	_DEBUG
	#define _ASSERT( n )	assert( n );
#else	// _DEBUG
	#define _ASSERT( n )	{}
#endif	// _DEBUG
*/

// 񋓌^`-------------------------------------------------------------------
/*******************************************************************************
 *	@enum		EOBJECT				DL.h			"DL.h"
 *	@brief		IuWFNg
 ******************************************************************************/
enum EOBJECT
{
	EOBJECT_NULL			= 0,												//!< Ȃ
	// DirectX Graphics
	EOBJECT_GRAPHSTART,
	EOBJECT_RECT			= EOBJECT_GRAPHSTART,								//!< `(RECTgp)
	EOBJECT_VERTEX,																//!< 
	EOBJECT_TEXT,																//!< eLXg
	EOBJECT_GRAPHEND,
	// DirectX Sound
	EOBJECT_SOUNDSTART,
	EOBJECT_BGM				= EOBJECT_SOUNDSTART,								//!< BGM
	EOBJECT_SE,																	//!< SE
	EOBJECT_SOUNDEND,
	// 
	EOBJECT_MAX,
};

// \̒`-------------------------------------------------------------------

// NX-----------------------------------------------------------------------

// OO[oϐ-----------------------------------------------------------
typedef void (*CallBack)( BYTE* byKey, DIMOUSESTATE* diMouse );

// O֐vg^Cv錾-----------------------------------------------------
extern void* StartupGraph( const int& nWidth,
						   const int& nHeight,
						   const BOOL& bMode );
extern void* StartupSound( const BOOL& b3DSound );
extern void* StartupInput( void );
extern void* StartupShow( void );
extern void* StartupDebug( void );

extern BOOL Init( const HWND& hWnd,
				  const float& fRate );
extern void Exec( CallBack pCall );
extern void End( void );

}	// namespace	DL

#ifdef __cplusplus
}
#endif

#endif	// __DL_INCLUDE__
