/*******************************************************************************
 *	@file			DL.cpp
 *	@brief			DirectX Library
 *
 *	@author			ohwhsmm7
 *
 *	@date			21-Nov-2010(Sun)
 ******************************************************************************/

// vvZbT---------------------------------------------------------------
#include "DL.h"
#include "DLGraph.h"
#include "DLSound.h"
#include "DLInput.h"
#include "DLShow.h"
#include "DLDebug.h"

/*******************************************************************************
 *	@namespace	DL
 ******************************************************************************/
namespace	DL
{

// O[oϐ-----------------------------------------------------------
DL::CDLGraph			g_CGraph;												//!< DirectX Graphics
DL::CDLSound			g_CSound;												//!< DirectX Sound
DL::CDLInput			g_CInput;												//!< DirectX Input
DL::CDLShow				g_CShow;												//!< DirectX Show
DL::CDLDebug			g_CDebug;

BYTE					g_byKey[ DL::CDLInput::KEYBUFFER_MAX ];
DIMOUSESTATE			g_DIMS;

DWORD					g_dwTimer[ 2 ];											//!< v^C}[
float					g_fDiffTime = 0.0f;										//!< ^C}[
float					g_fFrameRate = ( 30.0f / 1000.0f );						//!< t[[g

// ֐vg^Cv錾-----------------------------------------------------

// -----------------------------------------------------------------------------
/*******************************************************************************
 *	@fn				void* StartupGraph( const int& nWidth,
 *										const int& nHeight,
 *										const BOOL& bMode)
 *	@param[in]		nWidth						EChE
 *	@param[in]		nHeight						EChE
 *	@param[in]		bMode						EChE[hiTRUE=EChE/FALSE=tXN[j
 *	@retval			void*						DL::CDLGraph
 *	@brief			DL::CDLGraph̐ݒ
 ******************************************************************************/
void* StartupGraph( const int& nWidth,
					const int& nHeight,
					const BOOL& bMode )
{
	SDLGRAPH st;
	st.m_nWidth		= nWidth;
	st.m_nHeight	= nHeight;
	st.m_bMode		= bMode;
	g_CGraph.SetGraph( st );
	return reinterpret_cast<void*>( &g_CGraph );
}

/*******************************************************************************
 *	@fn				void* StartupSound( const BOOL& b3DSound )
 *	@param[in]		b3DSound					RcTEhtO
 *	@retval			void*						DL::CDLSound
 *	@brief			DL::CDLSound̐ݒ
 ******************************************************************************/
void* StartupSound( const BOOL& b3DSound )
{
	SDLSOUND st;
	st.m_b3DSound = b3DSound;
	g_CSound.SetSound( st );
	return reinterpret_cast<void*>( &g_CSound );
}

/*******************************************************************************
 *	@fn				void* StartupInput( void )
 *	@retval			void*						DL::CDLInput
 *	@brief			DL::CDLInput̐ݒ
 ******************************************************************************/
void* StartupInput( void )
{
	return reinterpret_cast<void*>( &g_CInput );
}

/*******************************************************************************
 *	@fn				void* StartupShow( void )
 *	@retval			void*						DL::CDLShow
 *	@brief			DL::CDLShow̐ݒ
 ******************************************************************************/
void* StartupShow( void )
{
	return reinterpret_cast<void*>( &g_CShow );
}

/*******************************************************************************
 *	@fn				void* StartupDebug( void )
 *	@retval			void*						DL::CDLDebug
 *	@brief			DL::CDLDebug̐ݒ
 ******************************************************************************/
void* StartupDebug( void )
{
	return reinterpret_cast<void*>( &g_CDebug );
}

/*******************************************************************************
 *	@fn				BOOL Init( const HWND& hWnd,
 *							   const float& fRate )
 *	@param[in]		hWnd						EChEnh
 *	@param[in]		fRate						t[[g
 *	@retval			BOOL						TRUE=OK/FALSE=NG
 *	@brief			
 ******************************************************************************/
BOOL Init( const HWND& hWnd,
		   const float& fRate )
{
	g_fFrameRate = fRate;

	// COM̏
	::CoInitialize( NULL );

	// DLGraph̏
	if( !g_CGraph.Init( hWnd ) ) return FALSE;
	// DLSound̏
	if( !g_CSound.Init( hWnd ) ) return FALSE;
	// DLInput̏
	if( !g_CInput.Init( hWnd ) ) return FALSE;
	// DLShow̏
	if( !g_CShow.Init( hWnd, g_CGraph.GetD3DDevice() ) ) return FALSE;

	// ʐ؂ւp
	g_CGraph.SetDLShow( reinterpret_cast<void*>( &g_CShow ) );

	// fobȌ
	if( !g_CDebug.Init() ) return FALSE;

	// ^C}[
	g_dwTimer[ 0 ] = g_dwTimer[ 1 ] = ::timeGetTime();

	return TRUE;
}

/*******************************************************************************
 *	@fn				void Exec( CallBack pCall )
 *	@param[in]		pCall						R[obN
 *	@retval			none						Ȃ
 *	@brief			
 ******************************************************************************/
void Exec( CallBack pCall )
{
	g_CDebug.ClearMeasure();

	// svO
	g_CDebug.SetMeasure( EDDMETER_PROGRAM );
	// Ԏ擾
	g_CInput.GetState( g_byKey, &g_DIMS );
	if( pCall != NULL ) pCall( g_byKey, &g_DIMS );
	g_CDebug.SetMeasure( EDDMETER_PROGRAM );

	// 揈
	g_CDebug.SetMeasure( EDDMETER_MOVIE );
	// ʍXV
	g_CShow.Update();
	g_CDebug.SetMeasure( EDDMETER_MOVIE );

	// Cu
	g_CDebug.SetMeasure( EDDMETER_LIBRARY );
	// ʍXV
	g_CGraph.Update();
	g_CDebug.SetMeasure( EDDMETER_LIBRARY );

	// v
	g_CDebug.SetMeasure( EDDMETER_SYNC );
	while( 1 )
	{
		g_dwTimer[ 0 ] = ::timeGetTime();
		if( ( g_dwTimer[ 0 ] - g_dwTimer[ 1 ] ) >= g_fFrameRate )
		{
			g_fDiffTime += ( static_cast<float>( ( g_dwTimer[ 0 ] - g_dwTimer[ 1 ] ) ) - g_fFrameRate );
			DWORD dwDiff = static_cast<DWORD>( g_fDiffTime );
			g_fDiffTime -= dwDiff;
			g_dwTimer[ 1 ] = g_dwTimer[ 0 ] - dwDiff;

			// ׂ肷ƋȐlłČvȂ̂
			// t[[g 1.2{̌vlo瓯vZbg
			if( dwDiff >= ( g_fFrameRate * 1.2f ) )
			{
				g_fDiffTime = 0;
				g_dwTimer[ 0 ] = g_dwTimer[ 1 ] = ::timeGetTime();
			}
			break;
		}
		// 1ms ҂
		::Sleep( 1 );
	}
	g_CDebug.SetMeasure( EDDMETER_SYNC );
}

/*******************************************************************************
 *	@fn				void End( void )
 *	@retval			none						Ȃ
 *	@brief			I
 ******************************************************************************/
void End( void )
{
	// IuWFNg폜
	g_CGraph.DelALL();
	g_CSound.DelALL();

	// 
	g_CShow.RemoveALL();
	g_CGraph.RemoveALL();
	g_CSound.RemoveALL();

	// DLDebug̏I
	g_CDebug.End();

	// DLShow̏I
	g_CShow.End();
	// DLInput̏I
	g_CInput.End();
	// DLSound̏I
	g_CSound.End();
	// DLGraph̏I
	g_CGraph.End();

	// COM̏I
	::CoUninitialize();
}

}	// namespace	DL
