package org.dyndns.nuda.profile;

import org.dyndns.nuda.tools.util.StringUtil;

/**
 * シンプルなプロファイラです
 * 
 * @author nkoseki
 * 
 */
public class SimpleProfiler {
	
	/**
	 * アプリケーションの開始から終了までのJavaヒープ領域の空きメモリサイズとターンアラウンド時間を計測し, 結果を
	 * 標準出力へ出力します. <br />
	 */
	public static void reserveProfiler() {
		final long freeMem = Runtime.getRuntime().freeMemory();
		final long time = System.currentTimeMillis();
		Runtime.getRuntime().addShutdownHook(new Thread() {
			
			@Override
			public void run() {
				long freeMemResult = Runtime.getRuntime().freeMemory();
				long endTime = System.currentTimeMillis() - time;
				String message =
					StringUtil.format(
						"before[{}] after[{}] diff[{}] time[{} s]",
						freeMem,
						freeMemResult,
						freeMem - freeMemResult,
						((double) endTime / 1000));
				System.out.println(message);
			}
			
		});
	}
}
