package org.dyndns.nuda.tools.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValidator {
	private static boolean checkCharacterCode(final String str,
			final String encoding) {
		if (str == null) {
			return true;
		}
		Charset charSet = Charset.forName(encoding);
		try {
			byte[] bytes = str.getBytes(charSet);
			return str.equals(new String(bytes, encoding));
		} catch (UnsupportedEncodingException ex) {
			throw new RuntimeException("エンコード名称が正しくありません。", ex);
		}
	}
	
	public static boolean isWindows31j(final String str) {
		return checkCharacterCode(str, "Windows-31j");
	}
	
	public static boolean isSJIS(final String str) {
		return checkCharacterCode(str, "SJIS");
	}
	
	public static boolean isEUC(final String str) {
		return checkCharacterCode(str, "euc-jp");
	}
	
	public static boolean isUTF8(final String str) {
		return checkCharacterCode(str, "UTF-8");
	}
	
	private static String convertHexFromBytes(final byte[] bytes) {
		StringBuilder builder = new StringBuilder();
		
		for (byte b : bytes) {
			builder.append(Integer.toHexString((b & 0xF0) >> 4));
			builder.append(Integer.toHexString(b & 0xF));
		}
		return builder.toString();
	}
	
	public static void main(final String[] args) {
		
		String testStr = "";
		byte[] bytes = testStr.getBytes(Charset.forName("UTF-8"));
		
		StringBuilder builder = new StringBuilder();
		
		for (byte b : bytes) {
			builder.append(Integer.toHexString((b & 0xF0) >> 4));
			builder.append(Integer.toHexString(b & 0xF));
		}
		//System.out.println("==");
		String hex = convertHexFromBytes(bytes);
		
		System.out.println("("
			+ bytes.length
			+ ")binary > \n"
			+ hex
			+ "("
			+ hex.length()
			+ ")");
		
		System.out.println("<<<" + new String(bytes, Charset.forName("UTF-8")));
		//System.out.println("==");
		List<String> lst = new LinkedList<String>();
		for (int i = 0; i < bytes.length; i++) {
			lst.add(Integer.toBinaryString(bytes[i]) + "-");
		}
		
		//convert16dToBin(hex);
		
		//		for (String binStr : lst) {
		//			System.out.print(binStr);
		//			
		//		}
		//System.out.println();
		System.out.println("==");
		System.out.println(">>>>" + convert16dToBin(hex));
		System.out.println("==");
		
		String s = get32DFromStr2(convert16dToBin(hex));
		String s2 = get16DFromStr(lst);
		
		System.out.println("("
			+ s.length()
			+ ")binary > \n"
			+ s
			+ "("
			+ s.length()
			+ ")");
		
		//System.out.println(s);
		//System.out.println(s2);
	}
	
	public static void test02(final String binStr) {
		System.out
			.println("=====================================================================================");
		String testStr = binStr;
		
		List<String> strList = new ArrayList<String>();
		
		for (int i = 0; i < testStr.length(); i++) {
			String s = new Character(testStr.charAt(i)).toString();
			if (s.getBytes().length != 1) {
				throw new RuntimeException("対象文字にマルチバイト文字が含まれています");
			} else {
				strList.add(s);
			}
		}
		
		if (strList.size() == 0 || (strList.size() % 2) != 0) {
			if (strList.size() == 0) {
				throw new RuntimeException("対象文字がありません");
			} else {
				throw new RuntimeException("対象文字が中途半端な長さです。文字長は２の倍数にしてください");
			}
		}
		List<Byte> byteList = new ArrayList<Byte>();
		
		int i = 1;
		int buf = 0;
		for (String ch : strList) {
			
			if (i != 0 && (i % 2) == 0) {
				int buf00 = getCodeFromChar(ch);
				int buf0 = (buf << 4) & 0xF0;
				
				buf = buf00 | buf0;
				
				byteList.add((byte) buf);
				buf = 0;
			} else {
				buf = getCodeFromChar(ch);
			}
			i++;
		}
		
		System.out
			.println("=====================================================================================");
		
		Byte[] bytes000 = byteList.toArray(new Byte[byteList.size()]);
		byte[] result = new byte[bytes000.length];
		StringBuilder b = new StringBuilder();
		List<String> binList = new LinkedList<String>();
		for (int idx = 0; idx < bytes000.length; idx++) {
			b.append(Integer.toBinaryString(bytes000[idx]));
			binList.add(Integer.toBinaryString(bytes000[idx]));
			result[idx] = bytes000[idx];
		}
		
		System.out
			.println(">>>" + new String(result, Charset.forName("UTF-8")));
	}
	
	private static int getCodeFromChar(final String ch) {
		if ("0".equals(ch)) {
			return 0;
		} else if ("1".equals(ch)) {
			return 1;
		} else if ("2".equals(ch)) {
			return 2;
		} else if ("3".equals(ch)) {
			return 3;
		} else if ("4".equals(ch)) {
			return 4;
		} else if ("5".equals(ch)) {
			return 5;
		} else if ("6".equals(ch)) {
			return 6;
		} else if ("7".equals(ch)) {
			return 7;
		} else if ("8".equals(ch)) {
			return 8;
		} else if ("9".equals(ch)) {
			return 9;
		} else if ("a".equals(ch.toUpperCase())) {
			return 10;
		} else if ("b".equals(ch.toUpperCase())) {
			return 11;
		} else if ("c".equals(ch.toUpperCase())) {
			return 12;
		} else if ("d".equals(ch.toUpperCase())) {
			return 13;
		} else if ("e".equals(ch.toUpperCase())) {
			return 14;
		} else if ("f".equals(ch.toUpperCase())) {
			return 15;
		} else {
			return Integer.MIN_VALUE;
		}
	}
	
	private static Pattern	PTN		= Pattern.compile("[01]+");
	private static Pattern	PTN2	= Pattern.compile("(\\d{5})+?");
	private static Pattern	PTN3	= Pattern.compile("(\\d{4})+?");
	private static Pattern	PTN4	= Pattern.compile("([0-9a-f]{1})+?");
	
	private static String get32DFromStr(final List<String> binList) {
		StringBuilder b = new StringBuilder();
		for (String str : binList) {
			Matcher m = PTN.matcher(str);
			if (!m.matches()) {
				
			}
			b.append(str);
		}
		
		int fill = 5 - (b.toString().length() % 5);
		
		StringBuilder result = new StringBuilder();
		for (int i = 0; i < fill; i++) {
			result.append("0");
		}
		result.append(b.toString());
		String target = result.toString();
		
		List<String> d32List = new LinkedList<String>();
		
		Matcher m2 = PTN2.matcher(target);
		while (m2.find()) {
			d32List.add(target.substring(m2.start(), m2.end()));
		}
		
		StringBuilder result0 = new StringBuilder();
		for (String d32 : d32List) {
			result0.append(convertBinTo32d(d32));
		}
		return result0.toString();
	}
	
	private static String get32DFromStr2(final String binList) {
		StringBuilder b = new StringBuilder();
		//		for (String str : binList) {
		//			Matcher m = PTN.matcher(str);
		//			if (!m.matches()) {
		//				
		//			}
		//			b.append(str);
		//		}
		
		int fill = 5 - (binList.length() % 5);
		
		StringBuilder result = new StringBuilder();
		for (int i = 0; i < fill; i++) {
			result.append("0");
		}
		result.append(binList);
		String target = result.toString();
		
		List<String> d32List = new LinkedList<String>();
		
		Matcher m2 = PTN2.matcher(target);
		while (m2.find()) {
			d32List.add(target.substring(m2.start(), m2.end()));
		}
		
		StringBuilder result0 = new StringBuilder();
		for (String d32 : d32List) {
			result0.append(convertBinTo32d(d32));
		}
		return result0.toString();
	}
	
	private static String get16DFromStr(final List<String> binList) {
		StringBuilder b = new StringBuilder();
		for (String str : binList) {
			Matcher m = PTN.matcher(str);
			if (!m.matches()) {
				
			}
			b.append(str);
		}
		
		int fill = 4 - (b.toString().length() % 4);
		
		StringBuilder result = new StringBuilder();
		for (int i = 0; i < fill; i++) {
			result.append("0");
		}
		result.append(b.toString());
		String target = result.toString();
		
		List<String> d32List = new LinkedList<String>();
		
		Matcher m2 = PTN3.matcher(target);
		while (m2.find()) {
			d32List.add(target.substring(m2.start(), m2.end()));
		}
		
		StringBuilder result0 = new StringBuilder();
		for (String d32 : d32List) {
			result0.append(convertBinTo16d(d32));
		}
		return result0.toString();
	}
	
	private static String convertBinTo32d(final String d32) {
		StringBuilder result0 = new StringBuilder();
		if ("00000".equals(d32)) {
			result0.append("0");
		} else if ("00001".equals(d32)) {
			result0.append("1");
		} else if ("00010".equals(d32)) {
			result0.append("2");
		} else if ("00011".equals(d32)) {
			result0.append("3");
		} else if ("00100".equals(d32)) {
			result0.append("4");
		} else if ("00101".equals(d32)) {
			result0.append("5");
		} else if ("00110".equals(d32)) {
			result0.append("6");
		} else if ("00111".equals(d32)) {
			result0.append("7");
		} else if ("01000".equals(d32)) {
			result0.append("8");
		} else if ("01001".equals(d32)) {
			result0.append("9");
		} else if ("01010".equals(d32)) {
			result0.append("a");
		} else if ("01011".equals(d32)) {
			result0.append("b");
		} else if ("01100".equals(d32)) {
			result0.append("c");
		} else if ("01101".equals(d32)) {
			result0.append("d");
		} else if ("01110".equals(d32)) {
			result0.append("e");
		} else if ("01111".equals(d32)) {
			result0.append("f");
		} else if ("10000".equals(d32)) {
			result0.append("g");
		} else if ("10001".equals(d32)) {
			result0.append("h");
		} else if ("10010".equals(d32)) {
			result0.append("i");
		} else if ("10011".equals(d32)) {
			result0.append("j");
		} else if ("10100".equals(d32)) {
			result0.append("k");
		} else if ("10101".equals(d32)) {
			result0.append("l");
		} else if ("10110".equals(d32)) {
			result0.append("m");
		} else if ("10111".equals(d32)) {
			result0.append("n");
		} else if ("11000".equals(d32)) {
			result0.append("o");
		} else if ("11001".equals(d32)) {
			result0.append("p");
		} else if ("11010".equals(d32)) {
			result0.append("q");
		} else if ("11011".equals(d32)) {
			result0.append("r");
		} else if ("11100".equals(d32)) {
			result0.append("s");
		} else if ("11101".equals(d32)) {
			result0.append("t");
		} else if ("11110".equals(d32)) {
			result0.append("u");
		} else if ("11111".equals(d32)) {
			result0.append("v");
		}
		
		return result0.toString();
	}
	
	private static String convertBinTo16d(final String d16) {
		StringBuilder result0 = new StringBuilder();
		
		Matcher m2 = PTN4.matcher(d16);
		while (m2.find()) {
			String hex = d16.substring(m2.start(), m2.end());
			//System.out.println(hex);
			
			if ("0000".equals(hex)) {
				result0.append("0");
			} else if ("0001".equals(hex)) {
				result0.append("1");
			} else if ("0010".equals(hex)) {
				result0.append("2");
			} else if ("0011".equals(hex)) {
				result0.append("3");
			} else if ("0100".equals(hex)) {
				result0.append("4");
			} else if ("0101".equals(hex)) {
				result0.append("5");
			} else if ("0110".equals(hex)) {
				result0.append("6");
			} else if ("0111".equals(hex)) {
				result0.append("7");
			} else if ("1000".equals(hex)) {
				result0.append("8");
			} else if ("1001".equals(hex)) {
				result0.append("9");
			} else if ("1010".equals(hex)) {
				result0.append("a");
			} else if ("1011".equals(hex)) {
				result0.append("b");
			} else if ("1100".equals(hex)) {
				result0.append("c");
			} else if ("1101".equals(hex)) {
				result0.append("d");
			} else if ("1110".equals(hex)) {
				result0.append("e");
			} else if ("1111".equals(hex)) {
				result0.append("f");
			}
			
			result0.append(hex);
		}
		
		return result0.toString();
	}
	
	private static String convert16dToBin(final String d16) {
		StringBuilder result0 = new StringBuilder();
		
		Matcher m2 = PTN4.matcher(d16);
		while (m2.find()) {
			String hex = d16.substring(m2.start(), m2.end());
			if ("0".equals(hex)) {
				result0.append("0000");
			} else if ("1".equals(hex)) {
				result0.append("0001");
			} else if ("2".equals(hex)) {
				result0.append("0010");
			} else if ("3".equals(hex)) {
				result0.append("0011");
			} else if ("4".equals(hex)) {
				result0.append("0100");
			} else if ("5".equals(hex)) {
				result0.append("0101");
			} else if ("6".equals(hex)) {
				result0.append("0110");
			} else if ("7".equals(hex)) {
				result0.append("0111");
			} else if ("8".equals(hex)) {
				result0.append("1000");
			} else if ("9".equals(hex)) {
				result0.append("1001");
			} else if ("a".equals(hex)) {
				result0.append("1010");
			} else if ("b".equals(hex)) {
				result0.append("1011");
			} else if ("c".equals(hex)) {
				result0.append("1100");
			} else if ("d".equals(hex)) {
				result0.append("1101");
			} else if ("e".equals(hex)) {
				result0.append("1110");
			} else if ("f".equals(hex)) {
				result0.append("1111");
			}
		}
		
		return result0.toString();
	}
	
	public static String bin2hex(final byte[] data) {
		StringBuffer sb = new StringBuffer();
		for (byte b : data) {
			String s = Integer.toHexString(0xff & b);
			if (s.length() == 1) {
				sb.append("0");
			}
			sb.append(s);
		}
		return sb.toString();
	}
}
