package org.dyndns.nuda.di;

import java.util.ArrayList;
import java.util.List;

public class InjectorManager {
	private static List<Injector> injectors = new ArrayList<Injector>();
	
	public static void addInjector(Injector injector) {
		if(injector != null) {
			injectors.add(injector);
		}
	}
	
	public static void executeInjection(Object target) {
		for(Injector injector : injectors) {
			injector.inject(target);
		}
	}
}
