package org.dyndns.nuda.di;

import java.lang.reflect.Field;

import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.logger.LoggerAdaptorInjection;
import org.dyndns.nuda.management.RUN_STATE;

/**
 * 簡易DI機能を実現するためのクラスです
 * @author koseki
 *
 */
public class DIManager {
	private static RUN_STATE state = RUN_STATE.SLEEP;

	private static void initManager() {
		if (state.equals(RUN_STATE.SLEEP)) {
			state = RUN_STATE.RUNNING;
		}
	}

	public static void inject(Object target) {
		if (target == null) {
			return;
		}
		initManager();
		// LoggerAdaptorのDI
		Class<?> cls = target.getClass();
		Field[] fields = cls.getDeclaredFields();

		for (Field targetField : fields) {
			boolean isValid = targetField
					.isAnnotationPresent(LoggerAdaptorInjection.class);

			Class<?> fieldType = targetField.getType();
			if (fieldType.equals(LoggerAdaptor.class) && isValid) {
				boolean isAccessible = targetField.isAccessible();
				if (!isAccessible) {
					targetField.setAccessible(true);
				}

				LoggerAdaptor adaptor = null;

				LoggerAdaptorInjection inj = targetField
						.getAnnotation(org.dyndns.nuda.logger.LoggerAdaptorInjection.class);
				if (inj.name().isEmpty()) {
					adaptor = CommonLogger.getLoggerAdaptor().getLogger(cls);
				} else {
					adaptor = CommonLogger.getLoggerAdaptor().getLogger(
							inj.name());
				}

				if (java.lang.reflect.Modifier.isStatic(targetField
						.getModifiers())) {
					try {
						targetField.set(null, adaptor);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				} else {
					try {
						targetField.set(target, adaptor);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				}

				targetField.setAccessible(isAccessible);
			}

		}
	}
}
