package org.dyndns.nuda.management;

/**
 * 製品状態を表す列挙です
 * @author koseki
 *
 */
public enum PRODUCT_STATUS {
	
	/**
	 * ベータ版をあらわす製品状態です
	 */
	BETA, 
	
	/**
	 * アルファ版を表す製品状態です
	 */
	ALPHA, 
	
	/**
	 * 最新版を表す製品状態です
	 */
	LATEST, 
	
	/**
	 * 安定板を表す製品状態です
	 */
	STABLE, 
	
	/**
	 * ナイトリービルドであることを表す製品状態です
	 */
	NIGHTLY, 
	
	/**
	 * 最終更新版であることを表す製品状態です
	 */
	FIXED, 
	
	/**
	 * 通常版であることを表す製品状態です
	 */
	NORMAL;

	/**
	 * 製品状態を表すint値から製品状態オブジェクトを作成します.<br />
	 * 
	 * staus = 1 -> BETA<br />
	 * staus = 2 -> ALPHA<br />
	 * staus = 3 -> LATEST<br />
	 * staus = 4 -> STABLE<br />
	 * staus = 5 -> NIGHTLY<br />
	 * staus = 6 -> FIXED<br />
	 * staus = 7 -> NORMAL<br />
	 * 
	 * @param status 製品状態を表すint値
	 * @return 製品状態
	 */
	public static PRODUCT_STATUS create(int status) {
		if (status == 1) {
			return PRODUCT_STATUS.BETA;
		} else if (status == 2) {
			return PRODUCT_STATUS.ALPHA;
		} else if (status == 3) {
			return PRODUCT_STATUS.LATEST;
		} else if (status == 4) {
			return PRODUCT_STATUS.STABLE;
		} else if (status == 9) {
			return PRODUCT_STATUS.NIGHTLY;
		} else if (status == 8) {
			return PRODUCT_STATUS.FIXED;
		} else {
			return PRODUCT_STATUS.NORMAL;
		}
	}

	/**
	 * ステータス名を取得します
	 * @return ステータス名
	 */
	public String getStatusName() {
		return "-" + this.name().toLowerCase();
	}
}
