package org.dyndns.nuda.di;

import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.PluginLoader;
import org.dyndns.nuda.tools.concurrent.ThreadLock;

/**
 * 簡易DI機能を実現するためのクラスです
 * @author koseki
 *
 */
public class DIManager {
	protected static RUN_STATE state = RUN_STATE.SLEEP;

//	static {
//		PluginLoader loader = new PluginLoader();
//		loader.loadPlugin(Injector.class);
//	}
	private static void initManager() {
		if (state.equals(RUN_STATE.SLEEP)) {
			PluginLoader loader = new PluginLoader();
			state = RUN_STATE.RUNNING;
			loader.loadPlugin(Injector.class);
		}
	}

	public static void inject(Object target) {
		initManager();
		
		InjectorManager.executeInjection(target);
	}
}
