package org.dyndns.nuda.sample3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

public class ActiveProxy<I> {
	private Class<?> getTargetClass() {
		Class<?> cls = this.getClass();
		if(cls.getGenericSuperclass() instanceof ParameterizedType) {
			ParameterizedType pt = ParameterizedType.class.cast(cls.getGenericSuperclass());
			Type[] types = pt.getActualTypeArguments();
			if(types != null && types.length > 0) {
				
				ParameterizedType pt0 = ParameterizedType.class.cast(types[0]);
				return (Class<?>)pt0.getRawType();
			}
		} else {
			System.out.println(">" + cls.getGenericSuperclass().getClass().getCanonicalName());
		}
		return null;
	}
	
	public void test() {
		
		System.out.println(getTargetClass());
	}
	
	public class ProxyFactory {
		@SuppressWarnings("unchecked")
		public I create() {
			
			InvocationHandler ih = new InvocationHandlerImpl();
			ClassLoader l = Thread.currentThread().getContextClassLoader();
			
			Class<I> targetClass = (Class<I>)getTargetClass();
			
			Object obj = Proxy.newProxyInstance(l, new Class[]{targetClass}, ih);
			
			return (I)obj;
		}
		
		@SuppressWarnings("unchecked")
		public I create(InvocationHandler ih) {
			ClassLoader l = Thread.currentThread().getContextClassLoader();
			
			Class<I> targetClass = (Class<I>)getTargetClass();
			
			Object obj = Proxy.newProxyInstance(l, new Class[]{targetClass}, ih);
			
			return (I)obj;
		}
	}
	
	private static class InvocationHandlerImpl implements InvocationHandler {

		@Override
		public Object invoke(Object proxy, Method method, Object[] args)
				throws Throwable {
			
			StringBuilder message = new StringBuilder();
			message.append("call");
			message.append("[");
			message.append(method.getName());
			message.append("]");
			message.append("[");
			
			
			if(args != null) {
				int count = 0;
				for(Object arg : args) {
					if(count !=  args.length - 1) {
						message.append(arg);
						message.append(", ");
					} else {
						message.append(arg);
					}
					count++;
				}
			}
			
			
			message.append("]");
			
			System.out.println(message.toString());
			
			Class<?> returnType = method.getReturnType();
			if(int.class.equals(returnType)) {
				return 0;
			} else if(byte.class.equals(returnType)) {
				return (byte)0;
			} else if(short.class.equals(returnType)) {
				return (short)0;
			} else if(long.class.equals(returnType)) {
				return (long)0;
			} else if(float.class.equals(returnType)) {
				return (float)0;
			} else if(double.class.equals(returnType)) {
				return (double)0;
			} else if(char.class.equals(returnType)) {
				return "".toCharArray()[0];
			} else if(boolean.class.equals(returnType)) {
				return false;
			}
			
			
			return null;
		}
		
	}
}
