package org.cocos2d.tests;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.cocos2d.Cocos2D;

import android.app.ListActivity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;
import android.widget.SimpleAdapter;

public class main extends ListActivity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setListAdapter(new SimpleAdapter(this,
				getData("org.cocos2d.tests"),
				android.R.layout.simple_list_item_1, new String[]{"title"},
				new int[]{android.R.id.text1}));
		getListView().setTextFilterEnabled(true);
	}

	protected List<Map<String, ?>> getData(String prefix) {
		List<Map<String,?>> listData = new ArrayList<Map<String,?>>();

		Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
		mainIntent.addCategory(Intent.CATEGORY_TEST);

		PackageManager pm = getPackageManager();
		List<ResolveInfo> list = pm.queryIntentActivities(mainIntent, 0);

		if(list != null) {
			for(ResolveInfo info : list) {
				String activityName = info.activityInfo.name;
				if (prefix.length() == 0 || activityName.startsWith(prefix)) {
					String[] labelPath = activityName.split("\\.");
					String nextLabel = labelPath[labelPath.length - 1];
					addItem(listData, nextLabel, activityIntent(
							info.activityInfo.applicationInfo.packageName,
							info.activityInfo.name));
				}
			}

			Collections.sort(listData, sDisplayNameComparator);
		}

		return listData;
	}

	private final static Comparator<Map<String, ?>> sDisplayNameComparator = new Comparator<Map<String, ?>>() {
		private final Collator collator = Collator.getInstance();

		public int compare(Map<String,?> map1, Map<String,?> map2) {
			return collator.compare(map1.get("title"), map2.get("title"));
		}
	};

	protected Intent activityIntent(String pkg, String componentName) {
		Intent result = new Intent();
		result.setClassName(pkg, componentName);
		return result;
	}

	protected Intent browserIntent(String path) {
		Intent result = new Intent();
		result.setClass(this, Cocos2D.class);
		result.putExtra("org.cocos2d.tests.Path", path);
		return result;
	}

	protected void addItem(List<Map<String,?>> data, String name, Intent intent) {
		Map<String, Object> temp = new HashMap<String, Object>();
		temp.put("title", name);
		temp.put("intent", intent);
		data.add(temp);
	}

	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		Map<String,?> map = (Map<String,?>) l.getItemAtPosition(position);
		Intent intent = (Intent) map.get("intent");
		startActivity(intent);
	}
}
