package org.cocos2d.touch_dispatcher;

import org.cocos2d.CCDirector;
import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.support.CCPointExtension;

/**
 * @addtogroup input
 * @{
 */

public class CCTouch {
	public CCTouch() { 
		m_nId = 0;
		m_startPointCaptured = false;
	}

	/** returns the current touch location in OpenGL coordinates */
	public CCPoint getLocation() {
		return CCDirector.sharedDirector().convertToGL(m_point);
	}

	/** returns the previous touch location in OpenGL coordinates */
	public CCPoint getPreviousLocation() {
		return CCDirector.sharedDirector().convertToGL(m_prevPoint);
	}

	/** returns the start touch location in OpenGL coordinates */
	public CCPoint getStartLocation() {
		return CCDirector.sharedDirector().convertToGL(m_startPoint);
	}

	/** returns the delta of 2 current touches locations in screen coordinates */
	public CCPoint getDelta() {
		return CCPointExtension.ccpSub(getLocation(), getPreviousLocation()); 
	}

	/** returns the current touch location in screen coordinates */
	public CCPoint getLocationInView() {
		return m_point;
	}

	/** returns the previous touch location in screen coordinates */
	public CCPoint getPreviousLocationInView() {
		return m_prevPoint;
	}

	/** returns the start touch location in screen coordinates */
	public CCPoint getStartLocationInView() {
		return m_startPoint;
	}

	public void setTouchInfo(int id, float x, float y) {
		m_nId = id;
		m_prevPoint.setPoint(m_point);
		m_point.setPoint(x, y);
		if(! m_startPointCaptured) {
			m_startPoint.setPoint(m_point);
			m_startPointCaptured = true;
		}
	}

	public int getID() {
		return m_nId;
	}

	private int m_nId;
	private boolean m_startPointCaptured;
	private CCPoint m_startPoint = new CCPoint();
	private CCPoint m_point = new CCPoint();
	private CCPoint m_prevPoint = new CCPoint();
}

// end of input group
/// @}
