package org.cocos2d.platform;

import org.cocos2d.platform.CCCommon.ccLanguageType;

/**
 * @addtogroup platform
 * @{
 */

public abstract class CCApplicationProtocol {

	public enum TargetPlatform {
		kTargetWindows,
		kTargetLinux,
		kTargetMacOS,
		kTargetAndroid,
		kTargetIphone,
		kTargetIpad,
		kTargetBlackBerry,
		kTargetNaCl,
	}

	/**
	 * @brief    Implement CCDirector and CCScene init code here.
	 * @return true    Initialize success, app continue.
	 * @return false   Initialize failed, app terminate.
	 */
	public abstract boolean applicationDidFinishLaunching();

	/**
	 * @brief  The function be called when the application enter background
	 * @param  the pointer of the application
	 */
	public abstract void applicationDidEnterBackground();

	/**
	 * @brief  The function be called when the application enter foreground
	 * @param  the pointer of the application
	 */
	public abstract void applicationWillEnterForeground();

	/**
	 * @brief    Callback by CCDirector for limit FPS.
	 * @interval       The time, expressed in seconds, between current frame and next. 
	 */
	public abstract void setAnimationInterval(double interval);

	/**
	 * @brief Get current language config
	 * @return Current language config
	 */
	public abstract ccLanguageType getCurrentLanguage();

	/**
	 * @brief Get target platform
	 */
	public abstract TargetPlatform getTargetPlatform();
}

// end of platform group
/// @}
