package org.cocos2d.lib;

import org.cocos2d.CCDirector;
import org.cocos2d.lib.Cocos2dHelper.Cocos2dHelperListener;
import org.cocos2d.opengl.CCGLSurfaceView;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

public abstract class Cocos2dActivity extends Activity implements Cocos2dHelperListener {
	// ===========================================================
	// Constants
	// ===========================================================

	// private static final String TAG = Cocos2dActivity.class.getSimpleName();

	// ===========================================================
	// Fields
	// ===========================================================

	private CCGLSurfaceView mGLSurfaceView;
	private static Context sContext = null;

	public static Context getContext() {
		return sContext;
	}

	// ===========================================================
	// Constructors
	// ===========================================================

	@Override
	protected void onCreate(final Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		sContext = this;

		this.init();

		Cocos2dHelper.init(this, this);
	}

	// ===========================================================
	// Getter & Setter
	// ===========================================================

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	@Override
	protected void onResume() {
		super.onResume();

		Cocos2dHelper.onResume();
		CCDirector.sharedDirector().onResume();
	}

	@Override
	protected void onPause() {
		super.onPause();

		Cocos2dHelper.onPause();
		CCDirector.sharedDirector().onPause();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();

		Cocos2dHelper.end();
		CCDirector.sharedDirector().end();
		// CCTextureCache.sharedTextureCache().removeAllTextures();
	}
	
	// ===========================================================
	// Methods
	// ===========================================================

	public void init() {
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
				WindowManager.LayoutParams.FLAG_FULLSCREEN);
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON,
				WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

		this.mGLSurfaceView = this.onCreateView();

		CCDirector director = CCDirector.sharedDirector();
		director.attachInView(mGLSurfaceView);
		director.setDeviceOrientation(CCDirector.kCCDeviceOrientationLandscapeLeft);

		setContentView(mGLSurfaceView);
	}

	public CCGLSurfaceView onCreateView() {
		return new CCGLSurfaceView(this);
	}

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================
}
