/**
 * 
 */
package org.cocos2d.platform;

import java.util.Formatter;

import android.util.Log;

/**
 * @addtogroup platform
 * @{
 */

public class CCCommon {

	/// The max length of CCLog message.
	public static final int kMaxLogLen = 16*1024;

	private static StringBuilder sb = new StringBuilder(kMaxLogLen);
	private static Formatter formatter = new Formatter(sb);

	/**
	 * @brief Output Debug message.
	 */
	public static void CCLog(final String pszFormat, Object... objects) {
		synchronized(sb) {
			sb.setLength(0);
			formatter.format(pszFormat, objects);
			Log.d("cocos2d-x debug info", sb.toString());
		}
	}

	/**
	 * lua can not deal with ...
	 */
	public static void CCLuaLog(final String pszFormat) {
		Log.d("cocos2d-x debug info", pszFormat);
	}

	/**
	 * @brief Pop out a message box
	 */
	public static void CCMessageBox(final String pszMsg, final String pszTitle) {
		// TODO
	}

	/**
	 * @brief Enum the language type supported now
	 */
	public enum ccLanguageType {
		kLanguageEnglish,
		kLanguageChinese,
		kLanguageFrench,
		kLanguageItalian,
		kLanguageGerman,
		kLanguageSpanish,
		kLanguageRussian,
		kLanguageKorean,
		kLanguageJapanese,
		kLanguageHungarian,
		kLanguagePortuguese,
		kLanguageArabic
	}
}

// end of platform group
/// @}
