package org.cocos2d.actions.interval;

import org.cocos2d.base_nodes.CCNode;
import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.support.CCPointExtension;

/**  Moves a CCNode object x,y pixels by modifying it's position attribute.
 x and y are relative to the position of the object.
 Duration is is seconds.
*/ 
public class CCMoveBy extends CCMoveTo {
    /** creates the action */
    public static CCMoveBy action(float duration, CCPoint pos) {
        return new CCMoveBy(duration, pos);
    }

    /** initializes the action */
    protected CCMoveBy(float t, CCPoint pos) {
        super(t, pos);
        delta.setPoint(pos);
    }

    @Override
    public CCMoveBy copy() {
        return new CCMoveBy(duration, delta);
    }

    @Override
    public void start(CCNode aTarget) {
    	float tmpx = delta.x;
		float tmpy = delta.y;

        super.start(aTarget);
        delta.setPoint(tmpx, tmpy);
    }

    @Override
    public CCMoveBy reverse() {
        return new CCMoveBy(duration, CCPointExtension.ccpNeg(delta));
    }
}

