/****************************************************************************
Copyright (c) 2010 cocos2d-x.org

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
****************************************************************************/
package org.cocos2d.platform;

import org.cocos2d.lib.Cocos2dHelper;

public class CCAccelerometer {

	public CCAccelerometer() {
		m_pAccelDelegate = null;
	}

	public void _destractor() {
	}

	public void setDelegate(CCAccelerometerDelegate pDelegate) {
		m_pAccelDelegate = pDelegate;

		if (pDelegate != null) {
			Cocos2dHelper.enableAccelerometer();
		} else {
			Cocos2dHelper.disableAccelerometer();
		}
	}

	public void setAccelerometerInterval(float interval) {
		Cocos2dHelper.setAccelerometerInterval(interval);
	}

	public void update(float x, float y, float z, long sensorTimeStamp) {
		if (m_pAccelDelegate != null) {
			m_obAccelerationValue.x = -((double)x / TG3_GRAVITY_EARTH);
			m_obAccelerationValue.y = -((double)y / TG3_GRAVITY_EARTH);
			m_obAccelerationValue.z = -((double)z / TG3_GRAVITY_EARTH);
			m_obAccelerationValue.timestamp = (double)sensorTimeStamp;

			m_pAccelDelegate.didAccelerate(m_obAccelerationValue);
		}
	}

	private CCAccelerometerDelegate m_pAccelDelegate;
	private CCAcceleration m_obAccelerationValue = new CCAcceleration();

	private static final float TG3_GRAVITY_EARTH = 9.80665f;
}
