package org.cocos2d.menu_nodes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.cocos2d.base_nodes.CCNodeRGBA;
import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCRect;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;

/**
 * @addtogroup GUI
 * @{
 * @addtogroup menu
 * @{
 */

/** @brief CCMenuItem base class
 *
 *  Subclass CCMenuItem (or any subclass) to create your custom CCMenuItem objects.
 */
public class CCMenuItem extends CCNodeRGBA {

	public static final int kCCItemSize = 32;

	/** whether or not the item is selected
	 * @since v0.8.2
	 */
	protected boolean m_bSelected;
	protected boolean m_bEnabled;

	public CCMenuItem() {
		m_bSelected = false;
		m_bEnabled = false;
		m_pListener = null;
		m_pfnSelector = null;
		m_nScriptTapHandler = 0;
	}

	/** Creates a CCMenuItem with no target/selector */
	public static CCMenuItem create() {
		return CCMenuItem.create(null, null);
	}

	/** Creates a CCMenuItem with a target/selector */
	public static CCMenuItem create(Object rec, String selector) {
		CCMenuItem pRet = new CCMenuItem();
		pRet.initWithTarget(rec, selector);
		return pRet;
	}

	/** Initializes a CCMenuItem with a target/selector */
	public boolean initWithTarget(Object rec, String selector) {
		setAnchorPoint(0.5f, 0.5f);
		m_pListener = rec;
		m_pfnSelector = selector;
		m_bEnabled = true;
		m_bSelected = false;

		invocation = null;
		if ((rec != null) && (selector != null)) {
			Class<?> cls = rec.getClass();
			try {
				invocation = cls.getMethod(selector, Object.class);
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}

		return true;
	}

	/** Returns the outside box */
	public CCRect rect() {
		return CCRect.Make(
				m_obPosition.x - m_obContentSize.width * m_obAnchorPoint.x,
				m_obPosition.y - m_obContentSize.height * m_obAnchorPoint.y,
				m_obContentSize.width, m_obContentSize.height
				);
	}

	/** Activate the item */
	public void activate() {
		if (m_bEnabled) {
			if (m_pListener != null & invocation != null) {
				try {
					invocation.invoke(m_pListener, this);
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					if(e.getTargetException() instanceof RuntimeException)
						throw (RuntimeException)e.getTargetException();
					else
						e.printStackTrace();
				}
			}
/* TODO
			if(kScriptTypeNone != m_eScriptType) {
				CCScriptEngineManager.sharedManager().getScriptEngine().executeMenuItemEvent(this);
			}
*/
		}
	}

	/** The item was selected (not activated), similar to "mouse-over" */
	public void selected() {
		m_bSelected = true;
	}

	/** The item was unselected */
	public void unselected() {
		m_bSelected = false;
	}

	/** Register menu handler script function */
	public void registerScriptTapHandler(int nHandler) {
		unregisterScriptTapHandler();
		m_nScriptTapHandler = nHandler;
// TODO		LUALOG("[LUA] Add CCMenuItem script handler: %d", m_nScriptTapHandler);
	}

	public void unregisterScriptTapHandler() {
		if(m_nScriptTapHandler != 0) {
// TODO			CCScriptEngineManager.sharedManager().getScriptEngine().removeScriptHandler(m_nScriptTapHandler);
// TODO			LUALOG("[LUA] Remove CCMenuItem script handler: %d", m_nScriptTapHandler);
			m_nScriptTapHandler = 0;
		}
	}

	int getScriptTapHandler() {
		return m_nScriptTapHandler;
	};

	public boolean isEnabled() {
		return m_bEnabled;
	}

	//@note: It's 'setIsEnable' in cocos2d-iphone. 
	public void setEnabled(boolean enabled) {
		m_bEnabled = enabled;
	}

	public boolean isSelected() {
		return m_bSelected;
	}

	@Override
	public void setOpacityModifyRGB(boolean bValue) {
	}

	@Override
	public boolean isOpacityModifyRGB() {
		return false;
	}

	/** set the target/selector of the menu item*/
	public void setTarget(Object rec, String selector) {
		m_pListener = rec;
		m_pfnSelector = selector;

		invocation = null;
		if ((rec != null) && (selector != null)) {
			Class<?> cls = rec.getClass();
			try {
				invocation = cls.getMethod(selector, Object.class);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	protected Object m_pListener;
	protected String m_pfnSelector;
	protected int m_nScriptTapHandler;

	protected static int _globalFontSize = kCCItemSize;
	protected static String _globalFontName = "DroidSans";
	protected static boolean _globalFontNameRelease = false;

	protected static final int kCurrentItem = 0xc0c05001;
	protected static final int kZoomActionTag = 0xc0c05002;

	protected static final int kNormalTag = 0x1;
	protected static final int kSelectedTag = 0x2;
	protected static final int kDisableTag = 0x3;

	private Method invocation;

	// TODO legacy -->

    /**
     * Returns the outside box to
     * No garbage version.
     */
    public void rect(CCRect ret) {
    	CCPoint pos = getPosition();
    	CCPoint pnt = getAnchorPoint();
    	CCSize size = getContentSize();
        ret.setRect(	pos.x - size.width * pnt.x,
        				pos.y - size.height * pnt.y,
        				size.width,
        				size.height	);
    }
}

// end of GUI group
/// @}
/// @}
