package org.cocos2d.transitions;

import org.cocos2d.CCDirector;
import org.cocos2d.actions.interval.CCIntervalAction;
import org.cocos2d.actions.interval.CCMoveBy;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.layers_scenes_transitions_nodes.CCScene;
import org.cocos2d.support.CCPointExtension;

/**
 * SlideInR Transition.
 * Slide in the incoming scene from the right border.
 */
public class CCSlideInRTransition extends CCSlideInLTransition {

    public static CCSlideInRTransition transition(float t, CCScene s) {
        return new CCSlideInRTransition(t, s);
    }

    public CCSlideInRTransition(float t, CCScene s) {
        super(t, s);
    }

    @Override
    public void sceneOrder() {
        inSceneOnTop = true;
    }

    /**
     * initializes the scenes
     */
    @Override
    protected void initScenes() {
        CCSize s = CCDirector.sharedDirector().getWinSizeInPixels();
        inScene.setPosition(s.width-ADJUST_FACTOR, 0);
    }

    @Override
    public CCIntervalAction action() {
        CCSize s = CCDirector.sharedDirector().getWinSizeInPixels();
        return CCMoveBy.action(duration, CCPointExtension.ccp(-(s.width-ADJUST_FACTOR),0));
    }
}
