/****************************************************************************
Copyright (c) 2010-2012 cocos2d-x.org
Copyright (c) 2011      Zynga Inc.

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
****************************************************************************/
package org.cocos2d.shaders;

/**
 * @addtogroup shaders
 * @{
 */

public class ccShaders {

	public static final String ccPosition_uColor_frag =
		"	#ifdef GL_ES							\n" +
		"	precision lowp float;					\n" +
		"	#endif									\n" +
		"											\n" +
		"	varying vec4 v_fragmentColor;			\n" +
		"											\n" +
		"	void main()								\n" +
		"	{										\n" +
		"		gl_FragColor = v_fragmentColor;		\n" +
		"	}										\n";

	public static final String ccPosition_uColor_vert =
		"	attribute vec4 a_position;							\n" +
		"	uniform	vec4 u_color;								\n" +
		"	uniform float u_pointSize;							\n" +
		"														\n" +
		"	#ifdef GL_ES										\n" +
		"	varying lowp vec4 v_fragmentColor;					\n" +
		"	#else												\n" +
		"	varying vec4 v_fragmentColor;						\n" +
		"	#endif												\n" +
		"														\n" +
		"	void main()											\n" +
		"	{													\n" +
		"	    gl_Position = CC_MVPMatrix * a_position;		\n" +
		"		gl_PointSize = u_pointSize;						\n" +
		"		v_fragmentColor = u_color;						\n" +
		"	}													\n";

	public static final String ccPositionColor_frag =
		"	#ifdef GL_ES										\n" +
		"	precision lowp float;								\n" +
		"	#endif												\n" +
		"														\n" +
		"	varying vec4 v_fragmentColor;						\n" +
		"														\n" +
		"	void main()											\n" +
		"	{													\n" +
		"		gl_FragColor = v_fragmentColor;					\n" +
		"	}													\n";

	public static final String ccPositionColor_vert =
		"	attribute vec4 a_position;								\n" +
		"	attribute vec4 a_color;									\n" +
		"	#ifdef GL_ES											\n" +
		"	varying lowp vec4 v_fragmentColor;						\n" +
		"	#else													\n" +
		"	varying vec4 v_fragmentColor;							\n" +
		"	#endif													\n" +
		"															\n" +
		"	void main()												\n" +
		"	{														\n" +
		"		gl_Position = CC_MVPMatrix * a_position;			\n" +
		"		v_fragmentColor = a_color;							\n" +
		"	}														\n";

	public static final String ccPositionTexture_frag =
		"	#ifdef GL_ES															\n" +
		"	precision lowp float;													\n" +
		"	#endif																	\n" +
		"																			\n" +
		"	varying vec2 v_texCoord;												\n" +
		"	uniform sampler2D CC_Texture0;											\n" +
		"																			\n" +
		"	void main()																\n" +
		"	{																		\n" +
		"		gl_FragColor =  texture2D(CC_Texture0, v_texCoord);					\n" +
		"	}																		\n";

	public static final String ccPositionTexture_vert =
		"	attribute vec4 a_position;								\n" +
		"	attribute vec2 a_texCoord;								\n" +
		"															\n" +
		"	#ifdef GL_ES											\n" +
		"	varying mediump vec2 v_texCoord;						\n" +
		"	#else													\n" +
		"	varying vec2 v_texCoord;								\n" +
		"	#endif													\n" +
		"															\n" +
		"	void main()												\n" +
		"	{														\n" +
		"		gl_Position = CC_MVPMatrix * a_position;			\n" +
		"		v_texCoord = a_texCoord;							\n" +
		"	}														\n";

	public static final String ccPositionTextureA8Color_frag =
		"	#ifdef GL_ES										\n" +
		"	precision lowp float;								\n" +
		"	#endif												\n" +
		"														\n" +
		"	varying vec4 v_fragmentColor;						\n" +
		"	varying vec2 v_texCoord;							\n" +
		"	uniform sampler2D CC_Texture0;						\n" +
		"														\n" +
		"	void main()											\n" +
		"	{													\n" +
		"		gl_FragColor = vec4( v_fragmentColor.rgb,										// RGB from uniform				\n" +
		"							v_fragmentColor.a * texture2D(CC_Texture0, v_texCoord).a	// A from texture & uniform		\n" +
		"							);							\n" +
		"	}													\n";

	public static final String ccPositionTextureA8Color_vert =
		"	attribute vec4 a_position;							\n" +
		"	attribute vec2 a_texCoord;							\n" +
		"	attribute vec4 a_color;								\n" +
		"														\n" +
		"	#ifdef GL_ES										\n" +
		"	varying lowp vec4 v_fragmentColor;					\n" +
		"	varying mediump vec2 v_texCoord;					\n" +
		"	#else												\n" +
		"	varying vec4 v_fragmentColor;						\n" +
		"	varying vec2 v_texCoord;							\n" +
		"	#endif												\n" +
		"														\n" +
		"	void main()											\n" +
		"	{													\n" +
		"		gl_Position = CC_MVPMatrix * a_position;		\n" +
		"		v_fragmentColor = a_color;						\n" +
		"		v_texCoord = a_texCoord;						\n" +
		"	}													\n";

	public static final String ccPositionTextureColor_frag =
		"	#ifdef GL_ES								\n" +
		"	precision lowp float;						\n" +
		"	#endif										\n" +
		"												\n" +
		"	varying vec4 v_fragmentColor;				\n" +
		"	varying vec2 v_texCoord;					\n" +
		"	uniform sampler2D CC_Texture0;				\n" +
		"												\n" +
		"	void main()									\n" +
		"	{											\n" +
		"		gl_FragColor = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);			\n" +
		"	}											\n";

	public static final String ccPositionTextureColor_vert =
		"	attribute vec4 a_position;							\n" +
		"	attribute vec2 a_texCoord;							\n" +
		"	attribute vec4 a_color;								\n" +
		"														\n" +
		"	#ifdef GL_ES										\n" +
		"	varying lowp vec4 v_fragmentColor;					\n" +
		"	varying mediump vec2 v_texCoord;					\n" +
		"	#else												\n" +
		"	varying vec4 v_fragmentColor;						\n" +
		"	varying vec2 v_texCoord;							\n" +
		"	#endif												\n" +
		"														\n" +
		"	void main()											\n" +
		"	{													\n" +
		"		gl_Position = CC_MVPMatrix * a_position;		\n" +
		"		v_fragmentColor = a_color;						\n" +
		"		v_texCoord = a_texCoord;						\n" +
		"	}													\n";

	public static final String ccPositionTextureColorAlphaTest_frag =
		"	#ifdef GL_ES												\n" +
		"	precision lowp float;										\n" +
		"	#endif														\n" +
		"																\n" +
		"	varying vec4 v_fragmentColor;								\n" +
		"	varying vec2 v_texCoord;									\n" +
		"	uniform sampler2D CC_Texture0;								\n" +
		"	uniform float CC_alpha_value;								\n" +
		"																\n" +
		"	void main()													\n" +
		"	{															\n" +
		"		vec4 texColor = texture2D(CC_Texture0, v_texCoord);		\n" +
		"																\n" +
		"		// mimic: glAlphaFunc(GL_GREATER)						\n" +
		"		// pass if ( incoming_pixel >= CC_alpha_value ) => fail if incoming_pixel < CC_alpha_value		\n" +
		"																\n" +
		"		if ( texColor.a <= CC_alpha_value )						\n" +
		"			discard;											\n" +
		"																\n" +
		"		gl_FragColor = texColor * v_fragmentColor;				\n" +
		"	}															\n";

	public static final String ccPositionTexture_uColor_frag =
		"	#ifdef GL_ES							\n" +
		"	precision lowp float;					\n" +
		"	#endif									\n" +
		"											\n" +
		"	uniform		vec4 u_color;				\n" +
		"											\n" +
		"	varying vec2 v_texCoord;				\n" +
		"											\n" +
		"	uniform sampler2D CC_Texture0;			\n" +
		"											\n" +
		"	void main()								\n" +
		"	{										\n" +
		"		gl_FragColor =  texture2D(CC_Texture0, v_texCoord) * u_color;	\n" +
		"	}										\n";

	public static final String ccPositionTexture_uColor_vert =
		"	attribute vec4 a_position;			\n" +
		"	attribute vec2 a_texCoord;			\n" +
		"										\n" +
		"	#ifdef GL_ES						\n" +
		"	varying mediump vec2 v_texCoord;	\n" +
		"	#else								\n" +
		"	varying vec2 v_texCoord;			\n" +
		"	#endif								\n" +
		"										\n" +
		"	void main()							\n" +
		"	{									\n" +
		"	    gl_Position = CC_MVPMatrix * a_position;		\n" +
		"		v_texCoord = a_texCoord;		\n" +
		"	}									\n";

	public static final String ccPositionColorLengthTexture_frag =
		"	#ifdef GL_ES																												\n" +
		"	// #extension GL_OES_standard_derivatives : enable																			\n" +
		"																																\n" +
		"	varying mediump vec4 v_color;																								\n" +
		"	varying mediump vec2 v_texcoord;																							\n" +
		"	#else																														\n" +
		"	varying vec4 v_color;																										\n" +
		"	varying vec2 v_texcoord;																									\n" +
		"	#endif																														\n" +
		"																																\n" +
		"	void main()																													\n" +
		"	{																															\n" +
		"	// #if defined GL_OES_standard_derivatives																						\n" +
		"		// gl_FragColor = v_color*smoothstep(0.0, length(fwidth(v_texcoord)), 1.0 - length(v_texcoord));							\n" +
		"	// #else																														\n" +
		"		gl_FragColor = v_color*step(0.0, 1.0 - length(v_texcoord));																\n" +
		"	// #endif																														\n" +
		"	}																															\n";

	public static final String ccPositionColorLengthTexture_vert =
		"	#ifdef GL_ES														\n" +
		"	attribute mediump vec4 a_position;									\n" +
		"	attribute mediump vec2 a_texcoord;									\n" +
		"	attribute mediump vec4 a_color;										\n" +
		"																		\n" +
		"	varying mediump vec4 v_color;										\n" +
		"	varying mediump vec2 v_texcoord;									\n" +
		"																		\n" +
		"	#else																\n" +
		"	attribute vec4 a_position;											\n" +
		"	attribute vec2 a_texcoord;											\n" +
		"	attribute vec4 a_color;												\n" +
		"																		\n" +
		"	varying vec4 v_color;												\n" +
		"	varying vec2 v_texcoord;											\n" +
		"	#endif																\n" +
		"																		\n" +
		"	void main()															\n" +
		"	{																	\n" +
		"		v_color = vec4(a_color.rgb * a_color.a, a_color.a);				\n" +
		"		v_texcoord = a_texcoord;										\n" +
		"																		\n" +
		"		gl_Position = CC_MVPMatrix * a_position;						\n" +
		"	}																	\n";

	public static final String ccExSwitchMask_frag =
		"	#ifdef GL_ES                                     \n" +
		"	precision lowp float;                            \n" +
		"	#endif                                           \n" +
		"	                                                 \n" +
		"	varying vec4        v_fragmentColor;             \n" +
		"	varying vec2        v_texCoord;                  \n" +
		"	uniform sampler2D   u_texture;                   \n" +
		"	uniform sampler2D   u_mask;                      \n" +
		"	                                                 \n" +
		"	void main()                                      \n" +
		"	{                                                \n" +
		"	    vec4 texColor   = texture2D(u_texture, v_texCoord);                                      \n" +
		"	    vec4 maskColor  = texture2D(u_mask, v_texCoord);                                         \n" +
		"	    vec4 finalColor = vec4(texColor.r, texColor.g, texColor.b, maskColor.a * texColor.a);    \n" +
		"	    gl_FragColor    = v_fragmentColor * finalColor;                                          \n" +
		"	}                                                                                            \n";
}

// end of shaders group
/// @}
