package org.cocos2d.events;

import org.cocos2d.events.CCTouchDispatcher.ccTouchSelectorFlag;
import org.cocos2d.protocols.CCTouchDelegateProtocol;

import android.view.MotionEvent;

/**
 * @addtogroup input
 * @{
 */

/**
 * CCTouchHandler
 * Object than contains the delegate and priority of the event handler.
*/
public class CCTouchHandler implements CCTouchDelegateProtocol {

	/** delegate */
/* TODO
	public CCTouchDelegate getDelegate() {
	}
*/
/* TODO
	public void setDelegate(CCTouchDelegate pDelegate) {
		;
	}
*/
	/** priority */
	public int getPriority() {
		return priority_;
	}

	public void setPriority(int nPriority) {
		priority_ = nPriority;
	}


	/** enabled selectors */
	public int getEnabledSelectors() {
		return enabledSelectors_;
	}

	public void setEnalbedSelectors(int nValue) {
		enabledSelectors_ = nValue;
	}

	/** initializes a TouchHandler with a delegate and a priority */
/* TODO
	public boolean initWithDelegate(CCTouchDelegate pDelegate, int nPriority) {
		// TODO
		return false;
	}
*/
	/** allocates a TouchHandler with a delegate and a priority */
/* TODO
	public static CCTouchHandler handlerWithDelegate(CCTouchDelegate pDelegate, int nPriority) {
		// TODO
		return null;
	}
*/
/* TODO
	protected CCTouchDelegate m_pDelegate;
*/
//	protected int m_nPriority;
//	protected int m_nEnabledSelectors;



	// TODO legacy -->

	/** delegate */
    private CCTouchDelegateProtocol delegate_;
    /** priority */
    private int priority_;
    /** enabled selectors */
    int enabledSelectors_;

    public CCTouchDelegateProtocol getDelegate() {
        return delegate_;
    }

    public void setSelectorFlag(int sf){
        enabledSelectors_ = sf;
    }

    public int getSelectorFlag() {
        return enabledSelectors_;
    }

    /** allocates a TouchHandler with a delegate and a priority */
    public static CCTouchHandler makeHandler(CCTouchDelegateProtocol delegate, int priority) {
        return new CCTouchHandler(delegate, priority);
    }

    /** initializes a TouchHandler with a delegate and a priority */
    public CCTouchHandler(CCTouchDelegateProtocol delegate, int priority) {
        assert delegate !=null : "Touch delegate may not be nil";
        delegate_ = delegate;
        priority_ = priority;
        enabledSelectors_ = ccTouchSelectorFlag.ccTouchSelectorNoneBit.getFlag();
    }

    public boolean ccTouchesBegan(MotionEvent event) {
        if( delegate_ != null )
            return delegate_.ccTouchesBegan(event);
        return CCTouchDispatcher.kEventIgnored;
    }

    public boolean ccTouchesMoved(MotionEvent event) {
        if( delegate_ != null )
            return delegate_.ccTouchesMoved(event);
        return CCTouchDispatcher.kEventIgnored;
    }

    public boolean ccTouchesEnded(MotionEvent event) {
        if( delegate_ != null )
            return delegate_.ccTouchesEnded(event);
        return CCTouchDispatcher.kEventIgnored;
    }

    public boolean ccTouchesCancelled(MotionEvent event) {
        if( delegate_ != null )
            return delegate_.ccTouchesCancelled(event);
        return CCTouchDispatcher.kEventIgnored;
    }
}

