package org.cocos2d.nodes;

import org.cocos2d.textures.CCTexture2D;
import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCRect;
import org.cocos2d.cocoa.CCGeometry.CCSize;

/** A CCSpriteFrame has:
  - texture: A CCTexture2D that will be used by the CCSprite
  - rectangle: A rectangle of the texture


  You can modify the frame of a CCSprite by doing:

  CCSpriteFrame *frame = [CCSpriteFrame frameWithTexture:texture rect:rect offset:offset];
  [sprite setDisplayFrame:frame];
  */
public class CCSpriteFrame {
    /** rect of the frame */
    CCRect rect_ = new CCRect();
    public CCRect getRect() {
    	return new CCRect(rect_);
    }
    
    public CCRect getRectRef() {
    	return rect_;
    }
    
    /** offset of the frame */
    CCPoint			offset_ = new CCPoint();
    public CCPoint getOffset() {
    	return CCPoint.Make(offset_.x, offset_.y);
    }
    
    public CCPoint getOffsetRef() {
    	return offset_;
    }
    
    /** original size of the trimmed image */
    CCSize			originalSize_ = new CCSize();
    /** texture of the frame */
    CCTexture2D		texture_;
    public CCTexture2D getTexture() {
    	return texture_;
    }
    
    /** Flag shows that Zwoptex rotated texture for optimizations */
    Boolean rotated_;
    public Boolean getRotated() {
    	return rotated_;
    }

    /** Create a CCSpriteFrame with a texture, rect and offset.
      It is assumed that the frame was not trimmed.
      */
    public static CCSpriteFrame frame(CCTexture2D texture, CCRect rect, CCPoint offset) {
        return new CCSpriteFrame(texture, rect, offset);
    }

    /** Create a CCSpriteFrame with a texture, rect, offset and originalSize.
      The originalSize is the size in pixels of the frame before being trimmed.
      */
    public static CCSpriteFrame frame(CCTexture2D texture, CCRect rect, CCPoint offset, CCSize originalSize ){
        return new CCSpriteFrame(texture, rect, offset, originalSize, false);
    }
    
    /** Create a CCSpriteFrame with a texture, rect, offset, originalSize and rotated.
    	The originalSize is the size in pixels of the frame before being trimmed.
    */
    public static CCSpriteFrame frame(CCTexture2D texture, CCRect rect, Boolean rotated, CCPoint offset, CCSize originalSize ){
        return new CCSpriteFrame(texture, rect, offset, originalSize, rotated);
    }

    /** Initializes a CCSpriteFrame with a texture, rect and offset.
      It is assumed that the frame was not trimmed.
      */
    protected CCSpriteFrame (CCTexture2D texture, CCRect rect, CCPoint offset) {
        this(texture, rect, offset, rect.size, false);
    }

    /** Initializes a CCSpriteFrame with a texture, rect, offset and originalSize.
      The originalSize is the size in pixels of the frame before being trimmed.
      */
    protected CCSpriteFrame (CCTexture2D texture, CCRect rect, CCPoint offset, CCSize originalSize, Boolean rotated) {
        texture_ = texture;
        offset_.setPoint(offset);
        rect_.setRect(rect);
        originalSize_.setSize(originalSize);
        rotated_ = rotated;
    }

    public CCSpriteFrame copy() {
        CCSpriteFrame copy = new CCSpriteFrame(texture_, rect_, offset_, originalSize_, rotated_);
        return copy;
    }
}

