/*
Copyright (c) 2008, Luke Benstead.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.cocos2d.kazmath;

public class kmPlane {

	public float a, b, c, d;

	public static final int KM_PLANE_LEFT = 0;
	public static final int KM_PLANE_RIGHT = 1;
	public static final int KM_PLANE_BOTTOM = 2;
	public static final int KM_PLANE_TOP = 3;
	public static final int KM_PLANE_NEAR = 4;
	public static final int KM_PLANE_FAR = 5;

	enum POINT_CLASSIFICATION {
		POINT_INFRONT_OF_PLANE,
		POINT_BEHIND_PLANE,
		POINT_ON_PLANE,
	}

	public static float kmPlaneDot(final kmPlane pP, final kmVec4 pV) {
		//a*x + b*y + c*z + d*w

		return (pP.a * pV.x +
				pP.b * pV.y +
				pP.c * pV.z +
				pP.d * pV.w);
	}

	public static float kmPlaneDotCoord(final kmPlane pP, final kmVec3 pV) {
		return (pP.a * pV.x +
				pP.b * pV.y +
				pP.c * pV.z + pP.d);
	}

	public static float kmPlaneDotNormal(final kmPlane pP, final kmVec3 pV) {
		return (pP.a * pV.x +
				pP.b * pV.y +
				pP.c * pV.z);
	}

	public static kmPlane kmPlaneFromPointNormal(kmPlane pOut, final kmVec3 pPoint, final kmVec3 pNormal) {
		/*
			Planea = Nx
			Planeb = Ny
			Planec = Nz
			Planed = −N⋅P
		 */

		pOut.a = pNormal.x;
		pOut.b = pNormal.y;
		pOut.c = pNormal.z;
		pOut.d = -kmVec3.kmVec3Dot(pNormal, pPoint);

		return pOut;
	}

	public static kmPlane kmPlaneFromPoints(kmPlane pOut, final kmVec3 p1, final kmVec3 p2, final kmVec3 p3) {
		/*
			v = (B − A) × (C − A)
			n = 1⁄|v| v
			Outa = nx
			Outb = ny
			Outc = nz
			Outd = −n⋅A
		 */

		kmVec3 n = new kmVec3();
		kmVec3 v1 = new kmVec3();
		kmVec3 v2 = new kmVec3();
		kmVec3.kmVec3Subtract(v1, p2, p1); //Create the vectors for the 2 sides of the triangle
		kmVec3.kmVec3Subtract(v2, p3, p1);
		kmVec3.kmVec3Cross(n, v1, v2); //Use the cross product to get the normal

		kmVec3.kmVec3Normalize(n, n); //Normalize it and assign to pOut->m_N

		pOut.a = n.x;
		pOut.b = n.y;
		pOut.c = n.z;
		pOut.d = kmVec3.kmVec3Dot(kmVec3.kmVec3Scale(n, n, -1.0f), p1);

		return pOut;
	}

	public static kmVec3 kmPlaneIntersectLine(kmVec3 pOut, final kmPlane pP, final kmVec3 pV1, final kmVec3 pV2) {
		/*
			n = (Planea, Planeb, Planec)
			d = V − U
			Out = U − d⋅(Pd + n⋅U)⁄(d⋅n) [iff d⋅n ≠ 0]
		 */
		kmVec3 d = new kmVec3();
		assert false : "Not implemented";

		kmVec3.kmVec3Subtract(d, pV2, pV1); //Get the direction vector

		//TODO: Continue here!
		/*if (fabs(kmVec3Dot(&pP->m_N, &d)) > kmEpsilon)
		{
			//If we get here then the plane and line are parallel (i.e. no intersection)
			pOut = nullptr; //Set to nullptr

			return pOut;
		} */

		return null;
	}

	public static kmPlane kmPlaneNormalize(kmPlane pOut, final kmPlane pP) {
		kmVec3 n = new kmVec3();
		float l = 0;

		n.x = pP.a;
		n.y = pP.b;
		n.z = pP.c;

		l = 1.0f / kmVec3.kmVec3Length(n); //Get 1/length
		kmVec3.kmVec3Normalize(n, n); //Normalize the vector and assign to pOut

		pOut.a = n.x;
		pOut.b = n.y;
		pOut.c = n.z;

		pOut.d = pP.d * l; //Scale the D value and assign to pOut

		return pOut;
	}

	public static kmPlane kmPlaneScale(kmPlane pOut, final kmPlane pP, float s) {
		assert false : "Not implemented";
		return null;
	}

	/**
	 * Returns POINT_INFRONT_OF_PLANE if pP is infront of pIn. Returns
	 * POINT_BEHIND_PLANE if it is behind. Returns POINT_ON_PLANE otherwise
	 */
	public static POINT_CLASSIFICATION kmPlaneClassifyPoint(final kmPlane pIn, final kmVec3 pP) {
		// This function will determine if a point is on, in front of, or behind
		// the plane.  First we store the dot product of the plane and the point.
		float distance = pIn.a * pP.x + pIn.b * pP.y + pIn.c * pP.z + pIn.d;

		// Simply put if the dot product is greater than 0 then it is infront of it.
		// If it is less than 0 then it is behind it.  And if it is 0 then it is on it.
		if(distance > 0.001) return POINT_CLASSIFICATION.POINT_INFRONT_OF_PLANE;
		if(distance < -0.001) return POINT_CLASSIFICATION.POINT_BEHIND_PLANE;

		return POINT_CLASSIFICATION.POINT_ON_PLANE;
	}
}
