package org.cocos2d.actions.instant;

import org.cocos2d.base_nodes.CCNode;
import org.cocos2d.cocoa.CCGeometry.CCPoint;

/**
 * Places the node in a certain position
 */
public class CCPlace extends CCInstantAction {
    private CCPoint position = new CCPoint();

    public static CCPlace action(CCPoint pnt) {
        return new CCPlace(pnt);
    }

    /**
     * creates a Place action with a position
     */
    protected CCPlace(CCPoint pnt) {
        position.setPoint(pnt);
    }

    public CCPlace copy() {
        return new CCPlace(position);
    }

    public void start(CCNode aTarget) {
        super.start(aTarget);
        target.setPosition(position);
    }
}
