package org.cocos2d.tests;

import java.util.ArrayList;

import org.cocos2d.CCDirector;
import org.cocos2d.actions.base.CCRepeatForever;
import org.cocos2d.actions.ease.CCEaseElasticOut;
import org.cocos2d.actions.interval.CCIntervalAction;
import org.cocos2d.actions.interval.CCJumpBy;
import org.cocos2d.actions.interval.CCMoveBy;
import org.cocos2d.actions.interval.CCRotateBy;
import org.cocos2d.actions.interval.CCSequence;
import org.cocos2d.actions.interval.CCTintBy;
import org.cocos2d.config.ccMacros;
import org.cocos2d.layers.CCLayer;
import org.cocos2d.layers.CCMultiplexLayer;
import org.cocos2d.layers.CCScene;
import org.cocos2d.lib.Cocos2dActivity;
import org.cocos2d.menus.CCMenu;
import org.cocos2d.menus.CCMenuItem;
import org.cocos2d.menus.CCMenuItemFont;
import org.cocos2d.menus.CCMenuItemImage;
import org.cocos2d.menus.CCMenuItemLabel;
import org.cocos2d.menus.CCMenuItemSprite;
import org.cocos2d.menus.CCMenuItemToggle;
import org.cocos2d.nodes.CCLabelAtlas;
import org.cocos2d.nodes.CCNode;
import org.cocos2d.nodes.CCSprite;
import org.cocos2d.opengl.CCBitmapFontAtlas;
import org.cocos2d.types.CGPoint;
import org.cocos2d.types.CGRect;
import org.cocos2d.types.CGSize;
import org.cocos2d.types.ccColor3B;

import android.os.Bundle;

public class MenuTest extends Cocos2dActivity {
	// private static final String TAG = MenuTest.class.getSimpleName();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// set landscape mode
		CCDirector.sharedDirector().setLandscape(false);

		// show Stats
		CCDirector.sharedDirector().setDisplayStats(true);

		// frames per second
		CCDirector.sharedDirector().setAnimationInterval(1.0f / 60.0f);

		CCScene scene = CCScene.node();

		CCMultiplexLayer layer = CCMultiplexLayer.node(new Layer1(), new Layer2(), new Layer3(), new Layer4());
		scene.addChild(layer, 0);

		CCDirector.sharedDirector().runWithScene(scene);
	}

	public static final int kTagMenu = 1;
	public static final int kTagMenu0 = 0;
	public static final int kTagMenu1 = 1;

	public static final int kTagSpriteManager = 1;

	static class Layer1 extends CCLayer {
		CCMenuItem disabledItem;

		public Layer1() {
			CCMenuItemFont.setFontSize(30);
			CCMenuItemFont.setFontName("DroidSans");

			// Font Item
			CCSprite spriteNormal = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*2,115,23));
			CCSprite spriteSelected = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*1,115,23));
			CCSprite spriteDisabled = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*0,115,23));
			CCMenuItemSprite item1 = CCMenuItemSprite.create(spriteNormal, spriteSelected, spriteDisabled, this, "menuCallback");

			// Image Item
			CCMenuItem item2 = CCMenuItemImage.create("SendScoreButton.png", "SendScoreButtonPressed.png", this, "menuCallback2");

			// Label Item (LabelAtlas)
			CCLabelAtlas labelAtlas = CCLabelAtlas.create("0123456789", "fps_images.png", 16, 24, '.');
			CCMenuItemLabel item3 = CCMenuItemLabel.create(labelAtlas, this, "menuCallbackDisabled");
			item3.setDisabledColor(ccColor3B.ccc3(32, 32, 64));
			item3.setColor(ccColor3B.ccc3(200,200,255));

			// Font Item
			CCMenuItem item4 = CCMenuItemFont.create("I toggle enable items", this, "menuCallbackEnable");

			// Label Item (BitmapFontAtlas)
			CCBitmapFontAtlas label = CCBitmapFontAtlas.bitmapFontAtlas("configuration", "bitmapFontTest3.fnt");
			CCMenuItemLabel item5 = CCMenuItemLabel.create(label, this, "menuCallbackConfig");

			// Testing issue #500
			item5.setScale(0.8f);

			// Font Item
			CCMenuItemFont item6 = CCMenuItemFont.create("Quit", this, "onQuit");

			CCIntervalAction color_action = CCTintBy.action(0.5f, ccColor3B.ccc3(0, -255, -255));
			CCIntervalAction color_back = color_action.reverse();
			CCIntervalAction seq = CCSequence.actions(color_action, color_back);
			item6.runAction(CCRepeatForever.action(seq));

			CCMenu menu = CCMenu.create(item1, item2, item3, item4, item5, item6);
			menu.alignItemsVertically();

			// elastic effect
			CGSize s = CCDirector.sharedDirector().getWinSizeInPixels();
			int i=0;
			for (CCNode child : menu.getChildren()) {
				final CGPoint dstPoint = child.getPosition();
				int offset = (int) (s.width/2 + 20);
				if( i % 2 == 0) {
					offset = -offset;
				}
				child.setPosition( dstPoint.x + offset, dstPoint.y);
				child.runAction(CCEaseElasticOut.action(CCMoveBy.action(2.0f, CGPoint.ccp(dstPoint.x - offset,0)), 0.35f));
				i++;
			}

			disabledItem = item3;
			disabledItem.setEnabled(false);

			addChild(menu);
		}

		public void menuCallback(Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(1);
		}

		public void menuCallbackConfig(Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(3);
		}

		public void menuCallbackDisabled(Object sender) {
		}

		public void menuCallbackEnable(Object sender) {
			disabledItem.setEnabled(!disabledItem.isEnabled());
		}

		public void menuCallback2(Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(2);
		}

		public void onQuit (Object sender) {
			ccMacros.CC_DIRECTOR_END();
//			System.exit(0);
		}
	}

	static class Layer2 extends CCLayer {
		CGPoint centeredMenu;
		boolean alignedH;

		public void alignMenusH() {
			for(int i=0;i<2;i++) {
				CCMenu menu = (CCMenu) getChildByTag(100+i);
				menu.setPosition(centeredMenu);
				if(i==0) {
					// TIP: if no padding, padding = 5
					menu.alignItemsHorizontally();
					final CGPoint p = menu.getPosition();
					menu.setPosition(CGPoint.ccpAdd(p, CGPoint.ccp(0,30)));
				} else {
					// TIP: but padding is configurable
					menu.alignItemsHorizontallyWithPadding(40);
					final CGPoint p = menu.getPosition();
					menu.setPosition(CGPoint.ccpSub(p, CGPoint.ccp(0,30)));
				}
			}
		}

		public void alignMenusV() {
			for(int i=0;i<2;i++) {
				CCMenu menu = (CCMenu) getChildByTag(100+i);
				menu.setPosition(centeredMenu);
				if(i==0) {
					// TIP: if no padding, padding = 5
					menu.alignItemsVertically();
					final CGPoint p = menu.getPosition();
					menu.setPosition(CGPoint.ccpAdd(p, CGPoint.ccp(100,0)));			
				} else {
					// TIP: but padding is configurable
					menu.alignItemsVerticallyWithPadding(40);	
					final CGPoint p = menu.getPosition();
					menu.setPosition(CGPoint.ccpSub(p, CGPoint.ccp(100,0)));
				}
			}
		}

		public Layer2() {
			for( int i=0;i < 2;i++ ) {
				CCMenuItemImage item1 = CCMenuItemImage.create("btn-play-normal.png", "btn-play-selected.png", this, "menuCallbackBack");
				CCMenuItemImage item2 = CCMenuItemImage.create("btn-highscores-normal.png", "btn-highscores-selected.png", this, "menuCallbackOpacity");
				CCMenuItemImage item3 = CCMenuItemImage.create("btn-about-normal.png", "btn-about-selected.png", this, "menuCallbackAlign");

				item1.setScaleX(1.5f);
				item2.setScaleY(0.5f);
				item3.setScaleX(0.5f);

				CCMenu menu = CCMenu.create(item1, item2, item3);

				menu.setTag(kTagMenu);

				addChild(menu, 0, 100+i);
				centeredMenu = menu.getPosition();
			}

			alignedH = true;
			alignMenusH();
		}

		public void menuCallbackBack (Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(0);
		}

		public void menuCallbackOpacity (Object sender) {
			CCMenuItem item = (CCMenuItem)sender;
			CCMenu menu = (CCMenu)item.getParent();
			int opacity = menu.getOpacity();
			if (opacity == 128) {
				menu.setOpacity((byte) 255);
			} else {
				menu.setOpacity((byte) 128);
			}
		}

		public void menuCallbackAlign (Object sender) {
			alignedH = ! alignedH;

			if( alignedH ) {
				alignMenusH();
			} else {
				alignMenusV();
			}
		}
	}

	static class Layer3 extends CCLayer {
		CCMenuItem disabledItem;

		public Layer3() {
			CCMenuItemFont.setFontName("DroidSans");
			CCMenuItemFont.setFontSize(28);

			CCBitmapFontAtlas label = CCBitmapFontAtlas.bitmapFontAtlas("Enable AtlasItem", "bitmapFontTest3.fnt");
			CCMenuItemLabel item1 = CCMenuItemLabel.create(label, this, "menuCallback2");
			CCMenuItemFont item2 = CCMenuItemFont.create("--- Go Back ---", this, "menuCallback");

			CCSprite spriteNormal = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*2,115,23));
			CCSprite spriteSelected = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*1,115,23));
			CCSprite spriteDisabled = CCSprite.sprite("menuitemsprite.png", CGRect.make(0,23*0,115,23));

			CCMenuItemSprite item3 = CCMenuItemSprite.create(spriteNormal, spriteSelected, spriteDisabled, this, "menuCallback3");
			disabledItem = item3;
			disabledItem.setEnabled(false);

			CCMenu menu = CCMenu.create(item1, item2, item3);	
			menu.setPosition(0,0);

			CGSize s = CCDirector.sharedDirector().getWinSizeInPixels();

			item1.setPosition(s.width/2 - 150, s.height/2);
			item2.setPosition(s.width/2 - 200, s.height/2);
			item3.setPosition(s.width/2, s.height/2 - 100);

			CCIntervalAction jump = CCJumpBy.action(3.0f, CGPoint.ccp(400,0), 50, 4);
			item2.runAction(CCRepeatForever.action(CCSequence.actions(jump, jump.reverse())));
			CCIntervalAction spin1 = CCRotateBy.action(3.0f, 360);
			CCIntervalAction spin2 = spin1.copy();
			CCIntervalAction spin3 = spin1.copy();

			item1.runAction(CCRepeatForever.action(spin1));
			item2.runAction(CCRepeatForever.action(spin2));
			item3.runAction(CCRepeatForever.action(spin3));

			addChild(menu);
		}

		public void menuCallback(Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(0);
		}

		public void menuCallback2(Object sender) {
			ccMacros.CCLOG("menuTest", "Label clicked. Toogling Sprite");
			disabledItem.setEnabled(!disabledItem.isEnabled());
			disabledItem.stopAllActions();
		}

		public void menuCallback3(Object sender) {
			ccMacros.CCLOG("menuTest", "MenuItemSprite clicked");
		}
	}

	static class Layer4 extends CCLayer {
		public Layer4() {
			CCMenuItemFont.setFontName("DroidSerif");
			CCMenuItemFont.setFontSize(18);
			CCMenuItemFont title1 = CCMenuItemFont.create("Sound");
			title1.setEnabled(false);

			CCMenuItemFont.setFontName("DroidSans");
			CCMenuItemFont.setFontSize(34);
			CCMenuItemToggle item1 = CCMenuItemToggle.createWithTarget(this, "menuCallback",
					CCMenuItemFont.create("On"),
					CCMenuItemFont.create("Off")
					);

			CCMenuItemFont.setFontName("DroidSerif");
			CCMenuItemFont.setFontSize(18);
			CCMenuItemFont title2 = CCMenuItemFont.create("Music");
			title2.setEnabled(false);

			CCMenuItemFont.setFontName("DroidSans");
			CCMenuItemFont.setFontSize(34);
			CCMenuItemToggle item2 = CCMenuItemToggle.createWithTarget(this, "menuCallback",
					CCMenuItemFont.create("On"),
					CCMenuItemFont.create("Off")
					);

			CCMenuItemFont.setFontName("DroidSerif");
			CCMenuItemFont.setFontSize(18);
			CCMenuItemFont title3 = CCMenuItemFont.create("Quality");
			title3.setEnabled(false);

			CCMenuItemFont.setFontName("DroidSans");
			CCMenuItemFont.setFontSize(34);
			CCMenuItemToggle item3 = CCMenuItemToggle.createWithTarget(this, "menuCallback",
					CCMenuItemFont.create("High"),
					CCMenuItemFont.create("Low")
					);

			CCMenuItemFont.setFontName("DroidSerif");
			CCMenuItemFont.setFontSize(18);
			CCMenuItemFont title4 = CCMenuItemFont.create("Orientation");
			title4.setEnabled(false);

			CCMenuItemFont.setFontName("DroidSans");
			CCMenuItemFont.setFontSize(34);
			CCMenuItemToggle item4 = CCMenuItemToggle.createWithTarget(this, "menuCallback",
					CCMenuItemFont.create("Off")
					);

			ArrayList<CCMenuItemFont> more_items = new ArrayList<CCMenuItemFont>();
			more_items.add(CCMenuItemFont.create("33%"));
			more_items.add(CCMenuItemFont.create("66%"));
			more_items.add(CCMenuItemFont.create("100%"));

			// TIP: you can manipulate the items like any other NSMutableArray
			item4.getSubItems().addAll(more_items);

			// you can change the one of the items by doing this
			item4.setSelectedIndex(2);

			CCMenuItemFont.setFontName("DroidSerif");
			CCMenuItemFont.setFontSize(34);
			CCBitmapFontAtlas label = CCBitmapFontAtlas.bitmapFontAtlas("go back", "bitmapFontTest3.fnt");
			CCMenuItemLabel back = CCMenuItemLabel.create(label, this, "backCallback");

			CCMenu menu = CCMenu.create(title1, title2, item1, item2, title3, title4, item3, item4, back); // 9 items.
			menu.alignItemsInColumns(2, 2, 2, 2, 1);

			addChild(menu);
		}

		public void menuCallback (Object sender) {
			// CCMenuItem item = (CCMenuItem)sender;
			// String str = String.format("selected item: %s index:%d", item.selectedItem, item.selectedIndex);
			ccMacros.CCLOG("menuTest", "selected item");
		}

		public void backCallback (Object sender) {
			((CCMultiplexLayer)getParent()).switchTo(0);
		}
	}
}
