package org.cocos2d.protocols;

import org.cocos2d.opengl.CCTexture2D;

/** 
 * CCNode objects that uses a CCTexture2D to render the images.
 * The texture can have a blending function.
 * If the texture has alpha premultiplied the default blending function is:
 *   src=GL_ONE dst= GL_ONE_MINUS_SRC_ALPHA
 * else
 *   src=GL_SRC_ALPHA dst= GL_ONE_MINUS_SRC_ALPHA
 * But you can change the blending function at any time.
 */
public interface CCTextureProtocol extends CCBlendProtocol {
	/**
	 * Returns the currently used texture
	 *
	 * @return  The texture that is currenlty being used.
	 */
	public CCTexture2D getTexture();

	/**
	 * Sets a new texuture. It will be retained.
	 *
	 * @param   texture A valid CCTexture2D object, which will be applied to this sprite object.
	 */
	public void setTexture(CCTexture2D texture);
}

