package org.cocos2d.protocols;

import org.cocos2d.types.ccColor3B;


/**
 * RGBA protocol that affects CCNode's color and opacity
 */
public interface CCRGBAProtocol {

	/** 
	 * Changes the color with R,G,B bytes
	 *
	 * @param color Example: ccc3(255,100,0) means R=255, G=100, B=0
	 */
	public void setColor(ccColor3B color);

	/**
	 * Returns color that is currently used.
	 *
	 * @return The ccColor3B contains R,G,B bytes.
	 */
	public ccColor3B getColor();

	/**
	 * Returns the displayed color.
	 *
	 * @return The ccColor3B contains R,G,B bytes.
	 */
	public ccColor3B getDisplayedColor();

	/**
	 * Returns the displayed opacity.
	 *
	 * @return  The opacity of sprite, from 0 ~ 255
	 */
	public int getDisplayedOpacity();

	/**
	 * Returns the opacity.
	 *
	 * The opacity which indicates how transparent or opaque this node is.
	 * 0 indicates fully transparent and 255 is fully opaque.
	 *
	 * @return  The opacity of sprite, from 0 ~ 255
	 */
	public int getOpacity();

	/**
	 * Changes the opacity.
	 *
	 * @param   value   Goes from 0 to 255, where 255 means fully opaque and 0 means fully transparent.
	 */
	public void setOpacity(int opacity);

	// optional

	/**
	 * Changes the OpacityModifyRGB property. 
	 * If thie property is set to true, then the rendered color will be affected by opacity.
	 * Normally, r = r * opacity/255, g = g * opacity/255, b = b * opacity/255.
	 *
	 * @param   bValue  true then the opacity will be applied as: glColor(R,G,B,opacity);
	 *                  false then the opacity will be applied as: glColor(opacity, opacity, opacity, opacity);
	 */
	public void setOpacityModifyRGB(boolean bValue);

	/**
	 * Returns whether or not the opacity will be applied using glColor(R,G,B,opacity) 
	 * or glColor(opacity, opacity, opacity, opacity)
	 *
	 * @return  Returns opacity modify flag.
	 */
	public boolean isOpacityModifyRGB();

	/**
	 *  whether or not color should be propagated to its children.
	 */
	public boolean isCascadeColorEnabled();

	public void setCascadeColorEnabled(boolean cascadeColorEnabled);

	/** 
	 *  recursive method that updates display color 
	 */
	public void updateDisplayedColor(ccColor3B color);

	/** 
	 *  whether or not opacity should be propagated to its children.
	 */
	public boolean isCascadeOpacityEnabled();
	public void setCascadeOpacityEnabled(boolean cascadeOpacityEnabled);

	/**
	 *  recursive method that updates the displayed opacity.
	 */
	public void updateDisplayedOpacity(int opacity);
}
